/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.MQTT;

public class MQTTForward {
    private String host;
    private int port = 1883;
    private String user;
    private String pass;
    private int max_queue_size = 1000;
    private Object lock = new Object();
    private ArrayList<Entry> queue = new ArrayList();
    private MQTT client;
    private Server server;
    private boolean active;

    public void start(String host, int port) {
        this.start(host, port, null, null);
    }

    public void start(String host, String user, String pass) {
        this.start(host, 1883, user, pass);
    }

    public void start(String host, int port, String user, String pass) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.pass = pass;
        this.active = true;
        this.server = new Server();
        this.server.start();
    }

    public void stop() {
        this.active = false;
    }

    public void setMaxQueueSize(int size) {
        if (size < 100) {
            size = 100;
        }
        this.max_queue_size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String topic, String msg) {
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.size() > this.max_queue_size) {
                JFLog.log("Error:MQTTForward Queue > " + this.max_queue_size);
                return;
            }
            this.queue.add(new Entry(topic, msg));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry remove() {
        if (this.active) {
            Object object = this.lock;
            synchronized (object) {
                if (this.queue.size() == 0) {
                    try {
                        this.lock.wait(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
                Entry entry = this.queue.remove(0);
                return entry;
            }
        }
        return null;
    }

    private class Server
    extends Thread {
        private Server() {
        }

        @Override
        public void run() {
            while (MQTTForward.this.active) {
                Entry entry = MQTTForward.this.remove();
                if (entry == null) {
                    JF.sleep(1000);
                    continue;
                }
                try {
                    if (MQTTForward.this.client != null && !MQTTForward.this.client.isConnected()) {
                        MQTTForward.this.client.disconnect();
                        MQTTForward.this.client = null;
                    }
                    while (MQTTForward.this.client == null) {
                        MQTTForward.this.client = new MQTT();
                        if (MQTTForward.this.client.connect(MQTTForward.this.host, MQTTForward.this.port)) {
                            if (MQTTForward.this.user != null && MQTTForward.this.pass != null) {
                                MQTTForward.this.client.connect(MQTTForward.this.user, MQTTForward.this.pass);
                                break;
                            }
                            MQTTForward.this.client.connect();
                            break;
                        }
                        MQTTForward.this.client = null;
                        if (MQTTForward.this.client.isConnected()) continue;
                        MQTTForward.this.client = null;
                        JF.sleep(1000);
                    }
                    MQTTForward.this.client.publish(entry.topic, entry.msg);
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }
    }

    private static class Entry {
        public String topic;
        public String msg;

        public Entry(String topic, String msg) {
            this.topic = topic;
            this.msg = msg;
        }
    }
}

