/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import java.io.RandomAccessFile;
import javaforce.JFLog;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class Media {
    private RandomAccessFile raf;
    private Header header;
    private boolean write;
    private int currentFrame;
    private int[] indexes = new int[4096];
    private long[] tses = new long[4096];
    private Packet frame;
    private long ts_keyframe;
    private static final int JFAV = 1246118230;
    private static final int V32 = 32;
    private static final int V64 = 64;
    private static final long V32_max_file_size = 0x80000000L;
    private static final int max_streams = 16;
    public static boolean debug = false;
    private static int FLAG_AUDIO = 1;
    private static int FLAG_VIDEO = 2;
    private static int FLAG_MAX_VALUE = 3;

    public boolean open(String file) {
        return this.open(file, "r");
    }

    private boolean open(String file, String mode) {
        if (this.raf != null) {
            return false;
        }
        this.frame = new Packet();
        this.frame.data = new byte[4096];
        try {
            this.write = false;
            this.currentFrame = 0;
            this.raf = new RandomAccessFile(file, mode);
            this.header = this.readHeader();
            if (this.header == null) {
                this.abort();
                return false;
            }
            this.readIndexes();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean create(String file, int[] streamIDs, CodecInfo info) {
        if (this.raf != null) {
            return false;
        }
        if (streamIDs == null || streamIDs.length == 0 || streamIDs.length > 16) {
            return false;
        }
        this.header = new Header();
        this.header.streamCount = streamIDs.length;
        this.header.streams = streamIDs;
        if (info != null) {
            this.header.info = info;
            if (info.chs != 0 && info.freq != 0) {
                this.header.flags |= FLAG_AUDIO;
            }
            if (info.width != 0 && info.height != 0) {
                this.header.flags |= FLAG_VIDEO;
            }
        }
        try {
            this.write = true;
            this.currentFrame = 0;
            this.ts_keyframe = 0L;
            this.raf = new RandomAccessFile(file, "rw");
            this.raf.setLength(0L);
            if (!this.writeHeader()) {
                this.abort();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean create(String file, int[] streamIDs) {
        return this.create(file, streamIDs, null);
    }

    public boolean append(String file) {
        if (this.raf != null) {
            return false;
        }
        if (!this.open(file, "rw")) {
            return false;
        }
        try {
            this.raf.seek(this.header.indexOffset);
            this.raf.setLength(this.raf.getFilePointer());
            this.write = true;
            this.currentFrame = this.header.keyFrames;
            this.ts_keyframe = this.tses[this.currentFrame - 1];
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            this.abort();
            return false;
        }
    }

    public boolean close() {
        if (this.raf == null) {
            return false;
        }
        if (this.write) {
            this.writeIndexes();
            this.updateHeader();
        }
        try {
            this.raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.raf = null;
        return true;
    }

    private void abort() {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.write = false;
    }

    public int[] getStreamIDs() {
        return this.header.streams;
    }

    public int getKeyFrameCount() {
        return this.header.keyFrames;
    }

    public int getAllFrameCount() {
        return this.header.allFrames;
    }

    public long getTimeBase() {
        if (this.write) {
            return 0L;
        }
        return this.tses[0];
    }

    public CodecInfo getCodecInfo() {
        return this.header.info;
    }

    public boolean seekFrame(int frame) {
        if (this.write) {
            return false;
        }
        try {
            if (frame >= this.header.keyFrames) {
                return false;
            }
            int index = this.indexes[frame];
            this.raf.seek(index);
            this.currentFrame = frame;
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean seekTime(long ts) {
        if (this.write) {
            return false;
        }
        for (int idx = 0; idx < this.header.keyFrames; ++idx) {
            if (this.tses[idx] < ts) continue;
            return this.seekFrame(idx);
        }
        return false;
    }

    public Packet readFrame() {
        if (this.write) {
            return null;
        }
        try {
            long pos = this.raf.getFilePointer();
            if (pos >= (long)this.header.indexOffset) {
                return null;
            }
            if (pos == (long)this.indexes[this.currentFrame]) {
                this.ts_keyframe = this.frame.ts = this.tses[this.currentFrame];
                if (debug) {
                    JFLog.log("Media.readFrame():key_frame_ts=" + this.frame.ts + "@" + this.currentFrame);
                }
                ++this.currentFrame;
            }
            this.frame.stream = this.raf.readByte();
            short delta_ts = this.raf.readShort();
            if (debug) {
                JFLog.log("Media.readFrame():delta_ts=" + delta_ts);
            }
            this.frame.ts = this.ts_keyframe + (long)delta_ts;
            this.frame.length = this.raf.readInt();
            while (this.frame.length > this.frame.data.length) {
                this.frame.data = new byte[this.frame.data.length << 1];
            }
            this.raf.read(this.frame.data, 0, this.frame.length);
            return this.frame;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private void growIndexes(boolean keep) {
        while (this.indexes.length <= this.header.keyFrames) {
            int[] old_indexes = this.indexes;
            this.indexes = new int[this.indexes.length << 1];
            long[] old_tses = this.tses;
            this.tses = new long[this.tses.length << 1];
            if (!keep) continue;
            System.arraycopy(old_indexes, 0, this.indexes, 0, old_indexes.length);
            System.arraycopy(old_tses, 0, this.tses, 0, old_tses.length);
        }
    }

    public boolean writeFrame(int stream, byte[] data, int offset, int length, long ts, boolean keyFrame) {
        try {
            long file_offset = this.raf.getFilePointer();
            long file_end = file_offset + (long)length + 5L;
            if (file_end >= 0x80000000L) {
                JFLog.log("Media:max_file_size reached (2GB)");
                return false;
            }
            if (stream == 0) {
                if (keyFrame) {
                    if (this.indexes.length == this.header.keyFrames) {
                        this.growIndexes(true);
                    }
                    this.indexes[this.header.keyFrames] = (int)file_offset;
                    this.tses[this.header.keyFrames] = ts;
                    ++this.header.keyFrames;
                    this.ts_keyframe = ts;
                }
                ++this.header.allFrames;
            }
            this.raf.writeByte(stream);
            this.raf.writeShort((short)(ts - this.ts_keyframe));
            this.raf.writeInt(length);
            this.raf.write(data, offset, length);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private Header readHeader() {
        Header header = new Header();
        try {
            header.magic = this.raf.readInt();
            if (header.magic != 1246118230) {
                throw new Exception("invalid file");
            }
            header.version = this.raf.readInt();
            if (header.version != 32) {
                throw new Exception("invalid file");
            }
            header.keyFrames = this.raf.readInt();
            header.allFrames = this.raf.readInt();
            header.indexOffset = this.raf.readInt();
            header.flags = this.raf.readInt();
            if (header.flags > FLAG_MAX_VALUE) {
                throw new Exception("invalid file");
            }
            if (header.flags > 0) {
                header.info = new CodecInfo();
                if ((header.flags & FLAG_AUDIO) != 0) {
                    header.info.chs = this.raf.readByte();
                    header.info.freq = this.raf.readInt();
                    header.info.bits = this.raf.readByte();
                }
                if ((header.flags & FLAG_VIDEO) != 0) {
                    header.info.width = this.raf.readInt();
                    header.info.height = this.raf.readInt();
                    header.info.fps = this.raf.readFloat();
                }
            }
            header.streamCount = this.raf.readInt();
            if (header.streamCount < 1 || header.streamCount > 16) {
                throw new Exception("invalid file");
            }
            header.streams = new int[header.streamCount];
            for (int idx = 0; idx < header.streamCount; ++idx) {
                header.streams[idx] = this.raf.readInt();
            }
            return header;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private boolean writeHeader() {
        try {
            this.raf.writeInt(1246118230);
            this.raf.writeInt(32);
            this.raf.writeInt(this.header.keyFrames);
            this.raf.writeInt(this.header.allFrames);
            this.raf.writeInt(this.header.indexOffset);
            this.raf.writeInt(this.header.flags);
            if (this.header.info != null) {
                if ((this.header.flags & FLAG_AUDIO) != 0) {
                    this.raf.writeByte(this.header.info.chs);
                    this.raf.writeInt(this.header.info.freq);
                    this.raf.writeByte(this.header.info.bits);
                }
                if ((this.header.flags & FLAG_VIDEO) != 0) {
                    this.raf.writeInt(this.header.info.width);
                    this.raf.writeInt(this.header.info.height);
                    this.raf.writeFloat(this.header.info.fps);
                }
            }
            this.raf.writeInt(this.header.streamCount);
            for (int idx = 0; idx < this.header.streamCount; ++idx) {
                this.raf.writeInt(this.header.streams[idx]);
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private boolean updateHeader() {
        try {
            this.raf.seek(8L);
            this.raf.writeInt(this.header.keyFrames);
            this.raf.writeInt(this.header.allFrames);
            this.raf.writeInt(this.header.indexOffset);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private boolean readIndexes() {
        try {
            this.indexes = new int[4096];
            this.tses = new long[4096];
            this.growIndexes(false);
            this.raf.seek(this.header.indexOffset);
            for (int idx = 0; idx < this.header.keyFrames; ++idx) {
                this.indexes[idx] = this.raf.readInt();
                this.tses[idx] = this.raf.readLong();
            }
            int index = this.indexes[0];
            if (index < 0) {
                index *= -1;
            }
            this.raf.seek(index);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private boolean writeIndexes() {
        try {
            this.header.indexOffset = (int)this.raf.length();
            this.raf.seek(this.header.indexOffset);
            for (int idx = 0; idx < this.header.keyFrames; ++idx) {
                this.raf.writeInt(this.indexes[idx]);
                this.raf.writeLong(this.tses[idx]);
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private void view() {
        Packet frame;
        JFLog.log("# key frames=" + this.header.keyFrames);
        for (int a = 0; a < this.header.keyFrames; ++a) {
            JFLog.log("frame = " + a);
            JFLog.log(" ts[] = " + this.tses[a]);
            JFLog.log("idx[] = " + this.indexes[a]);
        }
        while ((frame = this.readFrame()) != null) {
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JFLog.log("usage:Media view file.jfav");
            System.exit(0);
        }
        debug = true;
        switch (args[0]) {
            case "view": {
                Media media = new Media();
                media.open(args[1]);
                media.view();
                break;
            }
            default: {
                JFLog.log("Unknown command:" + args[0]);
            }
        }
    }

    private static class Header {
        int magic;
        int version;
        int keyFrames;
        int allFrames;
        int indexOffset;
        int flags;
        CodecInfo info;
        int streamCount;
        int[] streams;

        private Header() {
        }
    }
}

