/*
 * Decompiled with CFR 0.152.
 */
package javaforce.net;

import java.net.InetAddress;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.UByte;
import javaforce.net.IP6;

public class IP4
implements Comparable<IP4> {
    public byte[] ip = new byte[4];

    public IP4() {
    }

    public IP4(String str) {
        this.setIP(str);
    }

    public IP4(IP4 ip4) {
        this.setIP(ip4);
    }

    public static boolean isIP(String str) {
        String[] os;
        if (str.equals("0:0:0:0:0:0:0:1")) {
            str = "127.0.0.1";
        }
        if ((os = str.split("[.]", -1)).length != 4) {
            return false;
        }
        try {
            for (String o : os) {
                if (o.length() > 3) {
                    return false;
                }
                if (!o.equals(JF.filter(o, JF.filter_numeric))) {
                    return false;
                }
                int val = Integer.parseInt(o);
                if (val >= 0 && val <= 255) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean setIP(String str) {
        if (str.equals("0:0:0:0:0:0:0:1")) {
            str = "127.0.0.1";
        }
        if (!IP4.isIP(str)) {
            return false;
        }
        String[] ips = str.split("[.]", -1);
        try {
            for (int a = 0; a < 4; ++a) {
                this.ip[a] = UByte.valueOf(ips[a]);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean setIP(InetAddress addr) {
        return this.setIP(addr.getHostAddress());
    }

    public boolean setIP(IP4 o) {
        for (int a = 0; a < 4; ++a) {
            this.ip[a] = o.ip[a];
        }
        return true;
    }

    public void mask(IP4 o) {
        for (int a = 0; a < 4; ++a) {
            int n = a;
            this.ip[n] = (byte)(this.ip[n] & o.ip[a]);
        }
    }

    public void or(IP4 o) {
        for (int a = 0; a < 4; ++a) {
            int n = a;
            this.ip[n] = (byte)(this.ip[n] | o.ip[a]);
        }
    }

    public boolean allZero() {
        for (int a = 0; a < 4; ++a) {
            if (this.ip[a] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean allOne() {
        for (int a = 0; a < 4; ++a) {
            if (this.ip[a] == -1) continue;
            return false;
        }
        return true;
    }

    public InetAddress toInetAddress() {
        try {
            return InetAddress.getByName(this.toIP4String());
        }
        catch (Exception e) {
            JFLog.log("Error:IP4.toInetAddress() failed:" + this.toIP4String());
            return null;
        }
    }

    public String toIP4String() {
        return String.format("%d.%d.%d.%d", this.ip[0] & 0xFF, this.ip[1] & 0xFF, this.ip[2] & 0xFF, this.ip[3] & 0xFF);
    }

    public String toString() {
        return this.toIP4String();
    }

    public int toInt() {
        int value = this.ip[0] & 0xFF;
        value <<= 8;
        value += this.ip[1] & 0xFF;
        value <<= 8;
        value += this.ip[2] & 0xFF;
        value <<= 8;
        return value += this.ip[3] & 0xFF;
    }

    public boolean isEmpty() {
        for (int a = 0; a < 4; ++a) {
            if (this.ip[a] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isMulticastAddress() {
        return this.toInetAddress().isMulticastAddress();
    }

    public IP6 toIP6() {
        IP6 ip6 = new IP6();
        ip6.ip[5] = -1;
        ip6.ip[6] = (short)((this.ip[0] << 8) + (this.ip[1] & 0xFF));
        ip6.ip[7] = (short)((this.ip[2] << 8) + (this.ip[3] & 0xFF));
        return ip6;
    }

    public static IP4 getLoopbackIP() {
        IP4 ip4 = new IP4();
        ip4.ip[0] = 127;
        ip4.ip[3] = 1;
        return ip4;
    }

    public static void test(String ip, boolean expect) {
        IP4 ip4 = new IP4();
        boolean res = ip4.setIP(ip);
        if (res != expect) {
            JFLog.log("failed:" + ip);
        }
        JFLog.log(IP4.isIP(ip) + ":" + ip + ":" + ip4.toString());
    }

    public static void main(String[] args) {
        IP4.test("1.1.1.1", true);
        IP4.test("127.0.0.1", true);
        IP4.test("255.255.255.0", true);
        IP4.test("1.1.1.-1", false);
        IP4.test("127.a.0.1", false);
        IP4.test("127..0.1", false);
        IP4.test("127.0.0.1.", false);
        JFLog.log("loopback=" + IP4.getLoopbackIP().toString());
    }

    @Override
    public int compareTo(IP4 o) {
        for (int a = 0; a < 4; ++a) {
            if (this.ip[a] == o.ip[a]) continue;
            return -1;
        }
        return 0;
    }
}

