/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.util.Calendar;
import javaforce.ConsoleOutput;
import javaforce.ansi.server.ANSI;

public class ScriptEx {
    public static String[] args;

    public static void main(String[] args) {
        ScriptEx.args = args;
        ANSI.enableConsoleMode();
        ConsoleOutput.install();
        int ret = 0;
        try {
            new ScriptEx().run();
        }
        catch (Throwable e) {
            e.printStackTrace();
            ret = 1;
        }
        ANSI.disableConsoleMode();
        System.exit(ret);
    }

    public void usage() {
        System.out.println("ScriptEx command [args]");
        System.out.println("  get-week : return current week in year (1-52)");
        System.out.println("  get-epoch-ms : return current epoch (1970) in ms");
        System.out.println("  get-epoch-sec : return current epoch (1970) in seconds");
        System.out.println("  get-epoch-ldap : return current epoch (1601) in 100-ns");
    }

    public void run() {
        if (args == null || args.length < 1) {
            this.usage();
            return;
        }
        switch (args[0]) {
            case "get-week": {
                Calendar cal = Calendar.getInstance();
                System.out.println(String.format("%d", cal.get(3)));
                return;
            }
            case "get-epoch-ms": {
                System.out.println(System.currentTimeMillis());
                return;
            }
            case "get-epoch-sec": {
                System.out.println(System.currentTimeMillis() / 1000L);
                return;
            }
            case "get-epoch-ldap": {
                System.out.println((System.currentTimeMillis() - 11644473600000L) * 10000L);
                return;
            }
        }
        System.out.println("Unknown command:" + args[0]);
        this.usage();
    }
}

