/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javaforce.awt.GetPassword;

public class Sudo {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage : jfsudo command [args]");
            System.exit(1);
        }
        if (args[0].equals("--ask")) {
            String pass = GetPassword.getPassword(null);
            if (pass == null) {
                pass = "";
            }
            System.out.println(pass);
            System.exit(0);
        }
        try {
            String[] cmd = new String[args.length + 2];
            cmd[0] = "sudo";
            cmd[1] = "-A";
            System.arraycopy(args, 0, cmd, 2, args.length);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Map<String, String> env = pb.environment();
            env.put("SUDO_ASKPASS", "/usr/bin/jfsudo-ask");
            Process p = pb.start();
            OutputStream os = p.getOutputStream();
            InputStream err = p.getErrorStream();
            InputStream is = p.getInputStream();
            new Relay(System.in, os).start();
            new Relay(is, System.out).start();
            new Relay(err, System.err).start();
            p.waitFor();
            System.exit(p.exitValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static class Relay
    extends Thread {
        private InputStream is;
        private OutputStream os;

        public Relay(InputStream is, OutputStream os) {
            this.is = is;
            this.os = os;
        }

        @Override
        public void run() {
            byte[] buf = new byte[1024];
            try {
                while (true) {
                    int len;
                    if ((len = this.is.read(buf)) <= 0) {
                        continue;
                    }
                    this.os.write(buf, 0, len);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

