/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.Serializable;
import javaforce.ShellProcess;
import javaforce.net.Subnet4;
import javaforce.vm.NetworkState;

public class NetworkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name;
    public String ip;
    public String netmask;
    public String mac;
    public transient NetworkState state;

    public NetworkConfig(String name) {
        this.name = name;
        this.state = new NetworkState();
    }

    public String[] getState() {
        return new String[]{this.name, this.state.ip + "/" + this.state.netmask, this.state.mac, this.state.link};
    }

    public static void getInfo(NetworkConfig[] nics) {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        String output = p.run(new String[]{"/usr/bin/ip", "addr"}, true);
        if (output == null) {
            return;
        }
        for (NetworkConfig nic : nics) {
            nic.state = new NetworkState();
        }
        String[] lns = output.split("\n");
        NetworkConfig nic = null;
        for (int a = 0; a < lns.length; ++a) {
            String ip_mask;
            int slash;
            String[] f;
            String ln = lns[a].trim();
            if (ln.length() == 0) continue;
            char start = ln.charAt(0);
            if (start >= '0' && start <= '9') {
                String[] fs = ln.split("[:]");
                String name = fs[1].trim();
                nic = null;
                for (NetworkConfig n : nics) {
                    if (!n.name.equals(name)) continue;
                    nic = n;
                    break;
                }
                if (nic != null) {
                    nic.state.link = "down";
                    int i1 = ln.indexOf(60);
                    int i2 = ln.indexOf(62);
                    if (i1 > 0 && i2 > 0) {
                        String[] ss;
                        String[] stringArray = ss = ln.substring(i1 + 1, i2).split("[,]");
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String s;
                            switch (s = stringArray[i]) {
                                case "UP": {
                                    nic.state.link = "up";
                                }
                            }
                        }
                    }
                }
            }
            if (nic != null && ln.startsWith("link/ether")) {
                f = ln.split("[ ]");
                nic.state.mac = f[1];
            }
            if (nic == null || !ln.startsWith("inet ") || (slash = (ip_mask = (f = ln.split("[ ]"))[1]).indexOf(47)) == -1) continue;
            nic.state.ip = ip_mask.substring(0, slash);
            int cidr = Integer.valueOf(ip_mask.substring(slash + 1));
            nic.state.netmask = Subnet4.fromCIDR(cidr);
        }
    }

    public boolean set_ip() {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        p.run(new String[]{"/usr/bin/ip", "addr", "add", this.ip + "/" + this.netmask, "dev", this.name}, true);
        return p.getErrorLevel() == 0;
    }

    private boolean link(String dir) {
        ShellProcess sp = new ShellProcess();
        sp.run(new String[]{"ip", "link", "set", this.name, dir}, true);
        return sp.getErrorLevel() == 0;
    }

    public boolean link_up() {
        return this.link("up");
    }

    public boolean link_down() {
        return this.link("down");
    }
}

