/*
 * Decompiled with CFR 0.152.
 */
package javaforce.cl;

import javaforce.cl.CL;

public class Compute {
    private CL cl;
    private long mult;

    public void init(int type) {
        this.uninit();
        this.cl = CL.create("__kernel void mult(__global float* input0, __global float* input1, __global float* output-) { int i = get_global_id(0); output[i] = input0[i] * input1[i]; }", type);
        this.mult = this.cl.kernel("mult");
    }

    public void uninit() {
        if (this.cl != null) {
            this.cl.freeKernel(this.mult);
            this.cl.close();
            this.cl = null;
        }
    }

    public boolean mult(float[] x, float[] y, float[] res) {
        int size = x.length;
        if (y.length != size) {
            return false;
        }
        if (res.length != size) {
            return false;
        }
        long input0 = this.cl.createWriteBuffer(4 * size);
        long input1 = this.cl.createWriteBuffer(4 * size);
        long output = this.cl.createReadBuffer(4 * size);
        this.cl.writeBuffer(input0, x);
        this.cl.writeBuffer(input1, y);
        this.cl.setArg(this.mult, 0, input0);
        this.cl.setArg(this.mult, 1, input1);
        this.cl.setArg(this.mult, 2, output);
        this.cl.execute(this.mult, size);
        this.cl.readBuffer(output, res);
        this.cl.freeBuffer(input0);
        this.cl.freeBuffer(input1);
        this.cl.freeBuffer(output);
        return true;
    }
}

