/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.JFLog;
import javaforce.media.MediaCoder;
import javaforce.media.MediaOutput;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class MediaAudioEncoder
extends MediaCoder {
    private Packet packet;

    public MediaAudioEncoder() {
    }

    public MediaAudioEncoder(MediaOutput output) {
        this.ctx = output.ctx;
        this.shared = true;
    }

    public native long nstart(int var1, int var2, int var3, int var4);

    public boolean start(CodecInfo info) {
        if (this.ctx != 0L || this.shared) {
            return false;
        }
        this.ctx = this.nstart(info.audio_codec, info.audio_bit_rate, info.chs, info.freq);
        return this.ctx != 0L;
    }

    public native void nstop(long var1);

    public void stop() {
        if (this.ctx == 0L || this.shared) {
            return;
        }
        this.nstop(this.ctx);
        this.ctx = 0L;
    }

    public native byte[] nencode(long var1, short[] var3, int var4, int var5);

    public Packet encode(short[] samples, int offset, int length) {
        if (this.ctx == 0L) {
            JFLog.log("MediaAudioEncoder no ctx");
            return null;
        }
        if (this.packet == null) {
            this.packet = new Packet();
            this.packet.stream = this.getStream();
        }
        this.packet.data = this.nencode(this.ctx, samples, offset, length);
        if (this.packet.data == null) {
            JFLog.log("MediaAudioEncoder.nencode:data == null");
            return null;
        }
        this.packet.length = this.packet.data.length;
        return this.packet;
    }

    public native int ngetAudioFramesize(long var1);

    public int getAudioFramesize() {
        return this.ngetAudioFramesize(this.ctx);
    }
}

