/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Random;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.MQTTEvents;

public class MQTT {
    private Socket s;
    private InputStream is;
    private OutputStream os;
    private MQTTEvents events;
    private Worker worker;
    public static boolean debug = false;
    public static boolean debug_msg = false;
    private short id = 1;
    private static int bufsiz = 4096;
    private static String resub = null;

    public boolean connect(String host) {
        return this.connect(host, 1883);
    }

    public boolean connect(String host, int port) {
        this.disconnect();
        try {
            this.s = new Socket(host, port);
            this.is = this.s.getInputStream();
            this.os = this.s.getOutputStream();
            this.worker = new Worker(this.s);
            this.worker.start();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean connect(String host, KeyMgmt keys) {
        return this.connect(host, 8883, keys);
    }

    public boolean connect(String host, int port, KeyMgmt keys) {
        this.disconnect();
        try {
            this.s = new Socket(host, port);
            this.s = JF.connectSSL(this.s, keys);
            this.is = this.s.getInputStream();
            this.os = this.s.getOutputStream();
            this.worker = new Worker(this.s);
            this.worker.start();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public void disconnect() {
        if (debug) {
            JFLog.log("disconnect");
        }
        if (this.s != null) {
            byte[] packet = new byte[]{-32, 1, 0};
            try {
                this.os.write(packet);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.s = null;
            this.os = null;
            this.is = null;
        }
        if (this.worker != null) {
            this.worker.cancel();
            this.worker = null;
        }
    }

    public void setListener(MQTTEvents events) {
        this.events = events;
    }

    private int calcPacketLength(boolean has_id, int topic_length, boolean has_opts, int msg_length) {
        int length = 0;
        if (has_id) {
            length += 2;
        }
        if (topic_length > 0) {
            length += 2;
            length += topic_length;
        }
        if (has_opts) {
            ++length;
        }
        ++length;
        if (msg_length > 0) {
            length += msg_length;
        }
        return length;
    }

    public void connect() {
        byte[] packet = new byte[25];
        packet[0] = 16;
        packet[1] = 23;
        packet[2] = 0;
        packet[3] = 4;
        packet[4] = 77;
        packet[5] = 81;
        packet[6] = 84;
        packet[7] = 84;
        packet[8] = 5;
        packet[9] = 2;
        packet[10] = 0;
        packet[11] = 120;
        packet[12] = 0;
        packet[13] = 0;
        packet[14] = 10;
        packet[15] = 74;
        packet[16] = 70;
        Random r = new Random();
        String hex = Integer.toString(r.nextInt(Integer.MAX_VALUE) | 0x10000000, 16);
        System.arraycopy(hex.getBytes(), 0, packet, 17, 8);
        try {
            this.os.write(packet);
        }
        catch (Exception e) {
            this.disconnect();
            JFLog.log(e);
        }
    }

    public void connect(String user, String pass) {
        byte[] user_bytes = user.getBytes();
        int user_length = user_bytes.length;
        byte[] pass_bytes = pass.getBytes();
        int pass_length = pass_bytes.length;
        int packet_length = 25 + user_length + 2 + pass_length;
        int length_bytes = this.getLengthBytes(packet_length);
        byte[] packet = new byte[1 + length_bytes + packet_length];
        int pos = 0;
        packet[pos++] = 16;
        this.setPacketLength(packet, length_bytes);
        pos += length_bytes;
        packet[pos++] = 0;
        packet[pos++] = 4;
        packet[pos++] = 77;
        packet[pos++] = 81;
        packet[pos++] = 84;
        packet[pos++] = 84;
        packet[pos++] = 5;
        packet[pos++] = -62;
        packet[pos++] = 0;
        packet[pos++] = 120;
        packet[pos++] = 0;
        packet[pos++] = 0;
        packet[pos++] = 10;
        packet[pos++] = 74;
        packet[pos++] = 70;
        Random r = new Random();
        String hex = Integer.toString(r.nextInt(Integer.MAX_VALUE) | 0x10000000, 16);
        System.arraycopy(hex.getBytes(), 0, packet, pos, 8);
        this.setStringLength(packet, pos += 8, (short)user_length);
        this.setString(packet, pos += 2, user_bytes, user_length);
        this.setStringLength(packet, pos += user_length, (short)pass_length);
        this.setString(packet, pos += 2, pass_bytes, pass_length);
        pos += pass_length;
        try {
            this.os.write(packet);
        }
        catch (Exception e) {
            this.disconnect();
            JFLog.log(e);
        }
    }

    public boolean isConnected() {
        if (this.worker == null) {
            return false;
        }
        return this.worker.active;
    }

    public void publish(String topic, String msg) {
        byte[] topic_bytes = topic.getBytes();
        int topic_length = topic_bytes.length;
        byte[] msg_bytes = msg.getBytes();
        int msg_length = msg_bytes.length;
        int length = this.calcPacketLength(true, topic_length, false, msg_length);
        int length_bytes = this.getLengthBytes(length);
        byte[] packet = new byte[1 + length_bytes + length];
        packet[0] = 50;
        this.setPacketLength(packet, length_bytes);
        int pos = 1 + length_bytes;
        this.setStringLength(packet, pos, (short)topic_length);
        System.arraycopy(topic_bytes, 0, packet, pos += 2, topic_length);
        short s = this.id;
        this.id = (short)(s + 1);
        this.setPacketID(packet, pos += topic_length, s);
        if (this.id == Short.MAX_VALUE) {
            this.id = 1;
        }
        pos += 2;
        System.arraycopy(msg_bytes, 0, packet, ++pos, msg_length);
        pos += msg_length;
        if (debug) {
            JFLog.log("publish:" + topic + "=" + msg);
        }
        try {
            this.os.write(packet);
        }
        catch (Exception e) {
            this.disconnect();
            JFLog.log(e);
        }
    }

    public void subscribe(String topic) {
        byte[] topic_bytes = topic.getBytes();
        int topic_length = topic_bytes.length;
        int length = this.calcPacketLength(true, topic_length, true, 0);
        int length_bytes = this.getLengthBytes(length);
        byte[] packet = new byte[1 + length_bytes + length];
        packet[0] = -126;
        this.setPacketLength(packet, length_bytes);
        int pos = 1 + length_bytes;
        short s = this.id;
        this.id = (short)(s + 1);
        this.setPacketID(packet, pos, s);
        pos += 2;
        this.setStringLength(packet, ++pos, (short)topic_length);
        System.arraycopy(topic_bytes, 0, packet, pos += 2, topic_length);
        pos += topic_length;
        ++pos;
        if (debug) {
            JFLog.log("subscribe:" + topic);
        }
        try {
            this.os.write(packet);
        }
        catch (Exception e) {
            this.disconnect();
            JFLog.log(e);
        }
    }

    public void unsubscribe(String topic) {
        byte[] topic_bytes = topic.getBytes();
        int topic_length = topic_bytes.length;
        int length = this.calcPacketLength(true, topic_length, false, 0);
        int length_bytes = this.getLengthBytes(length);
        byte[] packet = new byte[1 + length_bytes + length];
        packet[0] = -94;
        this.setPacketLength(packet, length_bytes);
        int pos = 1 + length_bytes;
        short s = this.id;
        this.id = (short)(s + 1);
        this.setPacketID(packet, pos, s);
        pos += 2;
        this.setStringLength(packet, ++pos, (short)topic_length);
        System.arraycopy(topic_bytes, 0, packet, pos += 2, topic_length);
        pos += topic_length;
        if (debug) {
            JFLog.log("unsubscribe:" + topic);
        }
        try {
            this.os.write(packet);
        }
        catch (Exception e) {
            this.disconnect();
            JFLog.log(e);
        }
    }

    public void ping() {
        byte[] packet = new byte[]{-64, 0};
        try {
            this.os.write(packet);
        }
        catch (Exception e) {
            this.disconnect();
            JFLog.log(e);
        }
    }

    private int getLength(byte[] data, int pos, int length) {
        int next;
        int multi = 1;
        int value = 0;
        do {
            if (pos >= length) {
                return -1;
            }
            next = data[pos++] & 0xFF;
            value += (next & 0x7F) * multi;
            multi *= 128;
        } while (next >= 128);
        return value;
    }

    private int getStringLength(byte[] data, int topicPosition) {
        return BE.getuint16(data, topicPosition);
    }

    private String getString(byte[] data, int offset, int length) {
        return new String(data, offset, length);
    }

    private short getPacketID(byte[] data, int idPosition) {
        return (short)BE.getuint16(data, idPosition);
    }

    private void setPacketLength(byte[] packet, int length_bytes) {
        int value = packet.length - 1 - length_bytes;
        int pos = 1;
        do {
            byte ebyte = (byte)(value % 128);
            if ((value /= 128) > 0) {
                ebyte = (byte)(ebyte | 0x80);
            }
            packet[pos++] = ebyte;
        } while (value > 0);
    }

    private void setPacketID(byte[] data, int offset, short id) {
        BE.setuint16(data, offset, id);
    }

    private void setStringLength(byte[] data, int offset, short length) {
        BE.setuint16(data, offset, length);
    }

    private void setString(byte[] data, int offset, byte[] str, int length) {
        System.arraycopy(str, 0, data, offset, length);
    }

    private int getLengthBytes(int length) {
        if (length <= 127) {
            return 1;
        }
        if (length <= 1023) {
            return 2;
        }
        if (length <= 0x1FFFFF) {
            return 3;
        }
        if (length <= 0xFFFFFFF) {
            return 4;
        }
        return -1;
    }

    private static void usage() {
        System.out.println("Usage:MQTT server [-u user] [-p pass] [publish topic msg]");
        System.out.println("Usage:MQTT server [-u user] [-p pass] [subscribe topic]");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            MQTT.usage();
            return;
        }
        try {
            MQTT client = new MQTT();
            client.setListener((topic, msg) -> {
                JFLog.log("msg:" + topic + "=" + msg);
                client.unsubscribe(topic);
                resub = topic;
                return true;
            });
            String host = args[0];
            String cmd = null;
            String topic2 = null;
            String msg2 = null;
            String user = null;
            String pass = null;
            for (int idx = 1; idx < args.length; ++idx) {
                String arg = args[idx];
                if (arg.equals("-u")) {
                    user = args[idx + 1];
                    ++idx;
                    continue;
                }
                if (arg.equals("-p")) {
                    pass = args[idx + 1];
                    ++idx;
                    continue;
                }
                if (arg.equals("-d")) {
                    debug_msg = true;
                    continue;
                }
                if (cmd == null) {
                    cmd = arg;
                    continue;
                }
                if (topic2 == null) {
                    topic2 = arg;
                    continue;
                }
                if (msg2 == null) {
                    msg2 = arg;
                    continue;
                }
                JFLog.log("Unknown arg:" + arg);
            }
            if (cmd == null || topic2 == null) {
                MQTT.usage();
                return;
            }
            client.connect(host);
            if (user != null && pass != null) {
                client.connect(user, pass);
            } else {
                client.connect();
            }
            switch (cmd) {
                case "publish": {
                    if (msg2 == null) {
                        MQTT.usage();
                        return;
                    }
                    client.publish(topic2, msg2);
                    break;
                }
                case "subscribe": {
                    client.subscribe(topic2);
                }
            }
            while (client.isConnected()) {
                for (int a = 0; a < 60; ++a) {
                    if (resub != null) {
                        client.subscribe(resub);
                        resub = null;
                    }
                    JF.sleep(1000);
                }
                client.ping();
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private class Worker
    extends Thread {
        private boolean active = true;
        public Socket s;
        public InputStream is;
        public OutputStream os;
        public String ip;

        public Worker(Socket s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                this.is = this.s.getInputStream();
                this.os = this.s.getOutputStream();
                this.ip = this.s.getInetAddress().getHostAddress();
                if (debug) {
                    JFLog.log("connect:" + this.ip);
                }
                byte[] buf = new byte[bufsiz];
                block4: while (this.active) {
                    int totalRead = 0;
                    int packetLength = -1;
                    int totalLength = -1;
                    Arrays.fill(buf, (byte)0);
                    while (this.active) {
                        int read = packetLength == -1 ? this.is.read(buf, totalRead, 1) : this.is.read(buf, totalRead, totalLength - totalRead);
                        if (debug) {
                            JFLog.log("read=" + read);
                        }
                        if (read == -1) {
                            throw new Exception("bad read");
                        }
                        if ((totalRead += read) < 2) continue;
                        if (packetLength == -1 && (packetLength = MQTT.this.getLength(buf, 1, totalRead)) != -1) {
                            totalLength = 1 + MQTT.this.getLengthBytes(packetLength) + packetLength;
                            if (debug) {
                                JFLog.log("totalLength=" + totalLength);
                            }
                        }
                        if (packetLength == -1 || totalRead < totalLength) continue;
                        try {
                            this.process(buf, totalLength, packetLength);
                        }
                        catch (Exception e) {
                            JFLog.log(e);
                        }
                        continue block4;
                    }
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                this.active = false;
            }
            if (debug) {
                JFLog.log("disconnect:" + this.ip);
            }
        }

        private void process(byte[] packet, int totalLength, int packetLength) throws Exception {
            byte[] reply = null;
            byte cmd = (byte)((packet[0] & 0xF0) >> 4);
            short id = 0;
            if (debug) {
                JFLog.log("cmd=" + cmd);
            }
            switch (cmd) {
                case 2: {
                    if (!debug_msg) break;
                    JFLog.log("connect_ack");
                    break;
                }
                case 3: {
                    int props_length;
                    boolean dup = (packet[0] & 8) != 0;
                    byte qos = (byte)((packet[0] & 6) >> 1);
                    boolean retain = (packet[0] & 1) != 0;
                    int pos = 1 + MQTT.this.getLengthBytes(packetLength);
                    int topicLength = MQTT.this.getStringLength(packet, pos);
                    if (debug) {
                        JFLog.log("topic=" + pos + "/" + topicLength);
                    }
                    String topic_name = MQTT.this.getString(packet, pos += 2, topicLength);
                    pos += topicLength;
                    if (qos > 0) {
                        id = MQTT.this.getPacketID(packet, pos);
                        if (debug) {
                            JFLog.log("id=" + id);
                        }
                        pos += 2;
                    }
                    if ((props_length = MQTT.this.getLength(packet, pos, totalLength)) == -1) {
                        throw new Exception("malformed packet");
                    }
                    int props_length_bytes = MQTT.this.getLengthBytes(props_length);
                    pos += props_length_bytes;
                    if (props_length > 0) {
                        pos += props_length_bytes;
                    }
                    int msgLength = totalLength - pos;
                    if (debug) {
                        JFLog.log("msg=" + pos + "/" + msgLength);
                    }
                    String msg = new String(packet, pos, msgLength);
                    if (debug_msg) {
                        JFLog.log("PUBLISH:" + this.ip + ":" + topic_name + ":" + msg);
                    }
                    switch (qos) {
                        case 1: {
                            reply = new byte[4];
                            reply[0] = 64;
                            MQTT.this.setPacketLength(reply, 1);
                            MQTT.this.setPacketID(reply, 2, id);
                            break;
                        }
                        case 2: {
                            reply = new byte[4];
                            reply[0] = 80;
                            MQTT.this.setPacketLength(reply, 1);
                            MQTT.this.setPacketID(reply, 2, id);
                        }
                    }
                    if (MQTT.this.events == null) break;
                    MQTT.this.events.message(topic_name, msg);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    reply = new byte[4];
                    reply[0] = 98;
                    MQTT.this.setPacketLength(reply, 1);
                    id = MQTT.this.getPacketID(packet, 2);
                    MQTT.this.setPacketID(reply, 2, id);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 9: {
                    if (!debug_msg) break;
                    JFLog.log("subscribe_ack");
                    break;
                }
                case 12: {
                    reply = new byte[2];
                    reply[0] = -48;
                    if (!debug_msg) break;
                    JFLog.log("PING:" + this.ip);
                    break;
                }
                case 14: {
                    this.active = false;
                }
            }
            if (reply != null) {
                this.send(reply);
            }
        }

        private void send(byte[] reply) throws Exception {
            this.os.write(reply);
        }

        public void cancel() {
            this.active = false;
            if (this.s != null) {
                try {
                    this.s.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.s = null;
            }
        }
    }
}

