/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import javaforce.gl.Vector4;

public class Vector3 {
    public float[] v = new float[3];

    public Vector3() {
    }

    public Vector3(float x, float y, float z) {
        this.v[0] = x;
        this.v[1] = y;
        this.v[2] = z;
    }

    public void set(float x, float y, float z) {
        this.v[0] = x;
        this.v[1] = y;
        this.v[2] = z;
    }

    public void set(Vector3 in) {
        this.v[0] = in.v[0];
        this.v[1] = in.v[1];
        this.v[2] = in.v[2];
    }

    public void set(Vector4 in) {
        this.v[0] = in.v[0];
        this.v[1] = in.v[1];
        this.v[2] = in.v[2];
    }

    public void add(Vector3 a, Vector3 b) {
        this.v[0] = a.v[0] + b.v[0];
        this.v[1] = a.v[1] + b.v[1];
        this.v[2] = a.v[2] + b.v[2];
    }

    public void add(Vector3 a) {
        this.v[0] = this.v[0] + a.v[0];
        this.v[1] = this.v[1] + a.v[1];
        this.v[2] = this.v[2] + a.v[2];
    }

    public void sub(Vector3 a, Vector3 b) {
        this.v[0] = a.v[0] - b.v[0];
        this.v[1] = a.v[1] - b.v[1];
        this.v[2] = a.v[2] - b.v[2];
    }

    public void sub(Vector3 a) {
        this.v[0] = this.v[0] - a.v[0];
        this.v[1] = this.v[1] - a.v[1];
        this.v[2] = this.v[2] - a.v[2];
    }

    public void cross(Vector3 a, Vector3 b) {
        this.v[0] = a.v[1] * b.v[2] - a.v[2] * b.v[1];
        this.v[1] = a.v[2] * b.v[0] - a.v[0] * b.v[2];
        this.v[2] = a.v[0] * b.v[1] - a.v[1] * b.v[0];
    }

    public void normalize() {
        float len = this.length();
        if (len == 0.0f) {
            return;
        }
        this.scale(1.0f / len);
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.dot(this);
    }

    public void scale(float s) {
        this.v[0] = this.v[0] * s;
        this.v[1] = this.v[1] * s;
        this.v[2] = this.v[2] * s;
    }

    public void divide(float d) {
        if (d == 0.0f) {
            return;
        }
        this.v[0] = this.v[0] / d;
        this.v[1] = this.v[1] / d;
        this.v[2] = this.v[2] / d;
    }

    public float dot(Vector3 in) {
        return this.v[0] * in.v[0] + this.v[1] * in.v[1] + this.v[2] * in.v[2];
    }

    public float length(Vector3 in) {
        float _x = this.v[0] - in.v[0];
        float _y = this.v[1] - in.v[1];
        float _z = this.v[2] - in.v[2];
        return (float)Math.sqrt(_x * _x + _y * _y + _z * _z);
    }

    public String toString() {
        return String.format("%.3f,%.3f,%.3f", Float.valueOf(this.v[0]), Float.valueOf(this.v[1]), Float.valueOf(this.v[2]));
    }
}

