/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LE;

public class Wav {
    private String errmsg;
    private int chs = -1;
    private int rate = -1;
    private int bits = -1;
    private int bytes = -1;
    private byte[] samples8;
    private short[] samples16;
    private int[] samples32;
    private int dataLength;
    private int pos;
    private InputStream is = null;
    private short[] samples20 = new short[160];

    public Wav() {
    }

    public Wav(int chs, int bits, int rate) {
        this.setChannels(chs);
        this.setBits(bits);
        this.setSampleRate(rate);
    }

    public boolean load(String fn) {
        try {
            this.is = new FileInputStream(fn);
            return this.load(this.is);
        }
        catch (Exception e) {
            this.errmsg = e.toString();
            JFLog.log(e);
            return false;
        }
    }

    public boolean load(InputStream is) {
        this.errmsg = "";
        try {
            byte[] data = new byte[30];
            is.read(data, 0, 20);
            if (!LE.getString(data, 0, 4).equals("RIFF")) {
                throw new Exception("wav is not a valid WAV file (RIFF)");
            }
            if (!LE.getString(data, 8, 4).equals("WAVE")) {
                throw new Exception("wav is not a valid WAV file (WAVE)");
            }
            if (!LE.getString(data, 12, 4).equals("fmt ")) {
                throw new Exception("wav is not a valid WAV file (fmt )");
            }
            int fmtsiz = LE.getuint32(data, 16);
            if (fmtsiz < 16 || fmtsiz > 30) {
                throw new Exception("wav is not a valid WAV file (fmtsiz)");
            }
            is.read(data, 0, fmtsiz);
            if (LE.getuint16(data, 0) != 1) {
                throw new Exception("wav is not PCM");
            }
            this.chs = LE.getuint16(data, 2);
            if (this.chs < 1 || this.chs > 2) {
                throw new Exception("wav is not supported (# chs)");
            }
            this.rate = LE.getuint32(data, 4);
            this.bits = LE.getuint16(data, 14);
            switch (this.bits) {
                case 16: {
                    this.bytes = 2;
                    break;
                }
                case 24: {
                    this.bytes = 3;
                    break;
                }
                case 32: {
                    this.bytes = 4;
                    break;
                }
                default: {
                    throw new Exception("wav is not supported (bits=" + this.bits + ")");
                }
            }
            is.read(data, 0, 8);
            while (true) {
                this.dataLength = LE.getuint32(data, 4);
                if (!LE.getString(data, 0, 4).equals("data")) {
                    is.skip(this.dataLength);
                    is.read(data, 0, 8);
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException e2) {
            this.errmsg = "WAV file not found";
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        catch (Exception e1) {
            this.errmsg = e1.toString();
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public void close() {
        try {
            this.is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean readAllSamples() {
        try {
            this.samples8 = JF.readAll(this.is, this.dataLength);
            this.is.close();
            switch (this.bits) {
                case 8: {
                    return true;
                }
                case 24: {
                    int cnt = this.dataLength / 3;
                    this.samples32 = new int[cnt];
                    for (int a = 0; a < cnt; ++a) {
                        int sam = this.samples8[a * 3 + 2] & 0xFF;
                        sam <<= 8;
                        sam += this.samples8[a * 3 + 1] & 0xFF;
                        sam <<= 8;
                        sam += this.samples8[a * 3 + 0] & 0xFF;
                        this.samples32[a] = sam <<= 8;
                    }
                    break;
                }
                case 16: {
                    this.samples16 = new short[this.dataLength / 2];
                    ByteBuffer.wrap(this.samples8).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(this.samples16);
                    break;
                }
                case 32: {
                    this.samples32 = new int[this.dataLength / 4];
                    ByteBuffer.wrap(this.samples8).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().get(this.samples32);
                }
            }
            return true;
        }
        catch (Exception e) {
            this.errmsg = e.toString();
            JFLog.log(e);
            return false;
        }
    }

    public byte[] readSamples(int nSamples) {
        int byteLength = nSamples * this.bytes * this.chs;
        byte[] read8 = JF.readAll(this.is, byteLength);
        if (read8 == null) {
            return null;
        }
        int lenXchs = nSamples * this.chs;
        int pos = 0;
        int pos24 = 0;
        switch (this.bits) {
            case 16: {
                byte[] read32 = new byte[nSamples * 2 * this.chs];
                for (int a = 0; a < lenXchs; ++a) {
                    read32[pos + 0] = read8[pos + 0];
                    read32[pos + 1] = read8[pos + 1];
                    pos += 2;
                }
                return read32;
            }
            case 32: {
                byte[] read32 = new byte[nSamples * 4 * this.chs];
                for (int a = 0; a < lenXchs; ++a) {
                    read32[pos + 0] = read8[pos + 0];
                    read32[pos + 1] = read8[pos + 1];
                    read32[pos + 2] = read8[pos + 2];
                    read32[pos + 3] = read8[pos + 3];
                    pos += 4;
                }
                return read32;
            }
            case 24: {
                byte[] read32 = new byte[nSamples * 4 * this.chs];
                for (int a = 0; a < lenXchs; ++a) {
                    read32[pos + 0] = read8[pos24 + 0];
                    read32[pos + 1] = read8[pos24 + 1];
                    read32[pos + 2] = read8[pos24 + 2];
                    pos += 4;
                    pos24 += 3;
                }
                return read32;
            }
        }
        return null;
    }

    public boolean save(String fn) {
        try {
            FileOutputStream fos = new FileOutputStream(fn);
            boolean ret = this.save(fos);
            fos.close();
            return ret;
        }
        catch (Exception e) {
            this.errmsg = e.toString();
            JFLog.log(e);
            return false;
        }
    }

    public boolean save(OutputStream os) {
        if (this.bits != 16 && this.bits != 32) {
            return false;
        }
        if (this.rate == 0) {
            return false;
        }
        int size = 0;
        switch (this.bits) {
            case 16: {
                this.bytes = 2;
                size = this.samples16.length * 2;
                break;
            }
            case 32: {
                this.bytes = 4;
                size = this.samples32.length * 4;
            }
        }
        try {
            byte[] data = new byte[20];
            LE.setString(data, 0, 4, "RIFF");
            LE.setuint32(data, 4, size + 36);
            LE.setString(data, 8, 4, "WAVE");
            LE.setString(data, 12, 4, "fmt ");
            LE.setuint32(data, 16, 16);
            os.write(data, 0, data.length);
            data = new byte[24];
            LE.setuint16(data, 0, 1);
            LE.setuint16(data, 2, this.chs);
            LE.setuint32(data, 4, this.rate);
            LE.setuint32(data, 8, this.bytes * this.chs * this.rate);
            LE.setuint32(data, 12, this.bytes * this.chs);
            LE.setuint16(data, 14, this.bits);
            LE.setString(data, 16, 4, "data");
            LE.setuint32(data, 20, size);
            os.write(data, 0, data.length);
            switch (this.bits) {
                case 16: {
                    os.write(LE.shortArray2byteArray(this.samples16, null));
                    break;
                }
                case 32: {
                    os.write(LE.intArray2byteArray(this.samples32, null));
                }
            }
        }
        catch (Exception e) {
            this.errmsg = e.toString();
            return false;
        }
        return false;
    }

    public void add(short[] samples) {
        int len = samples.length;
        if (this.samples16 == null) {
            this.samples16 = new short[len];
            System.arraycopy(samples, 0, this.samples16, 0, len);
        } else {
            int orgLen = this.samples16.length;
            int newLen = orgLen + len;
            short[] newBuf = new short[newLen];
            System.arraycopy(this.samples16, 0, newBuf, 0, orgLen);
            System.arraycopy(samples, 0, newBuf, orgLen, len);
            this.samples16 = newBuf;
        }
        this.dataLength += len;
    }

    public void add(int[] samples) {
        int len = samples.length;
        if (this.samples32 == null) {
            this.samples32 = new int[len];
            System.arraycopy(samples, 0, this.samples32, 0, len);
        } else {
            int orgLen = this.samples32.length;
            int newLen = orgLen + len;
            int[] newBuf = new int[newLen];
            System.arraycopy(this.samples32, 0, newBuf, 0, orgLen);
            System.arraycopy(samples, 0, newBuf, orgLen, len);
            this.samples32 = newBuf;
        }
        this.dataLength += len;
    }

    public short[] getSamples16() {
        return this.samples16;
    }

    public int[] getSamples32() {
        return this.samples32;
    }

    public int getChannels() {
        return this.chs;
    }

    public void setChannels(int chs) {
        this.chs = chs;
    }

    public int getSampleRate() {
        return this.rate;
    }

    public void setSampleRate(int rate) {
        this.rate = rate;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
        switch (bits) {
            case 16: {
                this.bytes = 2;
                break;
            }
            case 24: {
                this.bytes = 3;
                break;
            }
            case 32: {
                this.bytes = 4;
            }
        }
    }

    public int getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.dataLength;
    }

    public short[] getSamples20ms() {
        if (this.samples16 == null || this.samples16.length < 160) {
            return null;
        }
        if (this.pos + 160 > this.samples16.length) {
            this.pos = 0;
        }
        System.arraycopy(this.samples16, this.pos, this.samples20, 0, 160);
        this.pos += 160;
        return this.samples20;
    }

    public void reset() {
        this.pos = 0;
    }

    public String getError() {
        return this.errmsg;
    }
}

