/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.ViewLog;
import javaforce.jbus.JBusClient;
import javaforce.service.MQTTServer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class MQTTApp
extends JFrame {
    private JTextArea config;
    private JButton gen_keys;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton save;
    private JButton viewLog;
    public ViewLog viewer;
    public JBusClient busClient;

    public MQTTApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/mqtt.png"));
        new Thread(){

            @Override
            public void run() {
                Random r = new Random();
                MQTTApp.this.busClient = new JBusClient("net.sf.jfmqtt.client" + r.nextInt(), new JBusMethods());
                MQTTApp.this.busClient.setPort(MQTTServer.getBusPort());
                MQTTApp.this.busClient.start();
                MQTTApp.this.busClient.call("net.sf.jfmqtt", "getConfig", "\"" + MQTTApp.this.busClient.pack + "\"");
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfmqtt", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfmqtt", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.gen_keys = new JButton();
        this.viewLog = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("MQTT Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MQTTApp.this.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("MQTT Configuration:");
        this.gen_keys.setText("Generate SSL Key");
        this.gen_keys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MQTTApp.this.gen_keysActionPerformed(evt);
            }
        });
        this.viewLog.setText("View Log");
        this.viewLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MQTTApp.this.viewLogActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.viewLog).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gen_keys).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 307, Short.MAX_VALUE).addComponent(this.save)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.viewLog).addComponent(this.gen_keys)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void viewLogActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    private void gen_keysActionPerformed(ActionEvent evt) {
        this.genKeys();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MQTTApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewer == null || this.viewer.isClosed) {
            this.viewer = new ViewLog(MQTTServer.getLogFile());
            this.viewer.setTitle("MQTT Log");
        }
        this.viewer.setVisible(true);
    }

    private void genKeys() {
        this.busClient.call("net.sf.jfmqtt", "genKeys", "\"" + this.busClient.pack + "\"");
    }

    public class JBusMethods {
        public void getConfig(String cfg) {
            final String _cfg = cfg;
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ JBusMethods this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.MQTTApp.this.config.setText(JBusClient.decodeString(_cfg));
                    this.this$1.MQTTApp.this.config.setEnabled(true);
                    this.this$1.MQTTApp.this.save.setEnabled(true);
                }
            });
        }

        public void getKeys(final String status) {
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ JBusMethods this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    if (status.equals("OK")) {
                        JFAWT.showMessage("GenKeys", "OK");
                    } else {
                        JFAWT.showError("GenKeys", "Error");
                    }
                }
            });
        }
    }
}

