/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import java.util.ArrayList;
import javaforce.ui.Component;
import javaforce.ui.Dimension;
import javaforce.ui.Image;
import javaforce.ui.LayoutMetrics;
import javaforce.ui.Point;

public abstract class Container
extends Component {
    public ArrayList<Component> children;
    public Component focus;
    public Dimension minSize = new Dimension();
    private static boolean found;

    public Container() {
        this.children = new ArrayList();
        this.setConsumer(false);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public void add(Component child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void remove(Component child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public Component getChild(int idx) {
        return this.children.get(idx);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Component[] getChildren() {
        return this.children.toArray(new Component[this.children.size()]);
    }

    public <T> T[] getChildren(T[] array) {
        return this.children.toArray(array);
    }

    @Override
    public abstract Dimension getMinSize();

    @Override
    public abstract void layout(LayoutMetrics var1);

    @Override
    public void render(Image output) {
        super.render(output);
        for (int layer = 0; layer <= 1; ++layer) {
            for (Component child : this.children) {
                if (child.getLayer() != layer || !child.isVisible()) continue;
                child.render(output);
            }
        }
    }

    private Component firstFocus() {
        for (Component child : this.children) {
            Component c;
            if (child.isFocusable()) {
                return child;
            }
            if (!child.isContainer() || (c = ((Container)child).firstFocus()) == null) continue;
            return c;
        }
        return null;
    }

    private Component nextFocus(Component focus) {
        for (Component child : this.children) {
            Component c;
            if (!found) {
                if (child == focus) {
                    found = true;
                    continue;
                }
                if (!child.isContainer() || (c = ((Container)child).nextFocus(focus)) == null) continue;
                return c;
            }
            if (child.isFocusable()) {
                return child;
            }
            if (!child.isContainer() || (c = ((Container)child).nextFocus(focus)) == null) continue;
            return c;
        }
        return null;
    }

    private void nextFocus() {
        if (this.focus != null) {
            this.focus.onBlur();
            found = false;
            this.focus = this.nextFocus(this.focus);
            if (this.focus == null) {
                this.focus = this.firstFocus();
            }
        } else {
            this.focus = this.firstFocus();
        }
        if (this.focus != null) {
            this.focus.onFocus();
        }
    }

    public void setFocus(Component child) {
        if (this.focus != null) {
            this.focus.onBlur();
        }
        this.focus = child;
        this.focus.onFocus();
    }

    @Override
    public void keyTyped(char ch) {
        if (this.focus != null) {
            this.focus.keyTyped(ch);
        }
    }

    @Override
    public void keyPressed(int key) {
        switch (key) {
            case 258: {
                this.nextFocus();
            }
        }
        if (this.focus != null) {
            this.focus.keyPressed(key);
        }
    }

    @Override
    public void keyReleased(int key) {
        if (this.focus != null) {
            this.focus.keyReleased(key);
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        super.mouseMove(x, y);
        Point pt = this.getMousePosition();
        for (int layer = 1; layer >= 0; --layer) {
            for (Component child : this.children) {
                if (child.getLayer() != layer || !child.isVisible() || !child.isInside(pt)) continue;
                child.mouseMove(x, y);
            }
        }
    }

    @Override
    public void mouseDown(int button) {
        Point pt = this.getMousePosition();
        super.mouseDown(button);
        for (int layer = 1; layer >= 0; --layer) {
            for (Component child : this.children) {
                if (child.getLayer() != layer || !child.isVisible() || !child.isInside(pt)) continue;
                child.mouseDown(button);
                if (!child.isConsumer()) continue;
                return;
            }
        }
    }

    @Override
    public void mouseUp(int button) {
        Point pt = this.getMousePosition();
        super.mouseUp(button);
        for (int layer = 1; layer >= 0; --layer) {
            for (Component child : this.children) {
                if (child.getLayer() != layer || !child.isVisible() || !child.isInside(pt)) continue;
                child.mouseUp(button);
                if (!child.isConsumer()) continue;
                return;
            }
        }
    }

    @Override
    public void mouseScroll(int dx, int dy) {
        Point pt = this.getMousePosition();
        super.mouseScroll(dx, dy);
        for (int layer = 0; layer <= 1; ++layer) {
            for (Component child : this.children) {
                if (child.getLayer() != layer || !child.isVisible() || !child.isInside(pt)) continue;
                child.mouseScroll(dx, dy);
            }
        }
    }
}

