/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.util.Random;
import javaforce.voip.Packet;
import javaforce.voip.PacketReceiver;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPVideoCoder;

public class RTPH263_1998
implements RTPVideoCoder {
    private Packet packet;
    private int lastseqnum = -1;
    private static int maxSize = 0x400000;
    private static final int mtu = 1444;
    private int seqnum;
    private int timestamp;
    private final int ssrc = new Random().nextInt();
    private static final int P = 32;
    private static final int M = 128;
    private int rtp_id;

    public RTPH263_1998() {
        this.packet = new Packet();
        this.packet.data = new byte[maxSize];
    }

    @Override
    public void setid(int id) {
        this.rtp_id = id;
    }

    private int find_best_length(byte[] data, int offset, int length) {
        for (int a = 1; a < length - 3; ++a) {
            if (data[offset + a] != 0 || data[offset + a + 1] != 0 || data[offset + a + 2] == 0) continue;
            return a;
        }
        return length;
    }

    @Override
    public void encode(byte[] data, int offset, int length, int x, int y, PacketReceiver pr) {
        int packetLength;
        int pos = offset;
        for (int len = length; len > 0; len -= packetLength) {
            boolean p = false;
            if (len > 2 && data[pos] == 0 && data[pos + 1] == 0) {
                p = true;
                pos += 2;
                len -= 2;
            }
            packetLength = len > 1444 ? this.find_best_length(data, pos, len) : len;
            this.packet.length = packetLength + 12 + 2;
            RTPChannel.buildHeader(this.packet.data, this.rtp_id, this.seqnum++, this.timestamp, this.ssrc, len == packetLength);
            this.packet.data[12] = (byte)(p ? 32 : 0);
            System.arraycopy(data, pos, this.packet.data, 14, packetLength);
            pos += packetLength;
            pr.onPacket(this.packet);
        }
        this.packet.length = 0;
        this.timestamp += 100;
    }

    @Override
    public void decode(byte[] rtp, int offset, int length, PacketReceiver pr) {
        if (rtp.length < 14) {
            return;
        }
        int h263Length = rtp.length - 12 - 2;
        boolean p = (rtp[12] & 0x20) == 32;
        System.arraycopy(rtp, 14, this.packet.data, this.packet.length + (p ? 2 : 0), h263Length);
        if (p) {
            this.packet.data[this.packet.length] = 0;
            this.packet.data[this.packet.length + 1] = 0;
        }
        this.packet.length += h263Length;
        if ((rtp[1] & 0x80) == 128) {
            pr.onPacket(this.packet);
            this.packet.length = 0;
        }
    }
}

