/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.VNCJavaRobot;
import javaforce.jni.WinNative;

public class VNCSessionClient
extends VNCJavaRobot {
    public static final byte CMD_GET_SCREEN_SIZE = 1;
    public static final byte CMD_GET_SCREEN = 2;
    public static final byte CMD_KEY_DOWN = 3;
    public static final byte CMD_KEY_UP = 4;
    public static final byte CMD_MOUSE_MOVE = 5;
    public static final byte CMD_MOUSE_DOWN = 6;
    public static final byte CMD_MOUSE_UP = 7;
    public static final byte CMD_EXIT = 99;
    private int sid;
    public static boolean debug = false;
    private Socket s;

    public static void main(String[] args) {
        if (debug) {
            JFLog.append(JF.getLogPath() + "/jfvncsession-" + System.currentTimeMillis() + ".log", true);
        }
        try {
            if (debug) {
                JFLog.log("VNCSessionClient Starting...");
            }
            GraphicsEnvironment gfx = GraphicsEnvironment.getLocalGraphicsEnvironment();
            VNCSessionClient session = new VNCSessionClient(gfx.getDefaultScreenDevice());
            session.run();
        }
        catch (Throwable e) {
            JFLog.log(e);
        }
    }

    public VNCSessionClient(GraphicsDevice screen) {
        super(screen);
    }

    private void run() {
        try {
            if (debug) {
                JFLog.log("Connecting to 127.0.0.1:5999");
            }
            this.s = new Socket("127.0.0.1", 5999);
            InputStream is = this.s.getInputStream();
            OutputStream os = this.s.getOutputStream();
            DataInputStream dis = new DataInputStream(is);
            DataOutputStream dos = new DataOutputStream(os);
            if (JF.isWindows()) {
                this.sid = -1;
                while (this.sid == -1) {
                    this.sid = WinNative.getSessionID();
                    JF.sleep(100);
                }
            }
            while (this.s.isConnected()) {
                byte cmd = (byte)is.read();
                switch (cmd) {
                    case 1: {
                        Rectangle size = this.getScreenSize();
                        dos.writeInt(size.width);
                        dos.writeInt(size.height);
                        break;
                    }
                    case 2: {
                        if (JF.isWindows()) {
                            WinNative.setInputDesktop();
                        }
                        Rectangle size = this.getScreenSize();
                        int pf = is.read();
                        dos.writeInt(size.width);
                        dos.writeInt(size.height);
                        int[] px32 = this.getScreenCapture(pf);
                        int pixels = px32.length;
                        byte[] px8 = new byte[pixels * 4];
                        int i8 = 0;
                        for (int i = 0; i < pixels; ++i) {
                            BE.setuint32(px8, i8, px32[i]);
                            i8 += 4;
                        }
                        dos.write(px8);
                        break;
                    }
                    case 3: {
                        this.keyPress(dis.readInt());
                        break;
                    }
                    case 4: {
                        this.keyRelease(dis.readInt());
                        break;
                    }
                    case 5: {
                        int x = dis.readInt();
                        int y = dis.readInt();
                        this.mouseMove(x, y);
                        break;
                    }
                    case 6: {
                        this.mousePress(dis.readInt());
                        break;
                    }
                    case 7: {
                        this.mouseRelease(dis.readInt());
                        break;
                    }
                    case 99: {
                        this.close();
                    }
                }
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        this.close();
    }

    @Override
    public void close() {
        JFLog.log("VNCSessionClient Stopped");
        try {
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        System.exit(0);
    }
}

