/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip.codec;

import javaforce.voip.RTP;
import javaforce.voip.RTPAudioCoder;
import javaforce.voip.RTPChannel;

public class g722
implements RTPAudioCoder {
    private int bits_per_sample = 8;
    private boolean eight_k = false;
    private boolean packed = false;
    private boolean itu_test_mode = false;
    private RTP rtp;
    private byte[] encoded = new byte[172];
    private int in_buffer;
    private int in_bits;
    private int out_buffer;
    private int out_bits;
    private int[] e_x = new int[24];
    private Band[] e_band = new Band[2];
    private int[] d_x = new int[24];
    private Band[] d_band = new Band[2];
    private final int[] q6 = new int[]{0, 35, 72, 110, 150, 190, 233, 276, 323, 370, 422, 473, 530, 587, 650, 714, 786, 858, 940, 1023, 1121, 1219, 1339, 1458, 1612, 1765, 1980, 2195, 2557, 2919, 0, 0};
    private final int[] iln = new int[]{0, 63, 62, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 0};
    private final int[] ilp = new int[]{0, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 0};
    private final int[] wl = new int[]{-60, -30, 58, 172, 334, 538, 1198, 3042};
    private final int[] rl42 = new int[]{0, 7, 6, 5, 4, 3, 2, 1, 7, 6, 5, 4, 3, 2, 1, 0};
    private final int[] ilb = new int[]{2048, 2093, 2139, 2186, 2233, 2282, 2332, 2383, 2435, 2489, 2543, 2599, 2656, 2714, 2774, 2834, 2896, 2960, 3025, 3091, 3158, 3228, 3298, 3371, 3444, 3520, 3597, 3676, 3756, 3838, 3922, 4008};
    private final int[] qm4 = new int[]{0, -20456, -12896, -8968, -6288, -4240, -2584, -1200, 20456, 12896, 8968, 6288, 4240, 2584, 1200, 0};
    private final int[] qm2 = new int[]{-7408, -1616, 7408, 1616};
    private final int[] qmf_coeffs = new int[]{3, -11, 12, 32, -210, 951, 3876, -805, 362, -156, 53, -11};
    private final int[] ihn = new int[]{0, 1, 0};
    private final int[] ihp = new int[]{0, 3, 2};
    private final int[] wh = new int[]{0, -214, 798};
    private final int[] rh2 = new int[]{2, 1, 2, 1};
    private final int[] qm5 = new int[]{-280, -280, -23352, -17560, -14120, -11664, -9752, -8184, -6864, -5712, -4696, -3784, -2960, -2208, -1520, -880, 23352, 17560, 14120, 11664, 9752, 8184, 6864, 5712, 4696, 3784, 2960, 2208, 1520, 880, 280, -280};
    private final int[] qm6 = new int[]{-136, -136, -136, -136, -24808, -21904, -19008, -16704, -14984, -13512, -12280, -11192, -10232, -9360, -8576, -7856, -7192, -6576, -6000, -5456, -4944, -4464, -4008, -3576, -3168, -2776, -2400, -2032, -1688, -1360, -1040, -728, 24808, 21904, 19008, 16704, 14984, 13512, 12280, 11192, 10232, 9360, 8576, 7856, 7192, 6576, 6000, 5456, 4944, 4464, 4008, 3576, 3168, 2776, 2400, 2032, 1688, 1360, 1040, 728, 432, 136, -432, -136};
    private int decode_timestamp;
    private final short[] decoded = new short[320];

    public g722(RTP rtp) {
        this.rtp = rtp;
        for (int a = 0; a < 2; ++a) {
            this.e_band[a] = new Band();
            this.d_band[a] = new Band();
        }
    }

    @Override
    public void setid(int id) {
    }

    @Override
    public int getPacketSize() {
        return 160;
    }

    private static short saturate(int amp) {
        if (amp > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        if (amp < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return (short)amp;
    }

    private void block4(Band band, int d) {
        int wd2;
        int i;
        band.d[0] = d;
        band.r[0] = g722.saturate(band.s + d);
        band.p[0] = g722.saturate(band.sz + d);
        for (i = 0; i < 3; ++i) {
            band.sg[i] = band.p[i] >> 15;
        }
        int wd1 = g722.saturate(band.a[1] << 2);
        int n = wd2 = band.sg[0] == band.sg[1] ? -wd1 : wd1;
        if (wd2 > Short.MAX_VALUE) {
            wd2 = Short.MAX_VALUE;
        }
        int wd3 = (wd2 >> 7) + (band.sg[0] == band.sg[2] ? 128 : -128);
        if ((wd3 += band.a[2] * 32512 >> 15) > 12288) {
            wd3 = 12288;
        } else if (wd3 < -12288) {
            wd3 = -12288;
        }
        band.ap[2] = wd3;
        band.sg[0] = band.p[0] >> 15;
        band.sg[1] = band.p[1] >> 15;
        wd1 = band.sg[0] == band.sg[1] ? 192 : -192;
        wd2 = band.a[1] * 32640 >> 15;
        band.ap[1] = g722.saturate(wd1 + wd2);
        wd3 = g722.saturate(15360 - band.ap[2]);
        if (band.ap[1] > wd3) {
            band.ap[1] = wd3;
        } else if (band.ap[1] < -wd3) {
            band.ap[1] = -wd3;
        }
        wd1 = d == 0 ? 0 : 128;
        band.sg[0] = d >> 15;
        for (i = 1; i < 7; ++i) {
            band.sg[i] = band.d[i] >> 15;
            wd2 = band.sg[i] == band.sg[0] ? wd1 : -wd1;
            wd3 = band.b[i] * 32640 >> 15;
            band.bp[i] = g722.saturate(wd2 + wd3);
        }
        for (i = 6; i > 0; --i) {
            band.d[i] = band.d[i - 1];
            band.b[i] = band.bp[i];
        }
        for (i = 2; i > 0; --i) {
            band.r[i] = band.r[i - 1];
            band.p[i] = band.p[i - 1];
            band.a[i] = band.ap[i];
        }
        wd1 = g722.saturate(band.r[1] + band.r[1]);
        wd1 = band.a[1] * wd1 >> 15;
        wd2 = g722.saturate(band.r[2] + band.r[2]);
        wd2 = band.a[2] * wd2 >> 15;
        band.sp = g722.saturate(wd1 + wd2);
        band.sz = 0;
        for (i = 6; i > 0; --i) {
            wd1 = g722.saturate(band.d[i] + band.d[i]);
            band.sz += band.b[i] * wd1 >> 15;
        }
        band.sz = g722.saturate(band.sz);
        band.s = g722.saturate(band.sp + band.sz);
    }

    @Override
    public byte[] encode(short[] src16) {
        RTPChannel rtpChannel = this.rtp.getDefaultChannel();
        RTPChannel.buildHeader(this.encoded, 9, rtpChannel.getseqnum(), rtpChannel.gettimestamp(160), rtpChannel.getssrc(), false);
        int g722_bytes = 12;
        int xhigh = 0;
        int j = 0;
        while (j < src16.length) {
            int code;
            int wd1;
            int i;
            int xlow;
            if (this.itu_test_mode) {
                xlow = xhigh = src16[j++] >> 1;
            } else if (this.eight_k) {
                xlow = src16[j++] >> 1;
            } else {
                for (i = 0; i < 22; ++i) {
                    this.e_x[i] = this.e_x[i + 2];
                }
                this.e_x[22] = src16[j++];
                this.e_x[23] = src16[j++];
                int sumeven = 0;
                int sumodd = 0;
                for (i = 0; i < 12; ++i) {
                    sumodd += this.e_x[2 * i] * this.qmf_coeffs[i];
                    sumeven += this.e_x[2 * i + 1] * this.qmf_coeffs[11 - i];
                }
                xlow = sumeven + sumodd >> 14;
                xhigh = sumeven - sumodd >> 14;
            }
            int el = g722.saturate(xlow - this.e_band[0].s);
            int wd = el >= 0 ? el : -(el + 1);
            for (i = 1; i < 30 && wd >= (wd1 = this.q6[i] * this.e_band[0].det >> 12); ++i) {
            }
            int ilow = el < 0 ? this.iln[i] : this.ilp[i];
            int ril = ilow >> 2;
            int wd2 = this.qm4[ril];
            int dlow = this.e_band[0].det * wd2 >> 15;
            int il4 = this.rl42[ril];
            wd = this.e_band[0].nb * 127 >> 7;
            this.e_band[0].nb = wd + this.wl[il4];
            if (this.e_band[0].nb < 0) {
                this.e_band[0].nb = 0;
            } else if (this.e_band[0].nb > 18432) {
                this.e_band[0].nb = 18432;
            }
            wd1 = this.e_band[0].nb >> 6 & 0x1F;
            wd2 = 8 - (this.e_band[0].nb >> 11);
            int wd3 = wd2 < 0 ? this.ilb[wd1] << -wd2 : this.ilb[wd1] >> wd2;
            this.e_band[0].det = wd3 << 2;
            this.block4(this.e_band[0], dlow);
            if (this.eight_k) {
                code = (0xC0 | ilow) >> 8 - this.bits_per_sample;
            } else {
                int eh = g722.saturate(xhigh - this.e_band[1].s);
                wd = eh >= 0 ? eh : -(eh + 1);
                wd1 = 564 * this.e_band[1].det >> 12;
                int mih = wd >= wd1 ? 2 : 1;
                int ihigh = eh < 0 ? this.ihn[mih] : this.ihp[mih];
                wd2 = this.qm2[ihigh];
                int dhigh = this.e_band[1].det * wd2 >> 15;
                int ih2 = this.rh2[ihigh];
                wd = this.e_band[1].nb * 127 >> 7;
                this.e_band[1].nb = wd + this.wh[ih2];
                if (this.e_band[1].nb < 0) {
                    this.e_band[1].nb = 0;
                } else if (this.e_band[1].nb > 22528) {
                    this.e_band[1].nb = 22528;
                }
                wd1 = this.e_band[1].nb >> 6 & 0x1F;
                wd2 = 10 - (this.e_band[1].nb >> 11);
                wd3 = wd2 < 0 ? this.ilb[wd1] << -wd2 : this.ilb[wd1] >> wd2;
                this.e_band[1].det = wd3 << 2;
                this.block4(this.e_band[1], dhigh);
                code = (ihigh << 6 | ilow) >> 8 - this.bits_per_sample;
            }
            if (this.packed) {
                this.out_buffer |= code << this.out_bits;
                this.out_bits += this.bits_per_sample;
                if (this.out_bits < 8) continue;
                this.encoded[g722_bytes++] = (byte)(this.out_buffer & 0xFF);
                this.out_bits -= 8;
                this.out_buffer >>= 8;
                continue;
            }
            this.encoded[g722_bytes++] = (byte)code;
        }
        return this.encoded;
    }

    @Override
    public short[] decode(byte[] src8, int off, int length) {
        off += 12;
        int outlen = 0;
        int rhigh = 0;
        int j = 0;
        while (j < 160) {
            int i;
            int wd2;
            int ihigh;
            int wd1;
            int code;
            if (this.packed) {
                if (this.in_bits < this.bits_per_sample) {
                    this.in_buffer |= (src8[off + j++] & 0xFF) << this.in_bits;
                    this.in_bits += 8;
                }
                code = this.in_buffer & (1 << this.bits_per_sample) - 1;
                this.in_buffer >>= this.bits_per_sample;
                this.in_bits -= this.bits_per_sample;
            } else {
                code = src8[off + j++] & 0xFF;
            }
            switch (this.bits_per_sample) {
                default: {
                    wd1 = code & 0x3F;
                    ihigh = code >> 6 & 3;
                    wd2 = this.qm6[wd1];
                    wd1 >>= 2;
                    break;
                }
                case 7: {
                    wd1 = code & 0x1F;
                    ihigh = code >> 5 & 3;
                    wd2 = this.qm5[wd1];
                    wd1 >>= 1;
                    break;
                }
                case 6: {
                    wd1 = code & 0xF;
                    ihigh = code >> 4 & 3;
                    wd2 = this.qm4[wd1];
                }
            }
            wd2 = this.d_band[0].det * wd2 >> 15;
            int rlow = this.d_band[0].s + wd2;
            if (rlow > 16383) {
                rlow = 16383;
            } else if (rlow < -16384) {
                rlow = -16384;
            }
            wd2 = this.qm4[wd1];
            int dlowt = this.d_band[0].det * wd2 >> 15;
            wd2 = this.rl42[wd1];
            wd1 = this.d_band[0].nb * 127 >> 7;
            if ((wd1 += this.wl[wd2]) < 0) {
                wd1 = 0;
            } else if (wd1 > 18432) {
                wd1 = 18432;
            }
            this.d_band[0].nb = wd1;
            wd1 = this.d_band[0].nb >> 6 & 0x1F;
            wd2 = 8 - (this.d_band[0].nb >> 11);
            int wd3 = wd2 < 0 ? this.ilb[wd1] << -wd2 : this.ilb[wd1] >> wd2;
            this.d_band[0].det = wd3 << 2;
            this.block4(this.d_band[0], dlowt);
            if (!this.eight_k) {
                wd2 = this.qm2[ihigh];
                int dhigh = this.d_band[1].det * wd2 >> 15;
                rhigh = dhigh + this.d_band[1].s;
                if (rhigh > 16383) {
                    rhigh = 16383;
                } else if (rhigh < -16384) {
                    rhigh = -16384;
                }
                wd2 = this.rh2[ihigh];
                wd1 = this.d_band[1].nb * 127 >> 7;
                if ((wd1 += this.wh[wd2]) < 0) {
                    wd1 = 0;
                } else if (wd1 > 22528) {
                    wd1 = 22528;
                }
                this.d_band[1].nb = wd1;
                wd1 = this.d_band[1].nb >> 6 & 0x1F;
                wd2 = 10 - (this.d_band[1].nb >> 11);
                wd3 = wd2 < 0 ? this.ilb[wd1] << -wd2 : this.ilb[wd1] >> wd2;
                this.d_band[1].det = wd3 << 2;
                this.block4(this.d_band[1], dhigh);
            }
            if (this.itu_test_mode) {
                this.decoded[outlen++] = (short)(rlow << 1);
                this.decoded[outlen++] = (short)(rhigh << 1);
                continue;
            }
            if (this.eight_k) {
                this.decoded[outlen++] = (short)(rlow << 1);
                continue;
            }
            for (i = 0; i < 22; ++i) {
                this.d_x[i] = this.d_x[i + 2];
            }
            this.d_x[22] = rlow + rhigh;
            this.d_x[23] = rlow - rhigh;
            int xout1 = 0;
            int xout2 = 0;
            for (i = 0; i < 12; ++i) {
                xout2 += this.d_x[2 * i] * this.qmf_coeffs[i];
                xout1 += this.d_x[2 * i + 1] * this.qmf_coeffs[11 - i];
            }
            this.decoded[outlen++] = (short)(xout1 >> 11);
            this.decoded[outlen++] = (short)(xout2 >> 11);
        }
        return this.decoded;
    }

    @Override
    public int getSampleRate() {
        return 16000;
    }

    @Override
    public void close() {
    }

    private static class Band {
        int s;
        int sp;
        int sz;
        int[] r = new int[3];
        int[] a = new int[3];
        int[] ap = new int[3];
        int[] p = new int[3];
        int[] d = new int[7];
        int[] b = new int[7];
        int[] bp = new int[7];
        int[] sg = new int[7];
        int nb;
        int det;

        private Band() {
        }
    }
}

