/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.MQTTEvents;
import javaforce.MQTTForward;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;

public class MQTTServer {
    public static final String busPack = "net.sf.jfmqtt";
    private static MQTTServer service;
    private static JBusServer busServer;
    private ArrayList<ServerWorker> servers = new ArrayList();
    private static String defaultConfig;
    private Server server;
    private Config config;
    private Object lock = new Object();
    private HashMap<String, Topic> topics = new HashMap();
    private MQTTEvents events;
    private KeyMgmt keys;
    private MQTTForward forwarder;
    private JBusClient busClient;
    private static int bufsiz;
    public static boolean debug;
    public static boolean debug_msg;
    public static final byte CMD_CONNECT = 1;
    public static final byte CMD_CONNECT_ACK = 2;
    public static final byte CMD_PUBLISH = 3;
    public static final byte CMD_PUBLISH_ACK = 4;
    public static final byte CMD_PUBLISH_REC = 5;
    public static final byte CMD_PUBLISH_REL = 6;
    public static final byte CMD_PUBLISH_CMP = 7;
    public static final byte CMD_SUBSCRIBE = 8;
    public static final byte CMD_SUBSCRIBE_ACK = 9;
    public static final byte CMD_UNSUBSCRIBE = 10;
    public static final byte CMD_UNSUBSCRIBE_ACK = 11;
    public static final byte CMD_PING = 12;
    public static final byte CMD_PONG = 13;
    public static final byte CMD_DISCONNECT = 14;
    public static final byte CMD_AUTH = 15;
    public static final byte RESERVED = 0;
    public static final byte RESERVED_2 = 2;
    public static final byte QOS_0 = 0;
    public static final byte QOS_1 = 1;
    public static final byte QOS_2 = 2;
    public static final byte QOS_3 = 3;
    public static final byte FLAG_CLEAN_START = 2;
    public static final byte FLAG_PASS = 64;
    public static final byte FLAG_USER = -128;
    public static Client[] ClientArrayType;

    public static void serviceStart(String[] args) {
        service = new MQTTServer();
        service.start();
        if (JF.isWindows()) {
            busServer = new JBusServer(MQTTServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        String[] stringArray = args;
        int n = stringArray.length;
        block9: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "debug": {
                    debug = true;
                    JFLog.log("debug enabled");
                    continue block9;
                }
                case "debug_msg": {
                    debug_msg = true;
                    JFLog.log("debug messages enabled");
                }
            }
        }
    }

    public static void serviceStop() {
        if (service != null) {
            service.stop();
            service = null;
        }
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33014;
        }
        return 777;
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfmqtt.log";
    }

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfmqtt.cfg";
    }

    private static String getKeyFile() {
        return JF.getConfigPath() + "/jfmqtt.key";
    }

    public void setListener(MQTTEvents events) {
        this.events = events;
    }

    public void start() {
        this.server = new Server();
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.server == null) {
            return;
        }
        this.server.active = false;
        Object object = this.lock;
        synchronized (object) {
            ServerWorker[] sa;
            for (ServerWorker s : sa = this.servers.toArray(new ServerWorker[0])) {
                s.close();
            }
            this.servers.clear();
        }
        if (this.forwarder != null) {
            this.forwarder.stop();
            this.forwarder = null;
        }
        if (this.busClient != null) {
            this.busClient.close();
            this.busClient = null;
        }
        object = this.server;
        synchronized (object) {
            this.server.notify();
        }
        this.server = null;
    }

    private static Config loadConfig() {
        try {
            String forward_pass;
            String forward_user;
            String forward_topic;
            String forward_port;
            String forward;
            String pass;
            String user;
            String secure;
            File file = new File(MQTTServer.getConfigFile());
            FileInputStream fis = new FileInputStream(file);
            Properties props = new Properties();
            props.load(fis);
            fis.close();
            Config config = new Config();
            String port = props.getProperty("port");
            if (port != null) {
                config.port = JF.atoi(port);
                if (config.port <= 0 || config.port > 65535) {
                    config.port = 1883;
                }
            }
            if ((secure = props.getProperty("secure")) != null) {
                config.secure = JF.atoi(secure);
                if (config.secure <= 0 || config.secure > 65535) {
                    config.secure = 1883;
                }
            }
            if ((user = props.getProperty("user")) != null) {
                config.user = user;
            }
            if ((pass = props.getProperty("pass")) != null) {
                config.pass = pass;
            }
            if ((forward = props.getProperty("forward")) != null) {
                config.forward = forward;
            }
            if ((forward_port = props.getProperty("forward.port")) != null) {
                config.forward_port = JF.atoi(forward_port);
                if (config.forward_port <= 0 || config.forward_port > 65535) {
                    config.forward_port = 1883;
                }
            }
            String forward_secure = props.getProperty("forward.secure");
            if (forward_port != null) {
                config.forward_secure = forward_secure.equals("true");
            }
            if ((forward_topic = props.getProperty("forward.topic")) != null) {
                config.forward_topic = forward_topic;
            }
            if ((forward_user = props.getProperty("forward.user")) != null) {
                config.forward_user = forward_user;
            }
            if ((forward_pass = props.getProperty("forward.pass")) != null) {
                config.forward_pass = forward_pass;
            }
            return config;
        }
        catch (FileNotFoundException e) {
            try {
                FileOutputStream fos = new FileOutputStream(MQTTServer.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
            }
            catch (Exception e2) {
                JFLog.log(e2);
            }
            return new Config();
        }
        catch (Exception e) {
            JFLog.log(e);
            return new Config();
        }
    }

    private void loadKeys() {
        try {
            this.keys = new KeyMgmt();
            if (new File(MQTTServer.getKeyFile()).exists()) {
                FileInputStream fis = new FileInputStream(MQTTServer.getKeyFile());
                this.keys.open(fis, "password");
                fis.close();
            } else {
                JFLog.log("Warning:Server SSL Keys not generated!");
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static boolean hasWildcard(String topic) {
        if (topic.indexOf(43) != -1) {
            return true;
        }
        return topic.indexOf(35) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic getTopic(String name) {
        Object object = this.lock;
        synchronized (object) {
            Topic topic = this.topics.get(name);
            if (topic != null) {
                return topic;
            }
            topic = new Topic(name);
            this.topics.put(name, topic);
            return topic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic[] getTopics(String wc) {
        ArrayList<Topic> topics_sub = new ArrayList<Topic>();
        Object object = this.lock;
        synchronized (object) {
            for (Topic topic : this.topics.values().toArray(Topic.TopicArrayType)) {
                if (!topic.matches(wc)) continue;
                topics_sub.add(topic);
            }
        }
        return topics_sub.toArray(Topic.TopicArrayType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeAll(Client client) {
        Object object = this.lock;
        synchronized (object) {
            Topic[] alltopics;
            for (Topic topic : alltopics = this.topics.values().toArray(Topic.TopicArrayType)) {
                topic.unsubscribe(client);
            }
        }
    }

    private int getLength(byte[] data, int pos, int length) {
        int next;
        int multi = 1;
        int value = 0;
        do {
            if (pos >= length) {
                return -1;
            }
            next = data[pos++] & 0xFF;
            value += (next & 0x7F) * multi;
            multi *= 128;
        } while (next >= 128);
        return value;
    }

    private int getStringLength(byte[] data, int topicPosition) {
        return BE.getuint16(data, topicPosition);
    }

    private String getString(byte[] data, int offset, int length) {
        return new String(data, offset, length);
    }

    private short getPacketID(byte[] data, int idPosition) {
        return (short)BE.getuint16(data, idPosition);
    }

    private void setPacketLength(byte[] packet) {
        int value = packet.length - 2;
        int pos = 1;
        do {
            byte ebyte = (byte)(value % 128);
            if ((value /= 128) > 0) {
                ebyte = (byte)(ebyte | 0x80);
            }
            packet[pos++] = ebyte;
        } while (value > 0);
    }

    private void setPacketID(byte[] data, int offset, short id) {
        BE.setuint16(data, offset, id);
    }

    private int getLengthBytes(int length) {
        if (length <= 127) {
            return 1;
        }
        if (length <= 1023) {
            return 2;
        }
        if (length <= 0x1FFFFF) {
            return 3;
        }
        if (length <= 0xFFFFFFF) {
            return 4;
        }
        return -1;
    }

    public static boolean createKeys() {
        return KeyMgmt.keytool(new String[]{"-genkey", "-debug", "-alias", "jfmqtt", "-keypass", "password", "-storepass", "password", "-keystore", MQTTServer.getKeyFile(), "-validity", "3650", "-dname", "CN=jfmqtt.sourceforge.net, OU=user, O=server, C=CA", "-keyalg", "RSA", "-keysize", "2048"});
    }

    static {
        defaultConfig = "port=1883\nsecure=8883\n#user=username\n#pass=password\n#forward=host\n#forward.port=1883 or 8883\n#forward.secure=true\n#forward.topic=#\n#forward.user=username\n#forward.pass=password\n";
        bufsiz = 4096;
        debug = false;
        debug_msg = false;
        ClientArrayType = new Client[0];
    }

    private class Server
    extends Thread {
        public boolean active;

        private Server() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.active = true;
            try {
                Thread worker;
                JFLog.append(MQTTServer.getLogFile(), true);
                MQTTServer.this.config = MQTTServer.loadConfig();
                MQTTServer.this.loadKeys();
                if (MQTTServer.this.config.forward != null) {
                    MQTTServer.this.forwarder = new MQTTForward();
                    KeyMgmt forward_keys = null;
                    if (MQTTServer.this.config.forward_secure) {
                        forward_keys = MQTTServer.this.keys;
                    }
                    if (MQTTServer.this.config.forward_user != null && MQTTServer.this.config.forward_pass != null) {
                        MQTTServer.this.forwarder.start(MQTTServer.this.config.forward, MQTTServer.this.config.forward_port, forward_keys, MQTTServer.this.config.forward_user, MQTTServer.this.config.forward_pass);
                    } else {
                        MQTTServer.this.forwarder.start(MQTTServer.this.config.forward, MQTTServer.this.config.forward_port, forward_keys);
                    }
                }
                MQTTServer.this.busClient = new JBusClient(MQTTServer.busPack, new JBusMethods());
                MQTTServer.this.busClient.setPort(MQTTServer.getBusPort());
                MQTTServer.this.busClient.start();
                if (MQTTServer.this.config.port > 0) {
                    worker = new ServerWorker(MQTTServer.this.config.port, false);
                    worker.start();
                    MQTTServer.this.servers.add((ServerWorker)worker);
                }
                if (MQTTServer.this.config.secure > 0) {
                    worker = new ServerWorker(MQTTServer.this.config.secure, true);
                    worker.start();
                    MQTTServer.this.servers.add((ServerWorker)worker);
                }
                while (this.active) {
                    worker = this;
                    synchronized (worker) {
                        this.wait();
                    }
                }
                return;
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    private class ServerWorker
    extends Thread {
        private ServerSocket ss;
        private int port;
        private boolean secure;
        public boolean worker_active;

        public ServerWorker(int port, boolean secure) {
            this.port = port;
            this.secure = secure;
        }

        @Override
        public void run() {
            try {
                if (this.secure) {
                    JFLog.log("CreateServerSocketSSL:" + this.port);
                    this.ss = JF.createServerSocketSSL(this.port, MQTTServer.this.keys);
                } else {
                    JFLog.log("CreateServerSocket:" + this.port);
                    this.ss = new ServerSocket(this.port);
                }
                this.worker_active = true;
                while (this.worker_active) {
                    Socket s = this.ss.accept();
                    Client client = new Client(s);
                    client.start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void close() {
            this.worker_active = false;
            if (this.ss != null) {
                try {
                    this.ss.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ss = null;
            }
        }
    }

    private static class Config {
        public int port = 1883;
        public int secure = 8883;
        public String user;
        public String pass;
        public String forward;
        public int forward_port = 1883;
        public boolean forward_secure;
        public String forward_topic = "#";
        public String forward_user;
        public String forward_pass;

        private Config() {
        }
    }

    private static class Topic {
        private String name;
        private byte[] pkt;
        private int pkt_length;
        private ArrayList<Client> subs = new ArrayList();
        private Object lock = new Object();
        public static Topic[] TopicArrayType = new Topic[0];

        public Topic(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(byte[] pkt, int length, boolean retain) {
            pkt[0] = (byte)(pkt[0] & 0xF6);
            if (retain) {
                this.pkt = (byte[])pkt.clone();
                this.pkt_length = length;
            }
            Object object = this.lock;
            synchronized (object) {
                for (Client sub : this.subs.toArray(ClientArrayType)) {
                    try {
                        sub.publish(pkt, length);
                    }
                    catch (Exception e) {
                        this.unsubscribe(sub);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribe(Client client) {
            Object object = this.lock;
            synchronized (object) {
                this.subs.add(client);
            }
            if (this.pkt != null) {
                try {
                    client.publish(this.pkt, this.pkt_length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unsubscribe(Client client) {
            Object object = this.lock;
            synchronized (object) {
                this.subs.remove(client);
            }
        }

        public boolean matches(String topic) {
            String[] ns = this.name.split("[/]");
            String[] ws = topic.split("[/]");
            int wi = 0;
            for (int ni = 0; ni < ns.length; ++ni) {
                String n = ns[ni];
                if (wi == ws.length) {
                    return false;
                }
                String w = ws[wi];
                ++wi;
                if (w.equals("+")) continue;
                if (w.equals("#")) {
                    return true;
                }
                if (n.equals(w)) continue;
                return false;
            }
            if (wi != ws.length) {
                String w = ws[wi];
                return w.equals("#");
            }
            return true;
        }
    }

    private class Client
    extends Thread {
        public Socket s;
        public InputStream is;
        public OutputStream os;
        public String ip;
        public boolean client_active = true;
        public String client_id;
        public boolean auth;

        public Client(Socket s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                this.is = this.s.getInputStream();
                this.os = this.s.getOutputStream();
                this.ip = this.s.getInetAddress().getHostAddress();
                if (debug) {
                    JFLog.log("connect:" + this.ip);
                }
                byte[] buf = new byte[bufsiz];
                if (MQTTServer.this.config.user == null || MQTTServer.this.config.pass == null) {
                    this.auth = true;
                }
                block5: while (MQTTServer.this.server.active && this.client_active) {
                    int totalRead = 0;
                    int packetLength = -1;
                    int totalLength = -1;
                    Arrays.fill(buf, (byte)0);
                    while (MQTTServer.this.server.active && this.client_active) {
                        int read = packetLength == -1 ? this.is.read(buf, totalRead, 1) : this.is.read(buf, totalRead, totalLength - totalRead);
                        if (debug) {
                            JFLog.log("read=" + read);
                        }
                        if (read == -1) {
                            throw new Exception("bad read");
                        }
                        if ((totalRead += read) < 2) continue;
                        if (packetLength == -1 && (packetLength = MQTTServer.this.getLength(buf, 1, totalRead)) != -1) {
                            totalLength = 1 + MQTTServer.this.getLengthBytes(packetLength) + packetLength;
                            if (debug) {
                                JFLog.log("totalLength=" + totalLength);
                            }
                        }
                        if (packetLength == -1 || totalRead < totalLength) continue;
                        try {
                            this.process(buf, totalLength, packetLength);
                        }
                        catch (Exception e) {
                            JFLog.log(e);
                        }
                        continue block5;
                    }
                }
            }
            catch (SocketException buf) {
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            MQTTServer.this.unsubscribeAll(this);
            if (debug) {
                JFLog.log("disconnect:" + this.ip);
            }
        }

        private void process(byte[] packet, int totalLength, int packetLength) throws Exception {
            byte[] reply = null;
            byte cmd = (byte)((packet[0] & 0xF0) >> 4);
            short id = 0;
            if (debug) {
                JFLog.log("cmd=" + cmd);
            }
            switch (cmd) {
                case 1: {
                    int pos = 1 + MQTTServer.this.getLengthBytes(packetLength);
                    byte ver = packet[pos + 6];
                    byte flags = packet[pos + 7];
                    int props_length = MQTTServer.this.getLength(packet, pos += 10, totalLength);
                    if (props_length == -1) {
                        throw new Exception("malformed packet");
                    }
                    int props_length_bytes = MQTTServer.this.getLengthBytes(props_length);
                    pos += props_length_bytes;
                    if (props_length > 0) {
                        pos += props_length_bytes;
                    }
                    int client_id_length = BE.getuint16(packet, pos);
                    this.client_id = MQTTServer.this.getString(packet, pos += 2, client_id_length);
                    if (debug) {
                        JFLog.log("client_id=" + this.client_id);
                    }
                    pos += client_id_length;
                    String user = null;
                    if ((flags & 0xFFFFFF80) != 0) {
                        int user_length = BE.getuint16(packet, pos);
                        user = MQTTServer.this.getString(packet, pos += 2, user_length);
                        pos += user_length;
                    }
                    String pass = null;
                    if ((flags & 0x40) != 0) {
                        int pass_length = BE.getuint16(packet, pos);
                        pass = MQTTServer.this.getString(packet, pos += 2, pass_length);
                        pos += pass_length;
                    }
                    if (MQTTServer.this.config.user != null && MQTTServer.this.config.pass != null) {
                        if (user == null || !user.equals(MQTTServer.this.config.user) || pass == null || !pass.equals(MQTTServer.this.config.pass)) {
                            if (debug) {
                                JFLog.log("auth failed:" + user + ":" + pass);
                            }
                            this.disconnect();
                            break;
                        }
                        this.auth = true;
                    }
                    reply = new byte[5];
                    reply[0] = 32;
                    MQTTServer.this.setPacketLength(reply);
                    if (MQTTServer.this.events == null) break;
                    MQTTServer.this.events.onConnect();
                    break;
                }
                case 3: {
                    int props_length;
                    boolean retain;
                    if (!this.auth) {
                        this.disconnect();
                        break;
                    }
                    boolean dup = (packet[0] & 8) != 0;
                    byte qos = (byte)((packet[0] & 6) >> 1);
                    boolean bl = retain = (packet[0] & 1) != 0;
                    if (qos == 3) {
                        throw new Exception("malformed packet");
                    }
                    int pos = 1 + MQTTServer.this.getLengthBytes(packetLength);
                    int topicLength = MQTTServer.this.getStringLength(packet, pos);
                    if (debug) {
                        JFLog.log("topic=" + pos + "/" + topicLength);
                    }
                    String topic_name = MQTTServer.this.getString(packet, pos += 2, topicLength);
                    pos += topicLength;
                    if (qos > 0) {
                        id = MQTTServer.this.getPacketID(packet, pos);
                        if (debug) {
                            JFLog.log("id=" + id);
                        }
                        pos += 2;
                    }
                    if ((props_length = MQTTServer.this.getLength(packet, pos, totalLength)) == -1) {
                        throw new Exception("malformed packet");
                    }
                    int props_length_bytes = MQTTServer.this.getLengthBytes(props_length);
                    pos += props_length_bytes;
                    if (props_length > 0) {
                        pos += props_length_bytes;
                    }
                    int msgLength = totalLength - pos;
                    if (debug) {
                        JFLog.log("msg=" + pos + "/" + msgLength);
                    }
                    String msg = new String(packet, pos, msgLength);
                    if (debug_msg) {
                        JFLog.log("PUBLISH:" + this.ip + ":" + topic_name + ":" + msg);
                    }
                    Topic topic = MQTTServer.this.getTopic(topic_name);
                    topic.publish(packet, totalLength, retain);
                    switch (qos) {
                        case 1: {
                            reply = new byte[4];
                            reply[0] = 64;
                            MQTTServer.this.setPacketLength(reply);
                            MQTTServer.this.setPacketID(reply, 2, id);
                            break;
                        }
                        case 2: {
                            reply = new byte[4];
                            reply[0] = 80;
                            MQTTServer.this.setPacketLength(reply);
                            MQTTServer.this.setPacketID(reply, 2, id);
                        }
                    }
                    if (MQTTServer.this.events != null) {
                        MQTTServer.this.events.onMessage(topic_name, msg);
                    }
                    if (MQTTServer.this.forwarder == null) break;
                    MQTTServer.this.forwarder.publish(topic_name, msg);
                    break;
                }
                case 4: {
                    if (this.auth) break;
                    this.disconnect();
                    break;
                }
                case 5: {
                    if (this.auth) break;
                    this.disconnect();
                    break;
                }
                case 6: {
                    if (!this.auth) {
                        this.disconnect();
                        break;
                    }
                    reply = new byte[4];
                    reply[0] = 112;
                    MQTTServer.this.setPacketLength(reply);
                    id = MQTTServer.this.getPacketID(packet, 2);
                    MQTTServer.this.setPacketID(reply, 2, id);
                    break;
                }
                case 7: {
                    if (this.auth) break;
                    this.disconnect();
                    break;
                }
                case 8: {
                    if (!this.auth) {
                        this.disconnect();
                        break;
                    }
                    int pos = 1 + MQTTServer.this.getLengthBytes(packetLength);
                    id = MQTTServer.this.getPacketID(packet, pos);
                    if (debug) {
                        JFLog.log("id=" + id);
                    }
                    int props_length = MQTTServer.this.getLength(packet, pos += 2, totalLength);
                    int props_length_bytes = MQTTServer.this.getLengthBytes(props_length);
                    pos += props_length_bytes;
                    if (props_length > 0) {
                        pos += props_length_bytes;
                    }
                    while (pos < totalLength) {
                        int topicLength = MQTTServer.this.getStringLength(packet, pos);
                        if (debug) {
                            JFLog.log("topic=" + pos + "/" + topicLength);
                        }
                        String topic_name = MQTTServer.this.getString(packet, pos += 2, topicLength);
                        pos += topicLength;
                        if (MQTTServer.hasWildcard(topic_name)) {
                            Topic[] topics;
                            for (Topic topic : topics = MQTTServer.this.getTopics(topic_name)) {
                                topic.subscribe(this);
                            }
                        } else {
                            Topic topic = MQTTServer.this.getTopic(topic_name);
                            topic.subscribe(this);
                        }
                        if (debug_msg) {
                            JFLog.log("SUBSCRIBE:" + this.ip + ":" + topic_name);
                        }
                        if (MQTTServer.this.events != null) {
                            MQTTServer.this.events.onSubscribe(topic_name);
                        }
                        ++pos;
                    }
                    reply = new byte[5];
                    reply[0] = -112;
                    MQTTServer.this.setPacketLength(reply);
                    MQTTServer.this.setPacketID(reply, 2, id);
                    break;
                }
                case 10: {
                    int props_length;
                    if (!this.auth) {
                        this.disconnect();
                        break;
                    }
                    int pos = 1 + MQTTServer.this.getLengthBytes(packetLength);
                    id = MQTTServer.this.getPacketID(packet, pos);
                    if (debug) {
                        JFLog.log("id=" + id);
                    }
                    if ((props_length = MQTTServer.this.getLength(packet, pos += 2, totalLength)) == -1) {
                        throw new Exception("malformed packet");
                    }
                    int props_length_bytes = MQTTServer.this.getLengthBytes(props_length);
                    pos += props_length_bytes;
                    if (props_length > 0) {
                        pos += props_length_bytes;
                    }
                    while (pos < totalLength) {
                        int topicLength = MQTTServer.this.getStringLength(packet, pos);
                        pos += 2;
                        if (debug) {
                            JFLog.log("topic=" + pos + "/" + topicLength);
                        }
                        String topic_name = MQTTServer.this.getString(packet, pos, topicLength);
                        pos += topicLength;
                        Topic topic = MQTTServer.this.getTopic(topic_name);
                        topic.unsubscribe(this);
                        if (!debug_msg) continue;
                        JFLog.log("UNSUB:" + this.ip + ":" + topic_name);
                    }
                    reply = new byte[5];
                    reply[0] = -80;
                    MQTTServer.this.setPacketLength(reply);
                    MQTTServer.this.setPacketID(reply, 2, id);
                    break;
                }
                case 12: {
                    if (!this.auth) {
                        this.disconnect();
                        break;
                    }
                    reply = new byte[2];
                    reply[0] = -48;
                    if (!debug_msg) break;
                    JFLog.log("PING:" + this.ip);
                    break;
                }
                case 14: {
                    this.disconnect();
                }
            }
            if (reply != null) {
                this.send(reply);
            }
        }

        private void send(byte[] reply) throws Exception {
            this.os.write(reply);
        }

        public void publish(byte[] pkt, int length) throws Exception {
            this.os.write(pkt, 0, length);
        }

        private void disconnect() {
            MQTTServer.this.unsubscribeAll(this);
            this.client_active = false;
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.s = null;
        }
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            byte[] cfg = JF.readFile(MQTTServer.getConfigFile());
            if (cfg == null) {
                cfg = new byte[]{};
            }
            String config = new String(cfg);
            MQTTServer.service.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(config)));
        }

        public void setConfig(String cfg) {
            try {
                FileOutputStream fos = new FileOutputStream(MQTTServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            service.stop();
            service = new MQTTServer();
            service.start();
        }

        public void genKeys(String pack) {
            if (MQTTServer.createKeys()) {
                JFLog.log("Generated Keys");
                JBusClient cfr_ignored_0 = MQTTServer.service.busClient;
                MQTTServer.service.busClient.call(pack, "getKeys", JBusClient.quote("OK"));
            } else {
                JBusClient cfr_ignored_1 = MQTTServer.service.busClient;
                MQTTServer.service.busClient.call(pack, "getKeys", JBusClient.quote("ERROR"));
            }
        }
    }
}

