/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.ui.ChangeListener;
import javaforce.ui.Component;
import javaforce.ui.Dimension;
import javaforce.ui.Icons;
import javaforce.ui.Image;

public class ScrollBar
extends Component {
    private int dir;
    private int value;
    private int viewsize;
    private int fullsize;
    private int v1;
    private int v2;
    private float scale;
    private boolean dragging;
    private int dragstart_mouse;
    private int dragstart_value;
    private int stepsize;
    private int pageSize;
    private ChangeListener change;

    public ScrollBar(int dir) {
        this.dir = dir;
        this.value = 0;
        this.viewsize = 10;
        this.fullsize = 100;
        this.stepsize = 1;
        this.pageSize = 3;
    }

    @Override
    public Dimension getMinSize() {
        switch (this.dir) {
            case 2: {
                if (this.getWidth() >= 32) break;
                this.setSize(32, 16);
                break;
            }
            case 1: {
                if (this.getHeight() >= 32) break;
                this.setSize(16, 32);
            }
        }
        return super.getMinSize();
    }

    public int getFullsize() {
        return this.fullsize;
    }

    public void setFullsize(int size) {
        this.fullsize = size;
    }

    public int getViewsize() {
        return this.viewsize;
    }

    public void setViewsize(int size) {
        this.viewsize = size;
    }

    public int getStepsize() {
        return this.stepsize;
    }

    public void setStepsize(int size) {
        this.stepsize = size;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public void render(Image image) {
        super.render(image);
        int x1 = this.getX();
        int y1 = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        switch (this.dir) {
            case 2: {
                image.drawImageBlend(Icons.getArrowUp(), x1, y1, true);
                y1 += 16;
                float barsize = h - 34;
                this.scale = barsize / (float)this.fullsize;
                float p1 = this.value;
                float p2 = this.value + this.viewsize;
                this.v1 = (int)(p1 *= this.scale);
                this.v2 = (int)(p2 *= this.scale);
                image.drawBox(x1 + 0, y1, 16, h - 32);
                image.drawBox(x1 + 1, ++y1 + this.v1, 14, this.v2 - this.v1 + 1);
                image.drawImageBlend(Icons.getArrowDown(), x1, y1 += h - 33, true);
                break;
            }
            case 1: {
                image.drawImageBlend(Icons.getArrowLeft(), x1, y1, true);
                x1 += 16;
                float barsize = w - 34;
                this.scale = barsize / (float)this.fullsize;
                float p1 = this.value;
                float p2 = this.value + this.viewsize;
                this.v1 = (int)(p1 *= this.scale);
                this.v2 = (int)(p2 *= this.scale);
                image.drawBox(x1, y1 + 0, w - 16, 16);
                image.drawBox(++x1 + this.v1, y1 + 1, this.v2 - this.v1 + 1, 14);
                image.drawImageBlend(Icons.getArrowRight(), x1 += w - 33, y1, true);
                break;
            }
        }
        this.v1 += 17;
        this.v2 += 17;
    }

    private void move(int steps) {
        if (this.fullsize <= this.viewsize) {
            return;
        }
        int newValue = this.value + this.stepsize * steps;
        if (newValue < 0) {
            newValue = 0;
        }
        if (newValue + this.viewsize >= this.fullsize) {
            newValue = this.fullsize - this.viewsize - 1;
        }
        this.moveTo(newValue);
    }

    private void moveTo(int newValue) {
        if (this.fullsize <= this.viewsize) {
            return;
        }
        if (newValue + this.viewsize >= this.fullsize) {
            newValue = this.fullsize - this.viewsize - 1;
        }
        if (newValue < 0) {
            newValue = 0;
        }
        this.setValue(newValue);
        if (this.change != null) {
            this.change.changed(this);
        }
    }

    public void setChangeListener(ChangeListener listener) {
        this.change = listener;
    }

    @Override
    public void mouseDown(int button) {
        if (button == 1) {
            int x1 = this.getX();
            int y1 = this.getY();
            int w = this.getWidth();
            int h = this.getHeight();
            int mx = this.getMouseX();
            int my = this.getMouseY();
            switch (this.dir) {
                case 2: {
                    if ((my -= y1) <= 15) {
                        this.move(-1);
                        break;
                    }
                    if (my <= this.v1) {
                        this.move(-this.pageSize);
                        break;
                    }
                    if (my <= this.v2) {
                        this.dragging = true;
                        this.dragstart_mouse = my;
                        this.dragstart_value = this.value;
                        break;
                    }
                    if (my <= h - 16) {
                        this.move(this.pageSize);
                        break;
                    }
                    this.move(1);
                    break;
                }
                case 1: {
                    if ((mx -= x1) <= 15) {
                        this.move(-1);
                        break;
                    }
                    if (mx <= this.v1) {
                        this.move(-this.pageSize);
                        break;
                    }
                    if (mx <= this.v2) {
                        this.dragging = true;
                        this.dragstart_mouse = mx;
                        this.dragstart_value = this.value;
                        break;
                    }
                    if (mx <= h - 16) {
                        this.move(this.pageSize);
                        break;
                    }
                    this.move(1);
                }
            }
        }
        super.mouseDown(button);
    }

    @Override
    public void mouseUp(int button) {
        if (button == 1) {
            this.dragging = false;
        }
        super.mouseUp(button);
    }

    @Override
    public void mouseMove(int x, int y) {
        super.mouseMove(x, y);
        int x1 = this.getX();
        int y1 = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int mx = this.getMouseX();
        int my = this.getMouseY();
        if (this.dragging) {
            switch (this.dir) {
                case 2: {
                    float p = (my -= y1) - this.dragstart_mouse;
                    this.moveTo(this.dragstart_value + (int)(p /= this.scale));
                    break;
                }
                case 1: {
                    float p = (mx -= x1) - this.dragstart_mouse;
                    this.moveTo(this.dragstart_value + (int)(p /= this.scale));
                    break;
                }
            }
        }
    }
}

