/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Resource;
import javaforce.webui.TextComponent;

public class Button
extends TextComponent {
    private String url;
    private Resource img;

    public Button(String text) {
        this.text = text;
        this.setClass("button");
    }

    public Button(Resource res) {
        this.img = res;
        this.setClass("button");
    }

    @Override
    public String html() {
        if (this.img != null) {
            return "<img" + this.getAttrs() + " src='/static/" + this.img.id + "'>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<button" + this.getAttrs() + ">");
        sb.append(this.text);
        sb.append("</button>");
        return sb.toString();
    }

    @Override
    public void updateText(String text) {
        this.sendEvent("settext", new String[]{"text=" + text});
    }

    public void setURL(String url) {
        this.addEvent("onclick", "window.open(\"" + url + "\");");
        this.url = url;
    }

    public void setImage(Resource img) {
        this.img = img;
        this.sendEvent("setsrc", new String[]{"src=/static/" + img.id});
    }
}

