/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javaforce.ASCII8;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jni.LnxNative;
import javaforce.jni.WinNative;

public class Console {
    private static boolean isWindows = JF.isWindows();

    public static InputStream getInputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                char ch = isWindows ? WinNative.readConsole() : LnxNative.readConsole();
                return ch;
            }

            @Override
            public int read(byte[] buf) throws IOException {
                return this.read(buf, 0, buf.length);
            }

            @Override
            public int read(byte[] buf, int offset, int length) throws IOException {
                int ch;
                int start = offset;
                int end = offset + length;
                int count = 0;
                int i = start;
                while (i < end && (ch = this.read()) != 0 && ch != -1) {
                    buf[i] = (byte)ch;
                    ++i;
                    ++count;
                }
                return count;
            }
        };
    }

    public static OutputStream getOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int utf16) throws IOException {
                char ch = ASCII8.convertUTF16(utf16);
                if (isWindows) {
                    WinNative.writeConsole(ch);
                } else {
                    LnxNative.writeConsole(ch);
                }
            }
        };
    }

    public static void enableConsoleMode() {
        if (JF.isWindows()) {
            WinNative.enableConsoleMode();
        } else {
            LnxNative.enableConsoleMode();
        }
    }

    public static void disableConsoleMode() {
        if (JF.isWindows()) {
            WinNative.disableConsoleMode();
        } else {
            LnxNative.disableConsoleMode();
        }
    }

    public static boolean kbhit() {
        if (JF.isWindows()) {
            return WinNative.peekConsole();
        }
        return LnxNative.peekConsole();
    }

    public static void main(String[] args) {
        Console.enableConsoleMode();
        InputStream is = Console.getInputStream();
        JFLog.log("Press q to quit");
        int ch = 0;
        try {
            do {
                if (Console.kbhit()) {
                    ch = is.read();
                    JFLog.log("ch=" + ch);
                    continue;
                }
                JF.sleep(100);
            } while (ch != 113);
        }
        catch (Exception e) {
            // empty catch block
        }
        Console.disableConsoleMode();
    }
}

