/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.io.File;
import java.io.FileInputStream;
import javaforce.HTTP;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.KeyParams;
import javaforce.awt.VNCWebConsole;
import javaforce.service.WebResponse;
import javaforce.webui.Panel;
import javaforce.webui.WebUIClient;
import javaforce.webui.WebUIHandler;
import javaforce.webui.WebUIServer;

public class VNCWebServer
implements WebUIHandler {
    public WebUIServer secure_server;
    public WebUIServer server;
    private KeyMgmt keys;

    public void start(int port, int secure_port) {
        this.initSecureWebKeys();
        this.server = new WebUIServer();
        this.server.start(this, port);
        this.secure_server = new WebUIServer();
        this.secure_server.start(this, secure_port, this.keys);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        if (this.secure_server != null) {
            this.secure_server.stop();
            this.secure_server = null;
        }
    }

    private void initSecureWebKeys() {
        String keyfile = JF.getConfigPath() + "/jfvncweb.key";
        String password = "password";
        KeyParams params = new KeyParams();
        params.dname = "CN=jfvnc.sourceforge.net, O=server, OU=webserver, C=CA";
        if (new File(keyfile).exists()) {
            this.keys = new KeyMgmt();
            try {
                FileInputStream fis = new FileInputStream(keyfile);
                this.keys.open(fis, password);
                fis.close();
            }
            catch (Exception e) {
                if (!this.keys.isValid()) {
                    this.keys = KeyMgmt.create(keyfile, password, "webserver", params, password);
                }
                JFLog.log(e);
            }
        } else {
            this.keys = KeyMgmt.create(keyfile, password, "webserver", params, password);
        }
    }

    @Override
    public Panel getPanel(String name, HTTP.Parameters params, WebUIClient client) {
        int port = 5900;
        String param_port = params.get("port");
        if (param_port != null && ((port = JF.atoi(param_port)) < 1 || port > 65535)) {
            port = 5900;
        }
        int opts = 0;
        boolean toolbar = true;
        String param_toolbar = params.get("toolbar");
        if (param_toolbar != null) {
            toolbar = param_toolbar.equals("true");
        }
        if (toolbar) {
            opts |= 1;
        }
        boolean scale = false;
        String param_scale = params.get("scale");
        if (param_scale != null) {
            scale = param_scale.equals("true");
        }
        if (scale) {
            opts |= 2;
        }
        String password = params.get("password");
        return VNCWebConsole.createPanel(port, password, opts, client);
    }

    @Override
    public byte[] getResource(String url, HTTP.Parameters params, WebResponse res) {
        return null;
    }

    @Override
    public void clientConnected(WebUIClient client) {
    }

    @Override
    public void clientDisconnected(WebUIClient client) {
    }
}

