/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

public class AudioGenerate {
    private double phaseOffset;
    private static final double TWO_PI = Math.PI * 2;
    public static final int SINE = 1;
    public static final int SQUARE = 2;
    public static final int SAW = 3;

    public void generate(short[] out, int type, int sampleRate, int frequency, float amplitude) {
        switch (type) {
            case 1: {
                this.generate_sine(out, sampleRate, frequency, amplitude);
                break;
            }
            case 2: {
                this.generate_square(out, sampleRate, frequency, amplitude);
                break;
            }
            case 3: {
                this.generate_saw(out, sampleRate, frequency, amplitude);
            }
        }
    }

    public void reset() {
        this.phaseOffset = 0.0;
    }

    private void generate_sine(short[] out, double rate, double frequency, double amplitude) {
        int len = out.length;
        double phaseIncrement = Math.PI * 2 * frequency / rate;
        for (int i = 0; i < len; ++i) {
            out[i] = (short)(amplitude * Math.sin(this.phaseOffset) * 32767.0);
            this.phaseOffset += phaseIncrement;
            if (!(this.phaseOffset >= Math.PI * 2)) continue;
            this.phaseOffset -= Math.PI * 2;
        }
    }

    private void generate_square(short[] out, double rate, double frequency, double amplitude) {
        int len = out.length;
        double phaseIncrement = Math.PI * 2 * frequency / rate;
        for (int i = 0; i < len; ++i) {
            out[i] = (short)((Math.sin(this.phaseOffset) >= 0.0 ? amplitude : -amplitude) * 32767.0);
            this.phaseOffset += phaseIncrement;
            if (!(this.phaseOffset >= Math.PI * 2)) continue;
            this.phaseOffset -= Math.PI * 2;
        }
    }

    private void generate_saw(short[] out, double rate, double frequency, double amplitude) {
        int len = out.length;
        double phaseIncrement = Math.PI * 2 * frequency / rate;
        for (int i = 0; i < len; ++i) {
            out[i] = (short)(amplitude * (2.0 * (this.phaseOffset - Math.floor(this.phaseOffset + 0.5))) * 32767.0);
            this.phaseOffset += phaseIncrement;
            if (!(this.phaseOffset >= Math.PI * 2)) continue;
            this.phaseOffset -= Math.PI * 2;
        }
    }
}

