package javaforce.utils;

import javaforce.awt.*;

/** SystemInfo
 *
 * @author peter.quiring
 */

import javaforce.*;

public class SystemInfo extends javax.swing.JFrame {

  /**
   * Creates new form SystemInfo
   */
  public SystemInfo() {
    initComponents();
    username.setText(System.getenv("USERNAME"));
    computername.setText(System.getenv("COMPUTERNAME"));
    osversion.setText(System.getProperty("os.name") + " (" + System.getProperty("os.version") + ") " + System.getProperty("os.arch"));
    system_name.setText(wmic("csproduct", "name"));
    system_serial.setText(wmic("csproduct", "identifyingnumber"));
    okay.setSelected(true);
    JFAWT.centerWindow(this);
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    okay = new javax.swing.JButton();
    jLabel1 = new javax.swing.JLabel();
    username = new javax.swing.JTextField();
    jLabel2 = new javax.swing.JLabel();
    computername = new javax.swing.JTextField();
    jLabel3 = new javax.swing.JLabel();
    osversion = new javax.swing.JTextField();
    jLabel4 = new javax.swing.JLabel();
    system_name = new javax.swing.JTextField();
    jLabel5 = new javax.swing.JLabel();
    system_serial = new javax.swing.JTextField();

    setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    setTitle("System Info");

    okay.setText("OK");
    okay.setFocusCycleRoot(true);
    okay.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okayActionPerformed(evt);
      }
    });

    jLabel1.setText("User name");

    username.setEditable(false);

    jLabel2.setText("Computer name");

    computername.setEditable(false);

    jLabel3.setText("Windows version");

    osversion.setEditable(false);

    jLabel4.setText("System Name");

    system_name.setEditable(false);

    jLabel5.setText("System Serial");

    system_serial.setEditable(false);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addComponent(okay))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel1)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(username))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel2)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(computername))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel3)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(osversion, javax.swing.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel4)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(system_name))
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addComponent(jLabel5)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(system_serial)))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(jLabel1)
          .addComponent(username, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel2)
          .addComponent(computername, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel3)
          .addComponent(osversion, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel4)
          .addComponent(system_name, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel5)
          .addComponent(system_serial, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addComponent(okay)
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void okayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayActionPerformed
    System.exit(0);
  }//GEN-LAST:event_okayActionPerformed

  /**
   * @param args the command line arguments
   */
  public static void main(String[] args) {
    /* Create and display the form */
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        new SystemInfo().setVisible(true);
      }
    });
  }

  private static String wmic(String type, String subtype) {
    try {
      //wmic csproduct get vendor,name,identifyingnumber
      String[] cmd = new String[] {"wmic", type, "get", subtype};
      ShellProcess sp = new ShellProcess();
      String output = sp.run(cmd, true);
      String[] lns = output.split("\r\n");
      if (lns.length < 2) return "null";
      return lns[1];
    } catch (Exception e) {
      JFLog.log(e);
    }
    return null;
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTextField computername;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JLabel jLabel3;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JButton okay;
  private javax.swing.JTextField osversion;
  private javax.swing.JTextField system_name;
  private javax.swing.JTextField system_serial;
  private javax.swing.JTextField username;
  // End of variables declaration//GEN-END:variables
}
