/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.FileOutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ansi.client.Buffer;
import javaforce.ansi.client.Script;
import javaforce.ansi.client.Settings;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.jni.lnx.LnxPty;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;

public class BufferViewer
extends JComponent
implements KeyListener,
MouseListener,
MouseMotionListener {
    public Buffer buffer;
    public Settings settings;
    public Script script = null;
    private static int fx;
    private static int fy;
    private static int descent;
    private volatile boolean ready = false;
    private Object lock;
    private Render render;
    private final int RenderPriority = 9;
    private Timer timer;
    private boolean cursorShown = false;
    private int selectStart = -1;
    private int selectEnd = -1;
    private FileOutputStream fos;
    private boolean blinker = false;
    private boolean blinkerShown = false;
    private boolean connected = false;
    private boolean connecting = false;
    private boolean failed = false;
    private boolean closed = false;
    private boolean init = false;
    private JScrollPane pane;
    private LnxPty pty;
    private long profile_last = 0L;
    private JFImage img = new JFImage();

    public BufferViewer(Buffer buffer, Settings settings) {
        this.buffer = buffer;
        this.changeFont();
    }

    private void init() {
        JFLog.log("BufferViewer.init start");
        this.buffer.init();
        try {
            this.lock = new Object();
            this.setFocusable(true);
            this.setRequestFocusEnabled(true);
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BufferViewer.this.timer();
                }
            }, 500L, 500L);
            this.pane = (JScrollPane)this.getClientProperty("pane");
            this.pane.getVerticalScrollBar().setUnitIncrement(8);
            if (this.settings.autoSize) {
                Dimension d = this.pane.getViewport().getExtentSize();
                if (d.width < fx) {
                    d.width = fx;
                }
                if (d.height < fy) {
                    d.height = fy;
                }
                this.settings.sx = d.width / fx;
                this.settings.sy = d.height / fy;
            }
            this.init = true;
            if (this.settings.autoSize) {
                this.changeSize();
            } else {
                this.reSize();
            }
            this.setVisible(true);
            this.requestFocus();
            this.ready = true;
            this.render = new Render();
            this.render.setPriority(9);
            this.render.start();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        JFLog.log("Buffer.init done");
    }

    private void profile(boolean show, String msg) {
        long current = System.nanoTime();
        if (show) {
            System.out.println(msg + "Diff=" + (current - this.profile_last));
        }
        this.profile_last = current;
    }

    public byte[] char2byte(char[] buf, int buflen) {
        byte[] tmp = new byte[buflen];
        for (int a = 0; a < buflen; ++a) {
            tmp[a] = (byte)buf[a];
        }
        return tmp;
    }

    public char[] byte2char(byte[] buf, int buflen) {
        char[] tmp = new char[buflen];
        int a = 0;
        while (a < buflen) {
            tmp[a] = (char)buf[a];
            int n = a++;
            tmp[n] = (char)(tmp[n] & 0xFF);
        }
        return tmp;
    }

    public void changeSize() {
        this.buffer.changeSize(this.pane.getViewport().getExtentSize());
    }

    public void changeFont() {
        int[] metrics = JFAWT.getFontMetrics(this.settings.fnt);
        fx = metrics[0] + this.settings.fontWidth;
        fy = metrics[1] + metrics[2] + this.settings.fontHeight;
        descent = metrics[2] + this.settings.fontDescent;
    }

    private void setPreferredSize() {
        this.setPreferredSize(new Dimension(fx * this.buffer.sx, fy * (this.buffer.sy + this.buffer.scrollBack)));
    }

    public void reSize() {
        this.signalRepaint(true, true);
    }

    public void repaint(boolean showCursor) {
        if (showCursor) {
            this.scrollRectToVisible(new Rectangle(0, fy * this.buffer.scrollBack, fx * this.buffer.sx, fy * (this.buffer.scrollBack + this.buffer.sy)));
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        if (!this.ready) {
            if (!this.init) {
                this.init();
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.paintComponentLocked(g);
        }
    }

    public void paintComponentLocked(Graphics gc) {
        Rectangle r = gc.getClipBounds();
        if (this.img.getWidth() != r.width || this.img.getHeight() != r.height) {
            this.img.setImageSize(r.width, r.height);
        }
        this.img.fill(0, 0, r.width, r.height, this.settings.backColor.getRGB());
        Graphics g = this.img.getGraphics();
        g.setFont(this.settings.fnt);
        int startx = r.x / fx;
        int offx = r.x % fx;
        int endx = (r.x + r.width) / fx + 1;
        if (endx > this.buffer.sx) {
            endx = this.buffer.sx;
        }
        int starty = r.y / fy;
        int offy = r.y % fy;
        int endy = (r.y + r.height) / fy + 1;
        if (endy > this.buffer.sy + this.buffer.scrollBack) {
            endy = this.buffer.sy + this.buffer.scrollBack;
        }
        for (int y = starty; y < endy; ++y) {
            for (int x = startx; x < endx; ++x) {
                int p = y * this.buffer.sx + x;
                if (x == this.buffer.cx && y == this.buffer.cy + this.buffer.scrollBack && this.cursorShown) {
                    g.setColor(this.settings.cursorColor);
                } else if (p >= this.selectStart && p <= this.selectEnd || p >= this.selectEnd && p <= this.selectStart && this.selectEnd > 0) {
                    g.setColor(this.settings.selectColor);
                } else {
                    g.setColor(this.buffer.chars[p].bc);
                }
                g.fillRect((x - startx) * fx - offx, (y - starty) * fy - offy, fx, fy);
                if (this.blinkerShown && this.buffer.chars[p].blink) {
                    g.setColor(this.buffer.chars[p].bc);
                } else {
                    g.setColor(this.buffer.chars[p].fc);
                }
                char ch = this.buffer.chars[p].ch;
                if (ch == '\u0000') continue;
                g.drawString("" + ch, (x - startx) * fx - offx, (y + 1 - starty) * fy - descent - offy);
            }
            if (y != this.buffer.scrollBack || this.buffer.scrollBack <= 0) continue;
            g.setColor(Color.RED);
            g.drawLine(0 - offx, (y - starty) * fy - 2 - offy, (endx - startx) * fx - 1 - offx, (y - starty) * fy - 2 - offy);
        }
        gc.drawImage(this.img.getImage(), r.x, r.y, null);
    }

    public void setAutoWrap(boolean state) {
        this.settings.autowrap = state;
    }

    public void nextTab() {
        System.out.println("nextTab");
    }

    public void prevTab() {
        System.out.println("prevTab");
    }

    public void setTab(int idx) {
        System.out.println("setTab" + idx);
    }

    @Override
    public void setName(String str) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalRepaint(boolean findScreen, boolean revalidate) {
        if (this.render == null) {
            return;
        }
        if (revalidate) {
            this.setPreferredSize();
            this.revalidate();
        }
        Render render = this.render;
        synchronized (render) {
            this.render.findCursor = findScreen;
            this.render.draw = true;
            this.render.notify();
        }
    }

    public void logFile() {
        if (this.fos == null) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showSaveDialog(this) == 0) {
                this.fos = JF.filecreate(chooser.getSelectedFile().getAbsolutePath());
                if (this.fos != null) {
                    this.setName(this.settings.name + "*");
                }
            }
        } else {
            this.fos = null;
            this.setName(this.settings.name);
        }
    }

    @Override
    public String toString() {
        return "BufferViewer";
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int keyMods = e.getModifiersEx() & JFAWT.KEY_MASKS;
        if (keyMods == 128) {
            switch (keyCode) {
                case 65: {
                    this.selectStart = 0;
                    this.selectEnd = this.buffer.sx * (this.buffer.sy + this.buffer.scrollBack) - 1;
                    break;
                }
                case 87: {
                    this.buffer.close();
                    break;
                }
                case 67: 
                case 155: {
                    this.buffer.copy();
                    break;
                }
                case 86: {
                    this.buffer.paste();
                    break;
                }
                case 9: {
                    this.nextTab();
                    break;
                }
                case 35: 
                case 36: {
                    e.consume();
                }
            }
        }
        if (keyMods == 64) {
            switch (keyCode) {
                case 155: {
                    this.buffer.paste();
                }
            }
        }
        if (keyMods == 0) {
            switch (keyCode) {
                case 9: {
                    this.prevTab();
                }
            }
        }
        if (keyMods == 512) {
            switch (keyCode) {
                case 36: {
                    this.buffer.clrscr();
                    break;
                }
                case 49: {
                    this.setTab(0);
                    break;
                }
                case 50: {
                    this.setTab(1);
                    break;
                }
                case 51: {
                    this.setTab(2);
                    break;
                }
                case 52: {
                    this.setTab(3);
                    break;
                }
                case 53: {
                    this.setTab(4);
                    break;
                }
                case 54: {
                    this.setTab(5);
                    break;
                }
                case 55: {
                    this.setTab(6);
                    break;
                }
                case 56: {
                    this.setTab(7);
                    break;
                }
                case 57: {
                    this.setTab(8);
                    break;
                }
                case 48: {
                    this.setTab(9);
                }
            }
        }
        if (keyMods == 0) {
            switch (keyCode) {
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 121: {
                    e.consume();
                }
            }
        }
        if (!this.connected) {
            return;
        }
        this.buffer.ansi.keyPressed(keyCode, keyMods, this.buffer);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!this.connected) {
            if (this.failed) {
                this.failed = false;
                this.buffer.signalReconnect();
            }
            return;
        }
        char key = e.getKeyChar();
        int mods = e.getModifiersEx() & JFAWT.KEY_MASKS;
        if (mods == 128) {
            if (key == '\n' || key == '\r') {
                this.buffer.output('\r');
                this.buffer.output('\n');
            }
            return;
        }
        if (mods == 512) {
            return;
        }
        if (mods == 640) {
            return;
        }
        if (key == '\n') {
            key = '\r';
        }
        if (key == '\u007f') {
            return;
        }
        this.buffer.output(key);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 2) {
            this.buffer.paste();
        }
        if (e.getButton() == 1) {
            this.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.selectStart = y / fy * this.buffer.sx + x / fx;
        this.selectEnd = -1;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.selectStart == -1) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.selectEnd = y / fy * this.buffer.sx + x / fx;
        if (this.selectEnd == this.selectStart) {
            this.selectEnd = -1;
            this.selectStart = -1;
        }
        this.signalRepaint(false, false);
        if (this.selectStart != -1) {
            this.buffer.copy();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectStart == -1) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (x < 0) {
            x = 0;
        }
        if (x > this.buffer.sx * fx) {
            x = this.buffer.sx * fx - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y > (this.buffer.sy + this.buffer.scrollBack) * fy) {
            y = (this.buffer.sy + this.buffer.scrollBack) * fy - 1;
        }
        this.selectEnd = y / fy * this.buffer.sx + x / fx;
        this.signalRepaint(false, false);
        this.scrollRectToVisible(new Rectangle(e.getX(), e.getY(), 1, 1));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void timer() {
        if (this.cursorShown) {
            this.blinkerShown = !this.blinkerShown;
            this.cursorShown = false;
        } else {
            this.cursorShown = true;
        }
        if (this.script != null && this.script.process(this.buffer)) {
            this.script = null;
        }
        this.signalRepaint(false, false);
    }

    private class Render
    extends Thread {
        public volatile boolean findCursor = true;
        public volatile boolean draw = false;

        private Render() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!BufferViewer.this.closed) {
                this.draw = false;
                BufferViewer.this.repaint(this.findCursor);
                Render render = this;
                synchronized (render) {
                    if (this.draw) {
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            JFLog.log("Render thread done");
        }
    }
}

