/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.ui.Component;
import javaforce.ui.Container;
import javaforce.ui.Dimension;
import javaforce.ui.FlexBox;
import javaforce.ui.LayoutMetrics;

public class Column
extends Container {
    @Override
    public Dimension getMinSize() {
        int width = 0;
        int height = 0;
        for (Component child : this.children) {
            Dimension size = child.getMinSize();
            if (size.width > width) {
                width = size.width;
            }
            height += size.height;
        }
        if (this.getBorderStyle() != 0) {
            width += 2;
            height += 2;
        }
        this.minSize.width = width;
        this.minSize.height = height;
        return this.minSize;
    }

    @Override
    public void layout(LayoutMetrics metrics) {
        this.setPosition(metrics.pos);
        this.setSize(metrics.size);
        if (this.getBorderStyle() != 0) {
            ++metrics.pos.x;
            ++metrics.pos.y;
            metrics.size.width -= 2;
            metrics.size.height -= 2;
        }
        int min_y = 0;
        int flex_count = 0;
        int flex_size = 0;
        for (Component child : this.children) {
            if (child instanceof FlexBox) {
                ++flex_count;
                continue;
            }
            if (child instanceof Container) {
                min_y += child.getMinHeight();
                continue;
            }
            min_y += child.getMinHeight();
        }
        if (flex_count > 0) {
            flex_size = (metrics.size.height - min_y) / flex_count;
        }
        for (Component child : this.children) {
            int org_y;
            int org_x;
            int org_height;
            int org_width;
            child.setPosition(metrics.pos);
            if (child instanceof FlexBox) {
                metrics.pos.y += flex_size;
                continue;
            }
            if (child instanceof Container) {
                org_width = metrics.size.width;
                org_height = metrics.size.height;
                org_x = metrics.pos.x;
                org_y = metrics.pos.y;
                metrics.size.height = child.getMinHeight();
                child.layout(metrics);
                metrics.size.width = org_width;
                metrics.size.height = org_height;
                metrics.pos.x = org_x;
                metrics.pos.y = org_y;
                metrics.pos.y += child.getMinHeight();
                continue;
            }
            org_width = metrics.size.width;
            org_height = metrics.size.height;
            org_x = metrics.pos.x;
            org_y = metrics.pos.y;
            metrics.size.width = child.getMinWidth();
            metrics.size.height = child.getMinHeight();
            child.layout(metrics);
            metrics.size.width = org_width;
            metrics.size.height = org_height;
            metrics.pos.x = org_x;
            metrics.pos.y = org_y;
            metrics.pos.y += child.getMinHeight();
        }
    }

    public String toString() {
        return "Column";
    }
}

