/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ShellProcess;
import javaforce.ShellProcessListener;
import javaforce.utils.BuildTools;

public class ExecGraalAgent
implements ShellProcessListener {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("ExecGraalAgent : Runs project using Graal agentlib");
            System.out.println("  Usage : ExecGraalAgent buildfile");
            System.exit(1);
        }
        try {
            new ExecGraalAgent().run(args[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile) throws Exception {
        String[] args;
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        String app = this.tools.getProperty("app");
        Object cfg = this.tools.getProperty("cfg");
        if (((String)cfg).length() == 0) {
            cfg = app + ".cfg";
        }
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream((String)cfg);
        props.load(fis);
        fis.close();
        String classpath = props.getProperty("CLASSPATH");
        String mainclass = props.getProperty("MAINCLASS");
        String service2 = props.getProperty("SERVICE");
        String graalargs = props.getProperty("GRAALARGS");
        if (graalargs == null) {
            graalargs = "";
        }
        String folder = "META-INF/native-image";
        new File(folder).mkdirs();
        if (!JF.getCurrentPath().endsWith("javaforce")) {
            File[] files;
            for (File file : files = new File(folder).listFiles()) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        ShellProcess sp = new ShellProcess();
        sp.addListener(this);
        ArrayList<Object> cmd = new ArrayList<Object>();
        String home = this.tools.getProperty("home");
        Object exec = "jfexec";
        if (service2 != null) {
            exec = (String)exec + "s";
        }
        exec = (String)exec + "d";
        if (JF.isWindows()) {
            exec = (String)exec + ".exe";
        }
        cmd.add(exec);
        cmd.add("-agentlib:native-image-agent=config-output-dir=META-INF/native-image");
        cmd.add("-cp");
        if (JF.isWindows()) {
            cmd.add(classpath);
        } else {
            cmd.add(classpath.replaceAll("[;]", ":"));
        }
        cmd.add(mainclass);
        for (String arg : args = graalargs.split(" ")) {
            cmd.add(arg);
        }
        String[] cmdArray = cmd.toArray(JF.StringArrayType);
        System.out.println("cmd=" + JF.join(" ", cmdArray));
        sp.run(cmdArray, true);
        this.generate_jni_config(mainclass);
    }

    @Override
    public void shellProcessOutput(String str) {
        System.out.print(str);
    }

    private void generate_jni_config(String mainclass) {
        String filename = "META-INF/native-image/jni-config.json";
        if (new File(filename).exists()) {
            return;
        }
        try {
            StringBuilder jni = new StringBuilder();
            jni.append("[");
            jni.append("{ \"name\" : \"" + mainclass + "\", \"methods\": [ {\"name\" : \"main\"} ]}");
            jni.append("]");
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(jni.toString().getBytes());
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

