/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.MD5;

public class POP3 {
    private Socket s;
    private InputStream is;
    private OutputStream os;
    private BufferedReader br;
    private String host;
    public static boolean debug = false;
    public static boolean debug_log = false;
    public static int log;
    public String response;
    public static final int PORT = 25;
    public static final int TLSPORT = 587;
    public static final int SSLPORT = 465;
    public static final String AUTH_LOGIN = "LOGIN";
    public static final String AUTH_APOP = "APOP";
    private static final int bufsiz = 1460;

    public boolean connect(String host, int port) throws Exception {
        this.s = new Socket(host, port);
        this.is = this.s.getInputStream();
        this.br = new BufferedReader(new InputStreamReader(this.is));
        this.os = this.s.getOutputStream();
        this.host = host;
        this.getResponse();
        if (this.response.startsWith("+OK")) {
            return true;
        }
        this.disconnect();
        return false;
    }

    public boolean connectSSL(String host, int port) throws Exception {
        this.s = JF.connectSSL(host, port, KeyMgmt.getDefaultClient());
        this.is = this.s.getInputStream();
        this.br = new BufferedReader(new InputStreamReader(this.is));
        this.os = this.s.getOutputStream();
        this.host = host;
        this.getResponse();
        if (this.response.startsWith("+OK")) {
            return true;
        }
        this.disconnect();
        return false;
    }

    public void disconnect() throws Exception {
        if (this.s != null) {
            this.s.close();
        }
        this.s = null;
        this.is = null;
        this.os = null;
        this.br = null;
    }

    public static void setLogging(boolean state) {
        debug_log = state;
    }

    public static void setLog(int id) {
        log = id;
    }

    public boolean login() throws Exception {
        this.cmd("HELO " + this.host);
        this.getResponse();
        return this.response.startsWith("+OK");
    }

    public boolean auth(String user, String pass, String type) throws Exception {
        switch (type) {
            case "LOGIN": {
                return this.user_pass(user, pass);
            }
            case "APOP": {
                return this.apop(user, pass);
            }
        }
        JFLog.log(log, "POP3:Unknown auth type:" + type);
        return false;
    }

    private boolean user_pass(String user, String pass) throws Exception {
        this.cmd("USER " + user);
        this.getResponse();
        if (!this.response.startsWith("+OK")) {
            return false;
        }
        this.cmd("PASS " + pass);
        this.getResponse();
        return this.response.startsWith("+OK");
    }

    private boolean apop(String user, String pass) throws Exception {
        MD5 md5 = new MD5();
        md5.add(pass);
        String pass_md5 = md5.toString();
        this.cmd("APOP " + user + " " + pass_md5);
        this.getResponse();
        return this.response.startsWith("+OK");
    }

    public boolean auth(String user, String pass) throws Exception {
        return this.auth(user, pass, AUTH_LOGIN);
    }

    public void logout() throws Exception {
        this.cmd("quit");
        this.getResponse();
    }

    public void cmd(String cmd) throws Exception {
        if (this.s == null || this.s.isClosed()) {
            throw new Exception("not connected");
        }
        if (debug_log || debug) {
            if (((String)cmd).startsWith("pass ")) {
                JFLog.log(log, "pass ****");
            } else {
                JFLog.log(log, (String)cmd);
            }
        }
        cmd = (String)cmd + "\r\n";
        this.os.write(((String)cmd).getBytes());
    }

    public void starttls() throws Exception {
        this.cmd("STARTTLS");
        this.getResponse();
        if (!this.response.startsWith("+OK")) {
            throw new Exception("STARTTLS failed!");
        }
        this.s = JF.connectSSL(this.s, KeyMgmt.getDefaultClient());
        this.is = this.s.getInputStream();
        this.os = this.s.getOutputStream();
    }

    public Message[] list() throws Exception {
        String ln;
        this.cmd("LIST");
        this.getResponse();
        if (!this.response.startsWith("+OK")) {
            throw new Exception("LIST failed!");
        }
        ArrayList<Message> list = new ArrayList<Message>();
        while (!(ln = this.br.readLine()).equals(".")) {
            String[] p = ln.split(" ", 2);
            int idx = Integer.valueOf(p[0]);
            int size = Integer.valueOf(p[1]);
            Message msg = new Message();
            msg.idx = idx;
            msg.size = size;
            list.add(msg);
        }
        return list.toArray(new Message[0]);
    }

    public byte[] get(int idx) throws Exception {
        this.cmd("RETR " + idx);
        this.getResponse();
        if (!this.response.startsWith("+OK")) {
            throw new Exception("RETR failed!");
        }
        String[] p = this.response.split(" ", 3);
        int length = Integer.valueOf(p[1]);
        StringBuilder sb = new StringBuilder();
        for (int total = 0; total < length; total += 2) {
            String ln = this.br.readLine();
            sb.append(ln);
            total += ln.length();
            sb.append("\r\n");
        }
        this.getResponse();
        return sb.toString().getBytes();
    }

    public void get(int idx, OutputStream os) throws Exception {
        this.cmd("RETR " + idx);
        this.getResponse();
        if (!this.response.startsWith("+OK")) {
            throw new Exception("RETR failed!");
        }
        String[] p = this.response.split(" ", 3);
        int length = Integer.valueOf(p[1]);
        for (int total = 0; total < length; total += 2) {
            String ln = this.br.readLine();
            os.write(ln.getBytes());
            total += ln.length();
            os.write("\r\n".getBytes());
        }
        this.getResponse();
    }

    public boolean delete(int idx) throws Exception {
        this.cmd("DELE " + idx);
        this.getResponse();
        if (!this.response.startsWith("+OK")) {
            throw new Exception("DELE failed!");
        }
        return true;
    }

    private void getResponse() throws Exception {
        if (debug) {
            JFLog.log(log, "POP3:reading response...");
        }
        this.response = this.br.readLine();
        if (debug) {
            JFLog.log(log, "POP3:response=" + this.response);
        }
    }

    public static class Message {
        public int idx;
        public long size;
    }
}

