/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt.priv;

import java.io.InputStream;
import java.io.OutputStream;
import javaforce.JFLog;
import javaforce.ui.Color;
import javaforce.ui.Dimension;

public class pgm {
    private static final byte[] header = new byte[]{80, 53, 10};

    public static int[] load(InputStream is, Dimension size) {
        int pos = 0;
        try {
            byte[] data = is.readAllBytes();
            for (int a = 0; a < header.length; ++a) {
                if (data[pos] != header[pos]) {
                    throw new Exception("pgm:invalid header");
                }
                ++pos;
            }
            int strlen = 0;
            int start = pos;
            while (data[pos] != 10) {
                ++pos;
                ++strlen;
            }
            ++pos;
            String[] w_h_strs = new String(data, start, strlen).split("[ ]");
            if (w_h_strs.length != 2) {
                throw new Exception("pgm:invalid width height");
            }
            int width = Integer.valueOf(w_h_strs[0]);
            int height = Integer.valueOf(w_h_strs[1]);
            strlen = 0;
            start = pos;
            while (data[pos] != 10) {
                ++pos;
                ++strlen;
            }
            ++pos;
            String max_gray_str = new String(data, start, strlen);
            int max_gray = Integer.valueOf(max_gray_str);
            if (max_gray != 255) {
                throw new Exception("pgm:invalid gray scale");
            }
            int no_px = width * height;
            int[] px = new int[no_px];
            int off = 0;
            for (int a = 0; a < no_px; ++a) {
                int val = data[pos++];
                val = val + (val << 8) + (val << 16) + Color.OPAQUE;
                px[off++] = val;
            }
            size.width = width;
            size.height = height;
            return px;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static boolean save(OutputStream os, int[] px, Dimension size) {
        int no_px = size.width * size.height;
        byte[] px8 = new byte[no_px];
        try {
            os.write("P5\n".getBytes());
            os.write(String.format("", new Object[0]).getBytes());
            os.write("255\n".getBytes());
            for (int a = 0; a < no_px; ++a) {
                px8[a] = (byte)(px[a] & 0xFF);
            }
            os.write(px8);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }
}

