/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt.priv;

import java.io.InputStream;
import java.io.OutputStream;
import javaforce.JFLog;
import javaforce.ui.Color;
import javaforce.ui.Dimension;

public class pnm {
    public static final int TYPE_BIT_ASCII = 1;
    public static final int TYPE_GRAY_ASCII = 2;
    public static final int TYPE_COLOR_ASCII = 3;
    public static final int TYPE_BIT_BIN = 4;
    public static final int TYPE_GRAY_BIN = 5;
    public static final int TYPE_COLOR_BIN = 6;

    public static int[] load(InputStream is, Dimension size) {
        int pos = 0;
        int type = -1;
        try {
            byte[] data = is.readAllBytes();
            if (data == null || data.length < 9) {
                throw new Exception("pgm:header too small");
            }
            if (data[0] != 80 || data[2] != 10) {
                throw new Exception("pgm:invalid header");
            }
            switch (data[1]) {
                case 49: {
                    type = 1;
                    break;
                }
                case 50: {
                    type = 2;
                    break;
                }
                case 51: {
                    type = 3;
                    break;
                }
                case 52: {
                    type = 4;
                    break;
                }
                case 53: {
                    type = 5;
                    break;
                }
                case 54: {
                    type = 6;
                    break;
                }
                default: {
                    throw new Exception("pgm:unknown image type");
                }
            }
            if (type == 1 || type == 4) {
                throw new Exception("pmg:bit format not supported");
            }
            if (type < 5) {
                throw new Exception("pmg:ascii format not supported");
            }
            pos += 3;
            while (data[pos] == 35) {
                while (data[pos] != 10) {
                    ++pos;
                }
                ++pos;
            }
            int start = pos;
            int strlen = 0;
            while (data[pos] != 32) {
                ++pos;
                ++strlen;
            }
            int width = Integer.valueOf(new String(data, start, strlen));
            start = ++pos;
            strlen = 0;
            while (data[pos] != 10) {
                ++pos;
                ++strlen;
            }
            int height = Integer.valueOf(new String(data, start, strlen));
            start = ++pos;
            strlen = 0;
            while (data[pos] != 10) {
                ++pos;
                ++strlen;
            }
            ++pos;
            int max_value = Integer.valueOf(new String(data, start, strlen));
            if (max_value != 255) {
                throw new Exception("pgm:max value not supported");
            }
            int pxs = width * height;
            int[] px = new int[pxs];
            int off = 0;
            switch (type) {
                case 5: {
                    for (int a = 0; a < pxs; ++a) {
                        int val = data[pos++];
                        val = val + (val << 8) + (val << 16) + Color.OPAQUE;
                        px[off++] = val;
                    }
                    break;
                }
                case 6: {
                    for (int a = 0; a < pxs; ++a) {
                        byte r = data[pos++];
                        byte g = data[pos++];
                        byte b = data[pos++];
                        int val = b + (g << 8) + (r << 16) + Color.OPAQUE;
                        px[off++] = val;
                    }
                    break;
                }
            }
            size.width = width;
            size.height = height;
            return px;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static boolean save(OutputStream os, int[] px, Dimension size, int type) {
        int pxs;
        int bytes = pxs = size.width * size.height;
        if (type == 6) {
            bytes *= 3;
        }
        byte[] px8 = new byte[bytes];
        try {
            if (type == 1 || type == 4) {
                throw new Exception("pgm:bit format not supported");
            }
            if (type < 5) {
                throw new Exception("pgm:ascii format not supported");
            }
            os.write(("P" + type + "\n").getBytes());
            os.write(String.format("%d %d\n", size.width, size.height).getBytes());
            os.write("255\n".getBytes());
            switch (type) {
                case 5: {
                    for (int a = 0; a < pxs; ++a) {
                        px8[a] = (byte)(px[a] & Color.MASK_BLUE);
                    }
                    break;
                }
                case 6: {
                    int off = 0;
                    for (int a = 0; a < pxs; ++a) {
                        int val = px[a];
                        px8[off++] = (byte)((val & Color.MASK_RED) >> Color.SHIFT_RED);
                        px8[off++] = (byte)((val & Color.MASK_GREEN) >> Color.SHIFT_GREEN);
                        px8[off++] = (byte)((val & Color.MASK_BLUE) >> Color.SHIFT_BLUE);
                    }
                    break;
                }
            }
            os.write(px8);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }
}

