/*
 * Decompiled with CFR 0.152.
 */
package javaforce.codec.speex;

import javaforce.codec.speex.Bits;
import javaforce.codec.speex.VQ;

public class Stereo {
    public static final int SPEEX_INBAND_STEREO = 9;
    public static final float[] e_ratio_quant = new float[]{0.25f, 0.315f, 0.397f, 0.5f};
    private float balance = 1.0f;
    private float e_ratio = 0.5f;
    private float smooth_left = 1.0f;
    private float smooth_right = 1.0f;

    public static void encode(Bits bits, float[] data, int frameSize) {
        float e_left = 0.0f;
        float e_right = 0.0f;
        float e_tot = 0.0f;
        for (int i = 0; i < frameSize; ++i) {
            e_left += data[2 * i] * data[2 * i];
            e_right += data[2 * i + 1] * data[2 * i + 1];
            data[i] = 0.5f * (data[2 * i] + data[2 * i + 1]);
            e_tot += data[i] * data[i];
        }
        float balance = (e_left + 1.0f) / (e_right + 1.0f);
        float e_ratio = e_tot / (1.0f + e_left + e_right);
        bits.pack(14, 5);
        bits.pack(9, 4);
        balance = (float)(4.0 * Math.log(balance));
        if (balance > 0.0f) {
            bits.pack(0, 1);
        } else {
            bits.pack(1, 1);
        }
        balance = (float)Math.floor(0.5f + Math.abs(balance));
        if (balance > 30.0f) {
            balance = 31.0f;
        }
        bits.pack((int)balance, 5);
        int tmp = VQ.index(e_ratio, e_ratio_quant, 4);
        bits.pack(tmp, 2);
    }

    public void decode(float[] data, int frameSize) {
        int i;
        float e_tot = 0.0f;
        for (i = frameSize - 1; i >= 0; --i) {
            e_tot += data[i] * data[i];
        }
        float e_sum = e_tot / this.e_ratio;
        float e_left = e_sum * this.balance / (1.0f + this.balance);
        float e_right = e_sum - e_left;
        e_left = (float)Math.sqrt(e_left / (e_tot + 0.01f));
        e_right = (float)Math.sqrt(e_right / (e_tot + 0.01f));
        for (i = frameSize - 1; i >= 0; --i) {
            float ftmp = data[i];
            this.smooth_left = 0.98f * this.smooth_left + 0.02f * e_left;
            this.smooth_right = 0.98f * this.smooth_right + 0.02f * e_right;
            data[2 * i] = this.smooth_left * ftmp;
            data[2 * i + 1] = this.smooth_right * ftmp;
        }
    }

    public void init(Bits bits) {
        float sign = 1.0f;
        if (bits.unpack(1) != 0) {
            sign = -1.0f;
        }
        int tmp = bits.unpack(5);
        this.balance = (float)Math.exp((double)sign * 0.25 * (double)tmp);
        tmp = bits.unpack(2);
        this.e_ratio = e_ratio_quant[tmp];
    }
}

