/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.cl.CL;
import javaforce.cl.Compute;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class CPUHogger
extends JFrame {
    public static boolean debug = true;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField matrix_size;
    private JRadioButton select_cpu;
    private JRadioButton select_gpu;
    private ButtonGroup selection;
    private JButton start;
    private JLabel status;
    private JSpinner threads;
    private volatile boolean running = false;
    private static Object cl_lock = new Object();
    private static boolean cl_init;
    private static boolean cl_fail;

    public CPUHogger() {
        this.initComponents();
        JFAWT.centerWindow(this);
        this.selection.add(this.select_cpu);
        this.selection.add(this.select_gpu);
    }

    private void initComponents() {
        this.selection = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.threads = new JSpinner();
        this.start = new JButton();
        this.status = new JLabel();
        this.select_cpu = new JRadioButton();
        this.select_gpu = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.matrix_size = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setTitle("CPU Hogger");
        this.jLabel1.setText("# of Threads");
        this.threads.setModel(new SpinnerNumberModel(1, 1, 8, 1));
        this.start.setText("Start");
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPUHogger.this.startActionPerformed(evt);
            }
        });
        this.status.setText("Status : Idle");
        this.select_cpu.setSelected(true);
        this.select_cpu.setText("CPU");
        this.select_gpu.setText("GPU");
        this.jLabel2.setText("Matrix Size");
        this.matrix_size.setText("256");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.start, -1, -1, Short.MAX_VALUE).addComponent(this.status, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.threads, -1, 172, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.select_cpu).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.select_gpu).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.matrix_size))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.threads, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.select_cpu).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.select_gpu).addComponent(this.jLabel2).addComponent(this.matrix_size, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.start).addGap(18, 18, 18).addComponent(this.status).addContainerGap()));
        this.pack();
    }

    private void startActionPerformed(ActionEvent evt) {
        this.startTest();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CPUHogger().setVisible(true);
            }
        });
    }

    private void startTest() {
        if (this.running) {
            this.running = false;
            this.start.setText("Start");
            this.status.setText("Status : Idle");
        } else {
            this.running = true;
            if (this.select_cpu.isSelected()) {
                this.startCPUThreads();
            }
            if (this.select_gpu.isSelected()) {
                this.startGPUThreads();
            }
            this.start.setText("stop");
            int cnt = (Integer)this.threads.getValue();
            this.status.setText("Status : " + cnt + " threads running");
        }
    }

    private void startCPUThreads() {
        int cnt = (Integer)this.threads.getValue();
        for (int a = 0; a < cnt; ++a) {
            CPU hogger = new CPU(a);
            hogger.start();
        }
    }

    private void startGPUThreads() {
        int cnt = (Integer)this.threads.getValue();
        int mat_size = Integer.valueOf(this.matrix_size.getText());
        for (int a = 0; a < cnt; ++a) {
            GPU hogger = new GPU(a, mat_size);
            hogger.start();
        }
    }

    private class CPU
    extends Thread {
        public int id;
        public int c = 0;

        public CPU(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            Random r = new Random();
            while (CPUHogger.this.running) {
                float f = r.nextFloat();
                double d = Math.sin(f);
                int z = this.convert(d);
                this.c += z;
            }
        }

        private int convert(double d) {
            return (int)(d + 1.0);
        }
    }

    private class GPU
    extends Thread {
        public int id;
        private Compute cmp;
        private static int SIZE;
        private static int SIZE_SIZE;
        private float[] in1;
        private float[] in2;
        private float[] out;
        private Random r = new Random();

        public GPU(int id, int matrix_size) {
            this.id = id;
            SIZE = matrix_size;
            SIZE_SIZE = SIZE * SIZE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = cl_lock;
            synchronized (object) {
                if (cl_fail) {
                    return;
                }
                if (!cl_init) {
                    if (!CL.init()) {
                        cl_fail = true;
                        if (CPUHogger.this.running) {
                            CPUHogger.this.startTest();
                        }
                        JFAWT.showError("Error", "OpenCL init failed");
                        return;
                    }
                    cl_init = true;
                }
            }
            this.load();
            while (CPUHogger.this.running) {
                this.test();
            }
            this.unload();
        }

        public void load() {
            try {
                this.cmp = new Compute();
                this.cmp.init(4);
                this.in1 = new float[SIZE_SIZE];
                this.in2 = new float[SIZE_SIZE];
                this.out = new float[SIZE_SIZE];
                for (int i = 0; i < SIZE_SIZE; ++i) {
                    this.in1[i] = this.r.nextFloat();
                    this.in2[i] = this.r.nextFloat();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void unload() {
            if (this.cmp != null) {
                this.cmp.uninit();
                this.cmp = null;
            }
        }

        public void test() {
            try {
                this.cmp.matrix_mult(SIZE, SIZE, SIZE, this.in1, this.in2, this.out);
                if (debug) {
                    System.out.print(Integer.toString(this.id));
                }
            }
            catch (Throwable t) {
                JFLog.log(t);
            }
        }
    }
}

