/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

public class DTMF {
    private static final double vol = 9000.0;
    private static final double pi2 = Math.PI * 2;
    private int offset;
    private double rowPos;
    private double colPos;
    private double[] row = new double[]{697.0, 770.0, 852.0, 941.0};
    private double[] col = new double[]{1209.0, 1336.0, 1477.0};
    private int iRate;
    private double dRate;
    private short[] buf;
    private char last;

    public DTMF(int rate) {
        this.setSampleRate(rate);
    }

    public void reset() {
        this.offset = 0;
        this.rowPos = 0.0;
        this.colPos = 0.0;
    }

    public void setSampleRate(int rate) {
        this.iRate = rate;
        this.dRate = rate;
        this.buf = new short[rate / 50];
    }

    public short[] getSamples(char dtmf) {
        int colIdx;
        int rowIdx;
        if (dtmf != this.last) {
            this.last = dtmf;
            this.reset();
        }
        switch (dtmf) {
            case '1': {
                rowIdx = 0;
                colIdx = 0;
                break;
            }
            case '2': {
                rowIdx = 0;
                colIdx = 1;
                break;
            }
            case '3': {
                rowIdx = 0;
                colIdx = 2;
                break;
            }
            case '4': {
                rowIdx = 1;
                colIdx = 0;
                break;
            }
            case '5': {
                rowIdx = 1;
                colIdx = 1;
                break;
            }
            case '6': {
                rowIdx = 1;
                colIdx = 2;
                break;
            }
            case '7': {
                rowIdx = 2;
                colIdx = 0;
                break;
            }
            case '8': {
                rowIdx = 2;
                colIdx = 1;
                break;
            }
            case '9': {
                rowIdx = 2;
                colIdx = 2;
                break;
            }
            case '*': {
                rowIdx = 3;
                colIdx = 0;
                break;
            }
            case '0': {
                rowIdx = 3;
                colIdx = 1;
                break;
            }
            case '#': {
                rowIdx = 3;
                colIdx = 2;
                break;
            }
            default: {
                return null;
            }
        }
        double rowTheta = Math.PI * 2 * this.row[rowIdx] / this.dRate;
        for (int a = 0; a < this.buf.length; ++a) {
            this.buf[a] = (short)(Math.sin(this.rowPos) * 9000.0);
            this.rowPos += rowTheta;
        }
        double colTheta = Math.PI * 2 * this.col[colIdx] / this.dRate;
        int a = 0;
        while (a < this.buf.length) {
            int n = a++;
            this.buf[n] = (short)(this.buf[n] + (short)(Math.sin(this.colPos) * 9000.0));
            this.colPos += colTheta;
        }
        this.offset += this.buf.length;
        if (this.offset == this.iRate) {
            this.reset();
        }
        return this.buf;
    }
}

