/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.ShellProcess;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JF {
    public static final String eol = System.getProperty("line.separator");
    public static final boolean isGraal = Boolean.getBoolean("java.graal");
    private static String user_dir = null;
    private static boolean initedHttps = false;
    private static TrustManager[] trustMgrs = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            if (clientKeys != null) {
                Certificate root = clientKeys.getCRT(clientKeysAlias);
                PublicKey key = root.getPublicKey();
                try {
                    certs[0].verify(key);
                    JFLog.log("Client verified");
                }
                catch (Exception e) {
                    JFLog.log("Client not verified");
                    throw new CertificateException();
                }
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            if (serverKeys != null) {
                Certificate root = serverKeys.getCRT(serverKeysAlias);
                PublicKey key = root.getPublicKey();
                try {
                    certs[0].verify(key);
                }
                catch (Exception e) {
                    JFLog.log("Client not verified");
                    throw new CertificateException();
                }
            }
        }
    }};
    public static KeyMgmt clientKeys;
    public static String clientKeysAlias;
    public static KeyMgmt serverKeys;
    public static String serverKeysAlias;
    public static String java_app_home;
    public static String filter_alpha;
    public static String filter_numeric;
    public static String filter_hex;
    public static String filter_alpha_numeric;
    public static String filter_id;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final char[] digits;
    public static final String[] StringArrayType;
    public static final String date_delimit = "-";
    public static final String date_format = "%04d-%02d-%02d";
    public static final String time_delimit = ":";
    public static final String time_format = "%02d:%02d:%02d";
    public static int[] days;

    public static String getVersion() {
        return "85.0";
    }

    public static void main(String[] args) {
        System.out.println("javaforce/" + JF.getVersion());
    }

    public static final boolean isGraal() {
        return isGraal;
    }

    public static void sleep(int milli) {
        try {
            Thread.sleep(milli);
        }
        catch (InterruptedException e) {
            JFLog.log(e);
        }
    }

    public static void msg(String msg) {
        System.out.println(msg);
    }

    public static URL createURL(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static String cleanURL(String url) {
        int idx = url.indexOf(64);
        if (idx == -1) {
            return url;
        }
        int i2 = url.indexOf("://");
        if (i2 == -1) {
            return null;
        }
        return url.substring(0, i2 + 3) + url.substring(idx + 1);
    }

    public static String readURL(String url) {
        Object str = "";
        byte[] data = new byte[1024];
        Object purl = "";
        block8: for (int p = 0; p < url.length(); ++p) {
            char ch = url.charAt(p);
            switch (ch) {
                case ' ': {
                    purl = (String)purl + "%20";
                    continue block8;
                }
                case '%': {
                    purl = (String)purl + "%25";
                    continue block8;
                }
                case '<': {
                    purl = (String)purl + "%3c";
                    continue block8;
                }
                case '>': {
                    purl = (String)purl + "%3e";
                    continue block8;
                }
                default: {
                    purl = (String)purl + ch;
                }
            }
        }
        try {
            int read;
            URL u = new URI((String)purl).toURL();
            HttpURLConnection huc = (HttpURLConnection)u.openConnection();
            huc.setRequestMethod("GET");
            huc.connect();
            if (huc.getResponseCode() != 200) {
                return "huc error : " + huc.getResponseCode();
            }
            InputStream is = huc.getInputStream();
            while ((read = is.read(data)) > 0) {
                str = (String)str + new String(data, 0, read);
            }
            is.close();
            huc.disconnect();
            return str;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encodeHTML(String txt) {
        return txt.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static int atoi(String str) {
        if (str.length() == 0) {
            return 0;
        }
        try {
            if (str.charAt(0) == '+') {
                str = str.substring(1);
            }
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
    }

    public static long atol(String str) {
        if (str.length() == 0) {
            return 0L;
        }
        try {
            if (str.charAt(0) == '+') {
                str = str.substring(1);
            }
            return Long.parseLong(str);
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1L;
        }
    }

    public static float atof(String str) {
        if (str.length() == 0) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1.0f;
        }
    }

    public static double atod(String str) {
        if (str.length() == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1.0;
        }
    }

    public static int atox(String str) {
        if (str.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(str, 16);
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static boolean isUnix() {
        return File.separatorChar == '/';
    }

    public static boolean isMac() {
        if (!JF.isUnix()) {
            return false;
        }
        String osName = System.getProperty("os.name");
        return osName.startsWith("Mac") || osName.startsWith("Darwin");
    }

    public static boolean isJFLinux() {
        if (!JF.isUnix()) {
            return false;
        }
        return new File("/usr/sbin/jlogon").exists();
    }

    public static String getUserPath() {
        return System.getProperty("user.home");
    }

    public static String getCurrentUser() {
        return System.getProperty("user.name");
    }

    public static String getTempPath() {
        if (JF.isWindows()) {
            return System.getenv("TEMP");
        }
        return "/tmp";
    }

    public static synchronized String getCurrentPath() {
        if (user_dir == null) {
            user_dir = System.getProperty("user.dir");
        }
        return user_dir;
    }

    public static void setCurrentPath(String new_dir) {
        user_dir = new_dir;
    }

    public static String getConfigPath() {
        if (JF.isWindows()) {
            String path = System.getenv("PROGRAMDATA");
            if (path == null) {
                path = System.getenv("ALLUSERSPROFILE");
            }
            return path;
        }
        return "/etc";
    }

    public static String getLogPath() {
        if (JF.isWindows()) {
            return System.getenv("windir") + "/Logs";
        }
        return "/var/log";
    }

    public static String getExecExt() {
        if (JF.isWindows()) {
            return ".exe";
        }
        return "";
    }

    public static String getScriptExt() {
        if (JF.isWindows()) {
            return ".bat";
        }
        return ".sh";
    }

    public static String getHostname() {
        if (JF.isWindows()) {
            return System.getenv("COMPUTERNAME");
        }
        try {
            FileInputStream fis = new FileInputStream("/etc/hostname");
            byte[] data = fis.readAllBytes();
            fis.close();
            return new String(data);
        }
        catch (Exception e) {
            JFLog.log(e);
            return "localhost";
        }
    }

    public static long currentTimeMillis() {
        long now = System.currentTimeMillis();
        int offset = TimeZone.getDefault().getOffset(now);
        return now + (long)offset;
    }

    public static void printEnvironment() {
        Map<String, String> env = System.getenv();
        env.forEach((k, v) -> System.out.println(k + time_delimit + v));
    }

    public static void printProperties() {
        Properties p = System.getProperties();
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)p.get(key);
            System.out.println(key + ": " + value);
        }
    }

    public static boolean eof(InputStream f) {
        try {
            return f.available() <= 0;
        }
        catch (Exception e) {
            JFLog.log(e);
            return true;
        }
    }

    public static int filelength(InputStream is) {
        try {
            return is.available();
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
    }

    public static boolean fileskip(InputStream is, int length) {
        try {
            is.skip(length);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean fileflush(BufferedOutputStream bos) {
        try {
            bos.flush();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static FileInputStream fileopen(String name) {
        try {
            return new FileInputStream(name);
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static FileOutputStream filecreate(String name) {
        try {
            return new FileOutputStream(name);
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static FileOutputStream filecreateappend(String name) {
        try {
            return new FileOutputStream(name, true);
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static boolean fileclose(InputStream is) {
        try {
            is.close();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean fileclose(OutputStream os) {
        try {
            os.close();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static byte[] read(InputStream in, int max) {
        byte[] ret = new byte[max];
        try {
            int read = in.read(ret);
            if (read == max) {
                return ret;
            }
            if (read == 0) {
                return null;
            }
            byte[] ret2 = new byte[read];
            System.arraycopy(ret, 0, ret2, 0, read);
            return ret2;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static byte[] readAll(InputStream in) {
        try {
            int read;
            int len = in.available();
            byte[] ret = new byte[len];
            for (int pos = 0; pos < len; pos += read) {
                read = in.read(ret, pos, len - pos);
                if (read > 0) continue;
                return null;
            }
            return ret;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static byte[] readAll(InputStream in, int len) {
        try {
            int read;
            byte[] ret = new byte[len];
            for (int pos = 0; pos < len; pos += read) {
                read = in.read(ret, pos, len - pos);
                if (read > 0) continue;
                return null;
            }
            return ret;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static boolean readAll(InputStream in, byte[] buf, int pos, int len) {
        int end = pos + len;
        try {
            while (pos < end) {
                int read = in.read(buf, pos, len);
                if (read <= 0) {
                    return false;
                }
                pos += read;
                len -= read;
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean readAll(RandomAccessFile in, byte[] buf, int pos, int len) {
        int end = pos + len;
        try {
            while (pos < end) {
                int read = in.read(buf, pos, len);
                if (read <= 0) {
                    return false;
                }
                pos += read;
                len -= read;
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static byte[] readAll(InputStream in, Socket s) {
        try {
            byte[] tmp = new byte[1500];
            byte[] ret = new byte[]{};
            while (in.available() > 0 || s.isConnected()) {
                int read = in.read(tmp);
                if (read <= 0) {
                    return ret;
                }
                int pos = ret.length;
                ret = Arrays.copyOf(ret, pos + read);
                System.arraycopy(tmp, 0, ret, pos, read);
            }
            return ret;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static byte[] readFile(String file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] data = fis.readAllBytes();
            fis.close();
            return data;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static int read(InputStream in, byte[] buf, int pos, int len) {
        try {
            return in.read(buf, pos, len);
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
    }

    public static int read(InputStream in) {
        try {
            return in.read();
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
    }

    public static char readchar(InputStream in) {
        try {
            return (char)in.read();
        }
        catch (Exception e) {
            JFLog.log(e);
            return '\u0000';
        }
    }

    public static int readuint8(InputStream in) {
        byte[] data = new byte[1];
        try {
            if (in.read(data) != 1) {
                return -1;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
        return data[0] & 0xFF;
    }

    public static int readuint16(InputStream in) {
        byte[] data = new byte[2];
        try {
            if (in.read(data) != 2) {
                return -1;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
        int ret = data[0] & 0xFF;
        return ret += (data[1] & 0xFF) << 8;
    }

    public static int readuint32(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data) != 4) {
                return -1;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
        int ret = data[0] & 0xFF;
        ret += (data[1] & 0xFF) << 8;
        ret += (data[2] & 0xFF) << 16;
        return ret += (data[3] & 0xFF) << 24;
    }

    public static long readuint64(InputStream in) {
        byte[] data = new byte[8];
        try {
            if (in.read(data) != 8) {
                return -1L;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1L;
        }
        long ret = (long)data[0] & 0xFFL;
        ret += ((long)data[1] & 0xFFL) << 8;
        ret += ((long)data[2] & 0xFFL) << 16;
        ret += ((long)data[3] & 0xFFL) << 24;
        ret += ((long)data[4] & 0xFFL) << 32;
        ret += ((long)data[5] & 0xFFL) << 40;
        ret += ((long)data[6] & 0xFFL) << 48;
        return ret += ((long)data[7] & 0xFFL) << 56;
    }

    public static float readfloat(InputStream in) {
        int bits = JF.readuint32(in);
        return Float.intBitsToFloat(bits);
    }

    public static double readdouble(InputStream in) {
        long bits = JF.readuint64(in);
        return Double.longBitsToDouble(bits);
    }

    public static boolean write(OutputStream out, byte[] data) {
        try {
            out.write(data);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean write(OutputStream out, String str) {
        return JF.write(out, str.getBytes());
    }

    public static boolean write(OutputStream out, byte[] data, int offset, int length) {
        try {
            out.write(data, offset, length);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean writeFile(String file, byte[] data) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data);
            fos.close();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean writeuint8(OutputStream out, int data) {
        try {
            out.write(data);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public static boolean writeuint16(OutputStream out, int data) {
        try {
            out.write(data & 0xFF);
            out.write((data >>= 8) & 0xFF);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public static boolean writeuint32(OutputStream out, int data) {
        try {
            out.write(data & 0xFF);
            out.write((data >>= 8) & 0xFF);
            out.write((data >>= 8) & 0xFF);
            out.write((data >>= 8) & 0xFF);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public static boolean writeuint64(OutputStream out, long data) {
        try {
            for (int a = 0; a < 8; ++a) {
                out.write((int)(data & 0xFFL));
                data >>= 8;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public static boolean writefloat(OutputStream out, float data) {
        int bits = Float.floatToIntBits(data);
        return JF.writeuint32(out, bits);
    }

    public static boolean writedouble(OutputStream out, double data) {
        long bits = Double.doubleToLongBits(data);
        return JF.writeuint64(out, bits);
    }

    public static boolean copyAll(InputStream is, OutputStream os) {
        try {
            byte[] buf = new byte[1024];
            while (is.available() > 0) {
                int read = is.read(buf);
                if (read == 0) continue;
                if (read == -1) {
                    return false;
                }
                os.write(buf, 0, read);
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean copyAll(String src, String dst) {
        try {
            FileInputStream fis = new FileInputStream(src);
            FileOutputStream fos = new FileOutputStream(dst);
            boolean success = JF.copyAll(fis, fos);
            fis.close();
            fos.close();
            return success;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean copyAllAppend(String src, String dst) {
        try {
            FileInputStream fis = new FileInputStream(src);
            FileOutputStream fos = new FileOutputStream(dst, true);
            boolean success = JF.copyAll(fis, fos);
            fis.close();
            fos.close();
            return success;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean echoAppend(String str, String dst) {
        try {
            FileOutputStream fos = new FileOutputStream(dst, true);
            fos.write(str.getBytes());
            fos.close();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean copyAll(InputStream is, OutputStream os, long length) {
        try {
            byte[] buf = new byte[1024];
            int copied = 0;
            while ((long)copied < length) {
                int read = is.read(buf);
                if (read == 0) continue;
                if (read == -1) {
                    return false;
                }
                os.write(buf, 0, read);
                copied += read;
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean isWildcard(String wcstr) {
        if (wcstr.indexOf("*") != -1) {
            return true;
        }
        return wcstr.indexOf("?") != -1;
    }

    public static boolean wildcardCompare(String fnstr, String wcstr, boolean caseSensitive) {
        int wcp;
        char[] fn = fnstr.toCharArray();
        char[] wc = wcstr.toCharArray();
        int fnp = 0;
        for (wcp = 0; fnp < fn.length && wcp < wc.length; ++fnp, ++wcp) {
            char wcc;
            char fnc;
            if (wc[wcp] == '*') {
                int sl = fn.length - fnp;
                ++wcp;
                for (int a = 0; a <= sl; ++a) {
                    if (!JF.wildcardCompare(new String(fn, fnp, fn.length - fnp), new String(fn, fnp, a) + new String(wc, wcp, wc.length - wcp), caseSensitive)) continue;
                    return true;
                }
                return false;
            }
            if (wc[wcp] == '?') {
                ++wcp;
                for (int a = 0; a <= 1; ++a) {
                    if (!JF.wildcardCompare(new String(fn, fnp, fn.length - fnp), new String(fn, fnp, a) + new String(wc, wcp, wc.length - wcp), caseSensitive)) continue;
                    return true;
                }
                return false;
            }
            if (caseSensitive) {
                fnc = fn[fnp];
                wcc = wc[wcp];
            } else {
                fnc = Character.toUpperCase(fn[fnp]);
                wcc = Character.toUpperCase(wc[wcp]);
            }
            if (fnc != wcc) break;
        }
        while (wcp < wc.length && (wc[wcp] == '*' || wc[wcp] == '?')) {
            ++wcp;
        }
        if (wcp < wc.length) {
            return false;
        }
        return fnp >= fn.length;
    }

    public static char[] createstr(String str) {
        return str.toCharArray();
    }

    public static char[] truncstr(char[] str, int newlength) {
        if (newlength == 0) {
            return null;
        }
        char[] ret = new char[newlength];
        if (newlength <= str.length) {
            System.arraycopy(str, 0, ret, 0, ret.length);
        } else {
            System.arraycopy(str, 0, ret, 0, str.length);
            for (int a = str.length; a < ret.length; ++a) {
                ret[a] = '\u0000';
            }
        }
        return ret;
    }

    public static char[] strcpy(char[] str) {
        char[] ret = new char[str.length];
        System.arraycopy(str, 0, ret, 0, str.length);
        return ret;
    }

    public static char[] strcat(char[] s1, char[] s2) {
        if (s1 == null) {
            s1 = new char[]{};
        }
        char[] ret = new char[s1.length + s2.length];
        System.arraycopy(s1, 0, ret, 0, s1.length);
        System.arraycopy(s2, 0, ret, s1.length, s2.length);
        return ret;
    }

    public static char[] strcat(char[] str, char ch) {
        if (str == null) {
            char[] ret = new char[]{ch};
            return ret;
        }
        char[] ret = new char[str.length + 1];
        System.arraycopy(str, 0, ret, 0, str.length);
        ret[str.length] = ch;
        return ret;
    }

    public static String createString(char[] str) {
        return new String(str);
    }

    public static boolean strcmp(String s1, String s2) {
        return s1.equals(s2);
    }

    public static boolean stricmp(String s1, String s2) {
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean strcmp(char[] s1, char[] s2) {
        return JF.strcmp(new String(s1), new String(s2));
    }

    public static boolean stricmp(char[] s1, char[] s2) {
        return JF.stricmp(new String(s1), new String(s2));
    }

    public static void memcpy(Object[] src, int srcpos, Object[] dest, int destpos, int len) {
        System.arraycopy(src, srcpos, dest, destpos, len);
    }

    public static boolean memcmp(byte[] m1, int m1pos, byte[] m2, int m2pos, int len) {
        for (int a = 0; a < len; ++a) {
            if (m1[m1pos + a] == m2[m2pos + a]) continue;
            return false;
        }
        return true;
    }

    public static boolean memicmp(byte[] m1, int m1pos, byte[] m2, int m2pos, int len) {
        for (int a = 0; a < len; ++a) {
            char c2;
            char c1 = Character.toUpperCase((char)m1[m1pos + a]);
            if (c1 == (c2 = Character.toUpperCase((char)m2[m2pos + a]))) continue;
            return false;
        }
        return true;
    }

    public static String getJARPath() {
        return System.getProperty("java.class.path");
    }

    public static void randomize(Random random) {
        random.setSeed(System.currentTimeMillis());
    }

    public static short endian(short x) {
        short ret = (short)(x << 8);
        ret = (short)(ret + (x >>> 8));
        return ret;
    }

    public static int endian(int x) {
        return x << 24 | x << 8 & 0xFF0000 | x >> 8 & 0xFF00 | x >>> 24;
    }

    public static long endian(long x) {
        return x << 56 | x << 40 & 0xFF000000000000L | x << 24 & 0xFF0000000000L | x << 8 & 0xFF00000000L | x >> 8 & 0xFF000000L | x >> 24 & 0xFF0000L | x >> 40 & 0xFF00L | x >>> 56;
    }

    public static int getPID() {
        return (int)ProcessHandle.current().pid();
    }

    public static <T> T[] copyOfExcluding(T[] array, int idx) {
        Class<?> cls = array.getClass().getComponentType();
        Object[] newArray = (Object[])Array.newInstance(cls, array.length - 1);
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx + 1, newArray, idx, array.length - idx - 1);
        return newArray;
    }

    public static boolean[] copyOfExcluding(boolean[] array, int idx) {
        boolean[] newArray = new boolean[array.length - 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx + 1, newArray, idx, array.length - idx - 1);
        return newArray;
    }

    public static byte[] copyOfExcluding(byte[] array, int idx) {
        byte[] newArray = new byte[array.length - 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx + 1, newArray, idx, array.length - idx - 1);
        return newArray;
    }

    public static short[] copyOfExcluding(short[] array, int idx) {
        short[] newArray = new short[array.length - 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx + 1, newArray, idx, array.length - idx - 1);
        return newArray;
    }

    public static int[] copyOfExcluding(int[] array, int idx) {
        int[] newArray = new int[array.length - 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx + 1, newArray, idx, array.length - idx - 1);
        return newArray;
    }

    public static float[] copyOfExcluding(float[] array, int idx) {
        float[] newArray = new float[array.length - 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx + 1, newArray, idx, array.length - idx - 1);
        return newArray;
    }

    public static double[] copyOfExcluding(double[] array, int idx) {
        double[] newArray = new double[array.length - 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx + 1, newArray, idx, array.length - idx - 1);
        return newArray;
    }

    public static char[] copyOfExcluding(char[] array, int idx) {
        char[] newArray = new char[array.length - 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx + 1, newArray, idx, array.length - idx - 1);
        return newArray;
    }

    public static <T> T[] copyOfInsert(T[] array, int idx, T insert) {
        Class<?> cls = array.getClass().getComponentType();
        Object[] newArray = (Object[])Array.newInstance(cls, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx, newArray, idx + 1, array.length - idx);
        newArray[idx] = insert;
        return newArray;
    }

    public static boolean[] copyOfInsert(boolean[] array, int idx, boolean insert) {
        boolean[] newArray = new boolean[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx, newArray, idx + 1, array.length - idx);
        newArray[idx] = insert;
        return newArray;
    }

    public static byte[] copyOfInsert(byte[] array, int idx, byte insert) {
        byte[] newArray = new byte[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx, newArray, idx + 1, array.length - idx);
        newArray[idx] = insert;
        return newArray;
    }

    public static short[] copyOfInsert(short[] array, int idx, short insert) {
        short[] newArray = new short[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx, newArray, idx + 1, array.length - idx);
        newArray[idx] = insert;
        return newArray;
    }

    public static int[] copyOfInsert(int[] array, int idx, int insert) {
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx, newArray, idx + 1, array.length - idx);
        newArray[idx] = insert;
        return newArray;
    }

    public static long[] copyOfInsert(long[] array, int idx, long insert) {
        long[] newArray = new long[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx, newArray, idx + 1, array.length - idx);
        newArray[idx] = insert;
        return newArray;
    }

    public static float[] copyOfInsert(float[] array, int idx, float insert) {
        float[] newArray = new float[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx, newArray, idx + 1, array.length - idx);
        newArray[idx] = insert;
        return newArray;
    }

    public static double[] copyOfInsert(double[] array, int idx, double insert) {
        double[] newArray = new double[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, idx);
        System.arraycopy(array, idx, newArray, idx + 1, array.length - idx);
        newArray[idx] = insert;
        return newArray;
    }

    public static void initHttps(KeyMgmt keys) {
        if (initedHttps) {
            return;
        }
        initedHttps = true;
        try {
            SSLContext ctx = SSLContext.getInstance("SSL");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = keys.getKeyStore();
            kmf.init(ks, keys.getKeyStorePass().toCharArray());
            ctx.init(kmf.getKeyManagers(), trustMgrs, new SecureRandom());
            SSLSocketFactory sslsocketfactory = ctx.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sslsocketfactory);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                if (!urlHostName.equalsIgnoreCase(session.getPeerHost())) {
                    System.out.println("Warning: URL host '" + urlHostName + "' is different to SSLSession host '" + session.getPeerHost() + "'.");
                }
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }

    public static Socket connectSSL(String host, int port, KeyMgmt keys) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.3");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = keys.getKeyStore();
            kmf.init(ks, keys.getKeyStorePass().toCharArray());
            ctx.init(kmf.getKeyManagers(), trustMgrs, new SecureRandom());
            SSLSocketFactory sslsocketfactory = ctx.getSocketFactory();
            Socket raw = new Socket(host, port);
            SSLSocket ssl = (SSLSocket)sslsocketfactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
            ssl.startHandshake();
            return ssl;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static ServerSocket createServerSocketSSL(int port, KeyMgmt keys) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.3");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = keys.getKeyStore();
            kmf.init(ks, keys.getKeyStorePass().toCharArray());
            ctx.init(kmf.getKeyManagers(), trustMgrs, new SecureRandom());
            SSLServerSocketFactory sslfactory = ctx.getServerSocketFactory();
            SSLServerSocket ssl = (SSLServerSocket)sslfactory.createServerSocket(port);
            return ssl;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static ServerSocket createServerSocketSSL(KeyMgmt keys) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.3");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = keys.getKeyStore();
            kmf.init(ks, keys.getKeyStorePass().toCharArray());
            ctx.init(kmf.getKeyManagers(), trustMgrs, new SecureRandom());
            SSLServerSocketFactory sslfactory = ctx.getServerSocketFactory();
            SSLServerSocket ssl = (SSLServerSocket)sslfactory.createServerSocket();
            return ssl;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static Socket connectSSL(Socket socket, KeyMgmt keys) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.3");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = keys.getKeyStore();
            kmf.init(ks, keys.getKeyStorePass().toCharArray());
            ctx.init(kmf.getKeyManagers(), trustMgrs, new SecureRandom());
            SSLSocketFactory sslsocketfactory = ctx.getSocketFactory();
            SSLSocket ssl = (SSLSocket)sslsocketfactory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
            ssl.setUseClientMode(true);
            ssl.startHandshake();
            return ssl;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static int getLineNumber() {
        return Thread.currentThread().getStackTrace()[2].getLineNumber();
    }

    public static String join(String delimit, String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < strings.length; ++a) {
            if (a > 0) {
                sb.append(delimit);
            }
            sb.append(strings[a]);
        }
        return sb.toString();
    }

    public static String join(String delimit, String[] strings, int startIdx) {
        StringBuilder sb = new StringBuilder();
        for (int a = startIdx; a < strings.length; ++a) {
            if (a > startIdx) {
                sb.append(delimit);
            }
            sb.append(strings[a]);
        }
        return sb.toString();
    }

    public static int indexOf(String str, char ch, int n) {
        if (n < 1) {
            return -1;
        }
        char[] cstr = str.toCharArray();
        for (int idx = 0; idx < cstr.length; ++idx) {
            if (cstr[idx] != ch || --n != 0) continue;
            return idx;
        }
        return -1;
    }

    public static int indexOfDigit(String str) {
        char[] cs = str.toCharArray();
        int idx = 0;
        for (char c : cs) {
            if (Character.isDigit(c)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static String[] expandArgs(String[] args) {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean caseSensitive = !JF.isWindows();
        for (int a = 0; a < args.length; ++a) {
            if (args[a].length() > 0 && args[a].charAt(0) != '\"' && (args[a].indexOf(42) != -1 || args[a].indexOf(63) != -1)) {
                String parentPath;
                File x = new File(args[a]);
                File parent = x.getParentFile();
                String glob = x.getName();
                if (parent == null) {
                    parent = new File(".");
                }
                if ((parentPath = args[a].substring(0, args[a].length() - glob.length())).indexOf(42) != -1 || parentPath.indexOf(63) != -1) {
                    list.add(args[a]);
                    continue;
                }
                File[] files = parent.listFiles();
                if (files == null) {
                    list.add(args[a]);
                    continue;
                }
                int cnt = 0;
                for (int f = 0; f < files.length; ++f) {
                    String name = files[f].getName();
                    if (!JF.wildcardCompare(name, glob, caseSensitive)) continue;
                    list.add(parentPath + name);
                    ++cnt;
                }
                if (cnt != 0) continue;
                list.add(args[a]);
                continue;
            }
            list.add(args[a]);
        }
        return list.toArray(new String[list.size()]);
    }

    public static void setJavaAppHome(String value) {
        System.out.println("setting java_app_home to " + value);
        java_app_home = value;
    }

    public static boolean is64Bit() {
        return true;
    }

    public static String getPath(String filename) {
        File file = new File(filename);
        return file.getParent();
    }

    public static void deletePathEx(String path) {
        try {
            File folder = new File(path);
            if (!folder.isDirectory()) {
                return;
            }
            File[] files = new File(path).listFiles();
            if (files == null) {
                return;
            }
            for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                if (file.isDirectory()) {
                    JF.deletePathEx(file.getAbsolutePath());
                    continue;
                }
                file.delete();
            }
            folder.delete();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private static void zipPath(ZipOutputStream zos, String path, String base) throws Exception {
        File[] files = new File(path).listFiles();
        for (int a = 0; a < files.length; ++a) {
            File file = files[a];
            String name = file.getName();
            Object full = base.length() == 0 ? name : base + "/" + name;
            if (file.isDirectory()) {
                JF.zipPath(zos, file.getAbsolutePath(), (String)full);
                continue;
            }
            ZipEntry ze = new ZipEntry((String)full);
            zos.putNextEntry(ze);
            FileInputStream fis = new FileInputStream(file);
            JF.copyAll(fis, zos);
            fis.close();
            zos.closeEntry();
        }
    }

    public static void zipPath(String path, String zip) {
        try {
            File folder = new File(path);
            if (!folder.isDirectory()) {
                JFLog.log("Error:path to be zipped not found");
                return;
            }
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));
            JF.zipPath(zos, path, "");
            zos.finish();
            zos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static void unzip(String zip, String path) {
        JFLog.log("unzip:" + zip + " to " + path);
        try {
            ZipEntry ze;
            File folder = new File(path);
            if (folder.exists() && !folder.isDirectory()) {
                JFLog.log("Error:target path is a file");
                return;
            }
            if (!folder.exists()) {
                folder.mkdirs();
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (ze.isDirectory()) {
                    new File(path + "/" + name).mkdirs();
                    continue;
                }
                String full = path + "/" + name;
                int idx = full.lastIndexOf("/");
                if (idx != -1) {
                    String epath = full.substring(0, idx);
                    new File(epath).mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(full);
                JF.copyAll(zis, fos);
                fos.close();
            }
            zis.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static String[] splitQuoted(String in, char token) {
        ArrayList<String> s = new ArrayList<String>();
        char[] ca = in.toCharArray();
        int off = 0;
        boolean quote1 = false;
        boolean quote2 = false;
        int cnt = 0;
        for (int a = 0; a < ca.length; ++a) {
            char ch = ca[a];
            if (ch == '\'' && !quote2) {
                boolean bl = quote1 = !quote1;
            }
            if (ch == '\"' && !quote1) {
                boolean bl = quote2 = !quote2;
            }
            if (!quote1 && !quote2 && ch == token) {
                String str = new String(ca, off, cnt);
                s.add(str);
                off = a + 1;
                cnt = 0;
                continue;
            }
            ++cnt;
        }
        if (cnt > 0) {
            String str = new String(ca, off, cnt);
            s.add(str);
        }
        return s.toArray(StringArrayType);
    }

    public static String readLineQuoted(InputStream is) {
        StringBuilder sb = new StringBuilder();
        boolean quote1 = false;
        boolean quote2 = false;
        try {
            while (is.available() > 0) {
                char ch = (char)is.read();
                if (ch == '\'' && !quote2) {
                    boolean bl = quote1 = !quote1;
                }
                if (ch == '\"' && !quote1) {
                    boolean bl = quote2 = !quote2;
                }
                if (!quote1 && !quote2) {
                    if (ch == '\r') continue;
                    if (ch == '\n') break;
                }
                sb.append(ch);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static Object readObject(InputStream is) {
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            Object obj = ois.readObject();
            return obj;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static Object readObject(String file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            Object obj = JF.readObject(fis);
            fis.close();
            return obj;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static void writeObject(Object obj, OutputStream os) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(obj);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static void writeObject(Object obj, String file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            JF.writeObject(obj, fos);
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static InetAddress getLocalAddress(DatagramPacket packet) {
        try {
            SocketAddress remoteAddress = packet.getSocketAddress();
            DatagramSocket sock = new DatagramSocket();
            sock.connect(remoteAddress);
            InetAddress localAddress = sock.getLocalAddress();
            sock.disconnect();
            sock.close();
            return localAddress;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static String getRemoteMAC(String ip) {
        String[] lns;
        char macdelimit;
        int macidx;
        String output;
        ShellProcess shell = new ShellProcess();
        if (JF.isWindows()) {
            output = shell.run(new String[]{"arp", "-a"}, false);
            macidx = 1;
            macdelimit = '-';
        } else {
            output = shell.run(new String[]{"arp", "-n"}, false);
            macidx = 2;
            macdelimit = ':';
        }
        for (String ln : lns = output.split("\n")) {
            String[] f = ln.split(" +");
            if (!f[0].equals(ip)) continue;
            return f[macidx].replaceAll("[" + macdelimit + "]", "");
        }
        JFLog.log("JF.getRemoteMac():Error:IP not found:" + ip);
        return null;
    }

    public static String filter(String str, String regex) {
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        for (int idx = 0; idx < len; ++idx) {
            String ch = str.substring(idx, idx + 1);
            if (!ch.matches(regex)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static int exec(String[] cmd) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            return p.waitFor();
        }
        catch (Exception e) {
            JFLog.log(e);
            return -1;
        }
    }

    public static String toEng(long size) {
        if (size < 0x100000L) {
            return String.format("%dKB", size / 1024L);
        }
        if (size < 0x40000000L) {
            return String.format("%dMB", size / 0x100000L);
        }
        if (size < 0x10000000000L) {
            return String.format("%dGB", size / 0x40000000L);
        }
        return String.format("%dTB", size / 0x10000000000L);
    }

    public static long fromEng(String value) {
        Object cap = value.toUpperCase();
        if (!((String)cap).endsWith("B")) {
            cap = (String)cap + "B";
        }
        if (((String)cap).endsWith("KB")) {
            String val = ((String)cap).substring(0, ((String)cap).length() - 2);
            return Long.valueOf(val) * 1024L;
        }
        if (((String)cap).endsWith("MB")) {
            String val = ((String)cap).substring(0, ((String)cap).length() - 2);
            return Long.valueOf(val) * 0x100000L;
        }
        if (((String)cap).endsWith("GB")) {
            String val = ((String)cap).substring(0, ((String)cap).length() - 2);
            return Long.valueOf(val) * 0x40000000L;
        }
        if (((String)cap).endsWith("TB")) {
            String val = ((String)cap).substring(0, ((String)cap).length() - 2);
            return Long.valueOf(val) * 0x10000000000L;
        }
        return Long.valueOf(value);
    }

    public static boolean moveFile(String src, String dest) {
        try {
            Path temp = Files.move(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return temp != null;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean copyFile(String src, String dest) {
        try {
            Path temp = Files.copy(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return temp != null;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean grep(InputStream is, OutputStream os, String regex) {
        try {
            String ln;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String regexln = ".*(" + regex + ").*";
            while ((ln = br.readLine()) != null) {
                try {
                    if (!ln.matches(regexln)) continue;
                    os.write(ln.getBytes());
                    if (JF.isWindows()) {
                        os.write("\r\n".getBytes());
                        continue;
                    }
                    os.write("\n".getBytes());
                }
                catch (Exception exception) {}
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean grep(String filein, String fileout, String regex) {
        try {
            FileInputStream is = new FileInputStream(filein);
            FileOutputStream os = new FileOutputStream(fileout);
            boolean res = JF.grep(is, os, regex);
            ((InputStream)is).close();
            ((OutputStream)os).close();
            return res;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static String detectGC() {
        try {
            List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
                String name = gcMxBean.getName();
                if (name == null) continue;
                int idx = name.indexOf(32);
                if (idx != -1) {
                    name = name.substring(0, idx);
                }
                return name;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
        return null;
    }

    public static String Date2String(Calendar c) {
        return String.format(date_format, c.get(1), c.get(2) + 1, c.get(5));
    }

    public static String Time2String(Calendar c) {
        return String.format(time_format, c.get(11), c.get(12), c.get(13));
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static void sort(File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                boolean f2_dir;
                boolean f1_dir = f1.isDirectory();
                if (f1_dir != (f2_dir = f2.isDirectory())) {
                    if (f1_dir && !f2_dir) {
                        return -1;
                    }
                    return 1;
                }
                return f1.getName().compareTo(f2.getName());
            }
        });
    }

    static {
        clientKeysAlias = "root";
        serverKeysAlias = "root";
        java_app_home = ".";
        filter_alpha = "[a-zA-Z]";
        filter_numeric = "[0-9]";
        filter_hex = "[0-9a-fA-F]";
        filter_alpha_numeric = "[a-zA-Z0-9]";
        filter_id = "[a-zA-Z0-9-_]";
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        StringArrayType = new String[0];
        days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    }
}

