/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.server;

import java.util.ArrayList;
import javaforce.ASCII8;
import javaforce.Console;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ansi.server.Button;
import javaforce.ansi.server.CheckBox;
import javaforce.ansi.server.Field;
import javaforce.ansi.server.KeyEvents;
import javaforce.ansi.server.List;
import javaforce.ansi.server.TextField;
import javaforce.jni.LnxNative;
import javaforce.jni.WinNative;

public class ANSI {
    private static boolean debug = false;
    private static final char ESC = '\u001b';
    private StringBuffer buffer = new StringBuffer();
    private KeyEvents keyEvents;
    public int width;
    public int height;
    public static int fore_clr = 0;
    public static int back_clr = 0xFFFFFF;
    public static int field_clr = 0xAAAAAA;
    public static int text_clr = 0xFFFFFF;
    public static int blue_clr = 255;

    public static String repeat(int count, char ch) {
        if (count < 0) {
            return "";
        }
        char[] ca = new char[count];
        for (int a = 0; a < count; ++a) {
            ca[a] = ch;
        }
        return new String(ca);
    }

    public static String pad(String in, int maxLen) {
        if (in == null) {
            return ANSI.repeat(maxLen, ' ');
        }
        if (in.length() > maxLen) {
            return in.substring(0, maxLen);
        }
        return in + ANSI.repeat(maxLen - in.length(), ' ');
    }

    public ANSI(KeyEvents ke) {
        this.keyEvents = ke;
        this.getConsoleSize();
    }

    public static void enableConsoleMode() {
        Console.enableConsoleMode();
    }

    public static void disableConsoleMode() {
        Console.disableConsoleMode();
    }

    public boolean getConsoleSize() {
        boolean changed;
        int[] xy = JF.isWindows() ? WinNative.getConsoleSize() : LnxNative.getConsoleSize();
        boolean bl = changed = this.width != xy[0] || this.height != xy[1];
        if (changed) {
            this.width = xy[0];
            this.height = xy[1];
        }
        return changed;
    }

    public int[] getConsolePos() {
        if (JF.isWindows()) {
            return WinNative.getConsolePos();
        }
        return LnxNative.getConsolePos();
    }

    public boolean kbhit() {
        return Console.kbhit();
    }

    public char readConsole() {
        char ch = JF.isWindows() ? WinNative.readConsole() : LnxNative.readConsole();
        return ch;
    }

    public void flushConsole() {
        while (this.kbhit()) {
            this.readConsole();
        }
    }

    public void clrscr() {
        System.out.print("\u001b[2J");
    }

    public static void gotoPos(int x, int y) {
        System.out.print("\u001b[" + y + ";" + x + "H");
    }

    public static void drawBox1(int x, int y, int w, int h) {
        int c;
        ANSI.gotoPos(x, y);
        System.out.print(ASCII8.convert(218));
        for (c = 2; c <= w - 1; ++c) {
            System.out.print(ASCII8.convert(196));
        }
        System.out.print(ASCII8.convert(191));
        for (c = 1; c <= h - 2; ++c) {
            ANSI.gotoPos(x, y + c);
            System.out.print(ASCII8.convert(179));
            ANSI.gotoPos(x + w - 1, y + c);
            System.out.print(ASCII8.convert(179));
        }
        ANSI.gotoPos(x, y + h - 1);
        System.out.print(ASCII8.convert(192));
        for (c = 2; c <= w - 1; ++c) {
            System.out.print(ASCII8.convert(196));
        }
        System.out.print(ASCII8.convert(217));
    }

    public static void drawBox2(int x, int y, int w, int h) {
        int c;
        ANSI.gotoPos(x, y);
        System.out.print(ASCII8.convert(201));
        for (c = 2; c <= w - 1; ++c) {
            System.out.print(ASCII8.convert(205));
        }
        System.out.print(ASCII8.convert(187));
        for (c = 1; c <= h - 2; ++c) {
            ANSI.gotoPos(x, y + c);
            System.out.print(ASCII8.convert(186));
            ANSI.gotoPos(x + w - 1, y + c);
            System.out.print(ASCII8.convert(186));
        }
        ANSI.gotoPos(x, y + h - 1);
        System.out.print(ASCII8.convert(200));
        for (c = 2; c <= w - 1; ++c) {
            System.out.print(ASCII8.convert(205));
        }
        System.out.print(ASCII8.convert(188));
    }

    public void drawFill(int x, int y, int w, int h) {
        String ln = ANSI.repeat(w, ' ');
        for (int a = 0; a < h; ++a) {
            ANSI.gotoPos(x, y + a);
            System.out.print(ln);
        }
    }

    public static void setDialogColor() {
        ANSI.setForeColor(fore_clr);
        ANSI.setBackColor(back_clr);
    }

    public static void setFieldColor() {
        ANSI.setForeColor(fore_clr);
        ANSI.setBackColor(field_clr);
    }

    public static void setNormalTextColor() {
        ANSI.setForeColor(text_clr);
        ANSI.setBackColor(blue_clr);
    }

    public static void setSelectedTextColor() {
        ANSI.setForeColor(blue_clr);
        ANSI.setBackColor(text_clr);
    }

    public Field[] drawWindow(int x, int y, int w, int h, String[] txt) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ANSI.setForeColor(fore_clr);
        ANSI.setBackColor(back_clr);
        ANSI.drawBox1(x, y, w, h);
        int y1 = y + 1;
        int y2 = y + h - 1;
        int idx = 0;
        int w2 = w - 2;
        int x1 = x + 1;
        int fx = -1;
        int fy = -1;
        for (int py = y1; py < y2; ++py) {
            Field field;
            int pos;
            String ln;
            if ((ln = txt[idx++]) == null) {
                ln = "";
            }
            int len = ln.replaceAll("\\{checkbox\\}", "[ ]").length();
            int pad = w2 - len;
            int padleft = pad / 2;
            int padright = pad - padleft;
            ANSI.gotoPos(x1, py);
            if (ln.indexOf(91) != -1) {
                for (pos = 0; pos < len; ++pos) {
                    if (ln.charAt(pos) != '[') continue;
                    fx = x1 + pos + padleft;
                    fy = py;
                    field = new TextField();
                    field.setPos(fx + 1, fy);
                    String text = ln.substring(pos + 1, ln.indexOf(93, pos));
                    String trim = text.trim();
                    ((TextField)field).setText(trim);
                    ((TextField)field).cx = trim.length();
                    field.setWidth(text.length());
                    fields.add(field);
                }
                ln = ln.replaceAll("\\[", ANSI.makeBackColor(field_clr) + "[");
                ln = ln.replaceAll("\\]", "]" + ANSI.makeBackColor(back_clr));
            }
            if (ln.indexOf(60) != -1) {
                for (pos = 0; pos < len; ++pos) {
                    if (ln.charAt(pos) != '<') continue;
                    fx = x1 + pos + padleft;
                    fy = py;
                    field = new Button();
                    ((Button)field).x = fx;
                    ((Button)field).y = fy;
                    ((Button)field).cx = 1;
                    ((Button)field).action = ln.substring(pos + 1, ln.indexOf(62, pos));
                    fields.add(field);
                }
                ln = ln.replaceAll("<", ANSI.makeBackColor(field_clr) + "<");
                ln = ln.replaceAll(">", ">" + ANSI.makeBackColor(back_clr));
            }
            if (ln.indexOf("{list}") != -1) {
                for (pos = 0; pos < len; ++pos) {
                    if (!ln.substring(pos).startsWith("{list}")) continue;
                    fx = x1 + pos + padleft;
                    fy = py;
                    field = new List();
                    field.setPos(fx, fy);
                    field.setCursorPos(0, 0);
                    field.setDeltaOffset(1, 1);
                    fields.add(field);
                }
                ln = ln.replaceAll("\\{list\\}", "");
            }
            if (ln.indexOf("{checkbox}") != -1) {
                for (pos = 0; pos < len; ++pos) {
                    if (!ln.substring(pos).startsWith("{checkbox}")) continue;
                    fx = x1 + pos + padleft;
                    fy = py;
                    field = new CheckBox();
                    field.setPos(fx + 1, fy);
                    field.setCursorPos(0, 0);
                    field.setDeltaOffset(0, 0);
                    fields.add(field);
                }
                ln = ln.replaceAll("\\{checkbox\\}", "[ ]");
            }
            System.out.print(ANSI.repeat(padleft, ' ') + ln + ANSI.repeat(padright, ' '));
        }
        if (fields.size() != 0) {
            Field field = (Field)fields.get(0);
            field.gotoCurrentPos();
        }
        return fields.toArray(new Field[0]);
    }

    public static void drawList(int x, int y, int w, int h, String[] list, int start, int selected) {
        ANSI.setDialogColor();
        ANSI.drawBox1(x, y, w, h);
        if (list == null) {
            list = new String[]{};
        }
        int idx = start;
        int x1 = x + 1;
        int y1 = y + 1;
        int y2 = y + h - 2;
        int backclr = back_clr;
        int newclr = -1;
        for (int py = y1; py <= y2; ++py) {
            String ln = idx < list.length ? list[idx] : "";
            ANSI.gotoPos(x1, py);
            newclr = idx == selected ? field_clr : back_clr;
            if (newclr != backclr) {
                backclr = newclr;
                ANSI.setBackColor(newclr);
            }
            System.out.print(ANSI.pad(ln, w - 2));
            ++idx;
        }
    }

    public void drawMenu(int x, int y, String[] opts, int selected) {
        int width = 0;
        int height = opts.length + 2;
        for (int a = 0; a < opts.length; ++a) {
            if (opts[a].length() <= width) continue;
            width = opts[a].length();
        }
        String div = ANSI.repeat(width, '-');
        String format = "%-" + width + "s";
        ANSI.setForeColor(0);
        ANSI.setBackColor(0xFFFFFF);
        ANSI.drawBox1(x, y, width += 2, height);
        ++x;
        ++y;
        int sely = -1;
        for (int a = 0; a < opts.length; ++a) {
            ANSI.gotoPos(x, y);
            if (selected == a) {
                ANSI.setForeColor(0xFFFFFF);
                ANSI.setBackColor(0);
                sely = y;
            }
            if (opts[a].equals("-")) {
                System.out.print(div);
            } else {
                System.out.print(String.format(format, opts[a]));
            }
            if (selected == a) {
                ANSI.setForeColor(0);
                ANSI.setBackColor(0xFFFFFF);
            }
            ++y;
        }
        ANSI.gotoPos(x, sely);
    }

    public static String makeForeColor(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return "\u001b[38;2;" + r + ";" + g + ";" + b + "m";
    }

    public static void setForeColor(int rgb) {
        System.out.print(ANSI.makeForeColor(rgb));
    }

    public static String makeBackColor(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return "\u001b[48;2;" + r + ";" + g + ";" + b + "m";
    }

    public static void setBackColor(int rgb) {
        System.out.print(ANSI.makeBackColor(rgb));
    }

    public void scrollVBar(int x, int y, int height, int barSize, int barPos) {
        if (barPos == 0) {
            barPos = 1;
        }
        if (barSize == 0) {
            barSize = 1;
        }
        if (barPos == 100) {
            barPos = 99;
        }
        int bar1 = barPos * height / 100;
        int bar2 = bar1 + barSize * height / 100;
        ANSI.setForeColor(0xFFFFFF);
        ANSI.setBackColor(0);
        for (int dy = 0; dy < height; ++dy) {
            int pos = dy;
            ANSI.gotoPos(x, y + dy);
            if (pos >= bar1 && pos <= bar2) {
                System.out.print(ASCII8.convert(219));
                continue;
            }
            System.out.print(ASCII8.convert(176));
        }
    }

    public void scrollHBar(int x, int y, int width, int barSize, int barPos) {
        if (barPos == 0) {
            barPos = 1;
        }
        if (barSize == 0) {
            barSize = 1;
        }
        if (barPos == 100) {
            barPos = 99;
        }
        int bar1 = barPos * width / 100;
        int bar2 = bar1 + barSize * width / 100;
        ANSI.setForeColor(0xFFFFFF);
        ANSI.setBackColor(0);
        ANSI.gotoPos(x, y);
        for (int dx = 0; dx < width; ++dx) {
            int pos = dx;
            if (pos >= bar1 && pos <= bar2) {
                System.out.print(ASCII8.convert(219));
                continue;
            }
            System.out.print(ASCII8.convert(176));
        }
    }

    private boolean hasDigit(int[] nums, int digit) {
        for (int a = 0; a < nums.length; ++a) {
            if (nums[a] != digit) continue;
            return true;
        }
        return false;
    }

    public String getKeyBuffer() {
        if (this.buffer.length() == 0) {
            return "";
        }
        if (this.buffer.length() == 1) {
            return this.buffer.toString();
        }
        return this.buffer.toString().substring(1);
    }

    public void process() {
        int keyMods;
        int keyCode;
        block67: {
            block68: {
                int bufsize;
                block66: {
                    char ch = this.readConsole();
                    if (ch == '\u0000') {
                        return;
                    }
                    this.buffer.append(ch);
                    keyCode = 0;
                    keyMods = 0;
                    bufsize = this.buffer.length();
                    if (this.buffer.charAt(0) != '\u001b') {
                        this.keyEvents.keyTyped(this.buffer.charAt(0));
                        this.buffer.setLength(0);
                        return;
                    }
                    if (bufsize < 2) {
                        return;
                    }
                    if (this.buffer.charAt(1) != '[') break block66;
                    if (bufsize < 3) {
                        return;
                    }
                    char code = this.buffer.charAt(bufsize - 1);
                    if (code != '~' && !Character.isAlphabetic(code)) {
                        return;
                    }
                    if (debug) {
                        JFLog.log("buffer=" + this.getKeyBuffer());
                    }
                    int numc = 0;
                    if (Character.isDigit(this.buffer.charAt(2))) {
                        ++numc;
                        for (int p = 2; p < bufsize; ++p) {
                            if (this.buffer.charAt(p) != ';') continue;
                            ++numc;
                        }
                    }
                    int[] nums = new int[numc];
                    int pos = 2;
                    for (int num = 0; num < numc; ++num) {
                        int numpos;
                        int numlen = 0;
                        for (numpos = pos; numpos < bufsize && Character.isDigit(this.buffer.charAt(numpos)); ++numpos) {
                            ++numlen;
                        }
                        nums[num] = Integer.valueOf(this.buffer.substring(pos, pos + numlen));
                        pos = numpos;
                        ++pos;
                    }
                    if (this.hasDigit(nums, 2)) {
                        keyMods = 64;
                    }
                    if (this.hasDigit(nums, 3)) {
                        keyMods = 512;
                    }
                    if (this.hasDigit(nums, 4)) {
                        keyMods = 576;
                    }
                    if (this.hasDigit(nums, 5)) {
                        keyMods = 128;
                    }
                    if (this.hasDigit(nums, 6)) {
                        keyMods = 192;
                    }
                    if (this.hasDigit(nums, 7)) {
                        keyMods = 640;
                    }
                    if (this.hasDigit(nums, 8)) {
                        keyMods = 704;
                    }
                    block0 : switch (code) {
                        case 'A': {
                            keyCode = 38;
                            break;
                        }
                        case 'B': {
                            keyCode = 40;
                            break;
                        }
                        case 'C': {
                            keyCode = 39;
                            break;
                        }
                        case 'D': {
                            keyCode = 37;
                            break;
                        }
                        case '~': {
                            if (numc == 0) break;
                            keyMods = nums[0] >= 25 ? 64 : 0;
                            switch (nums[0]) {
                                case 1: {
                                    keyCode = 27;
                                    break block0;
                                }
                                case 2: {
                                    keyCode = 155;
                                    break block0;
                                }
                                case 3: {
                                    keyCode = 127;
                                    break block0;
                                }
                                case 5: {
                                    keyCode = 33;
                                    break block0;
                                }
                                case 6: {
                                    keyCode = 34;
                                    break block0;
                                }
                                case 15: {
                                    keyCode = 116;
                                    break block0;
                                }
                                case 16: {
                                    keyCode = 88;
                                    break block0;
                                }
                                case 17: {
                                    keyCode = 117;
                                    break block0;
                                }
                                case 18: {
                                    keyCode = 118;
                                    break block0;
                                }
                                case 19: {
                                    keyCode = 119;
                                    break block0;
                                }
                                case 20: {
                                    keyCode = 120;
                                    break block0;
                                }
                                case 21: {
                                    keyCode = 121;
                                    break block0;
                                }
                                case 22: {
                                    keyCode = 88;
                                    break block0;
                                }
                                case 23: {
                                    keyCode = 122;
                                    break block0;
                                }
                                case 24: {
                                    keyCode = 123;
                                    break block0;
                                }
                                case 25: {
                                    keyCode = 112;
                                    break block0;
                                }
                                case 26: {
                                    keyCode = 113;
                                    break block0;
                                }
                                case 27: {
                                    keyCode = 88;
                                    break block0;
                                }
                                case 28: {
                                    keyCode = 114;
                                    break block0;
                                }
                                case 29: {
                                    keyCode = 115;
                                    break block0;
                                }
                                case 30: {
                                    keyCode = 88;
                                    break block0;
                                }
                                case 31: {
                                    keyCode = 116;
                                    break block0;
                                }
                                case 32: {
                                    keyCode = 117;
                                    break block0;
                                }
                                case 33: {
                                    keyCode = 118;
                                    break block0;
                                }
                                case 34: {
                                    keyCode = 119;
                                    break block0;
                                }
                            }
                            this.buffer.setLength(0);
                            return;
                        }
                        case 'H': {
                            keyCode = 36;
                            break;
                        }
                        case 'F': {
                            keyCode = 35;
                            break;
                        }
                        case 'P': {
                            keyCode = 112;
                            break;
                        }
                        case 'Q': {
                            keyCode = 113;
                            break;
                        }
                        case 'R': {
                            keyCode = 114;
                            break;
                        }
                        case 'S': {
                            keyCode = 115;
                            break;
                        }
                        default: {
                            this.buffer.setLength(0);
                            return;
                        }
                    }
                    break block67;
                }
                if (this.buffer.charAt(1) != 'O') break block68;
                if (bufsize <= 2) break block67;
                switch (this.buffer.charAt(2)) {
                    case 'P': {
                        keyCode = 112;
                        break block67;
                    }
                    case 'Q': {
                        keyCode = 113;
                        break block67;
                    }
                    case 'R': {
                        keyCode = 114;
                        break block67;
                    }
                    case 'S': {
                        keyCode = 115;
                        break block67;
                    }
                    default: {
                        this.buffer.setLength(0);
                        return;
                    }
                }
            }
            char code = this.buffer.charAt(1);
            if (Character.isAlphabetic(code)) {
                keyMods = 512;
                keyCode = code;
            } else {
                this.buffer.setLength(0);
                return;
            }
        }
        if (keyCode != 0) {
            this.keyEvents.keyPressed(keyCode, keyMods);
            this.buffer.setLength(0);
        }
    }
}

