/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.server;

import javaforce.ansi.server.ANSI;
import javaforce.ansi.server.Button;
import javaforce.ansi.server.Dialog;
import javaforce.ansi.server.Field;

public class MessageDialog
implements Dialog {
    private String[] lines;
    private ANSI ansi;
    private boolean closed = false;
    private int maxlen;
    private Field[] fields;
    private int field = 0;
    private String action;

    public MessageDialog(ANSI ansi, String[] lines) {
        this.ansi = ansi;
        this.lines = lines;
        for (int a = 0; a < lines.length; ++a) {
            int len = lines[a].length();
            if (len <= this.maxlen) continue;
            this.maxlen = len;
        }
        this.maxlen += 10;
    }

    @Override
    public void draw() {
        int x = (this.ansi.width - this.maxlen) / 2;
        int y = (this.ansi.height - this.lines.length) / 2;
        this.fields = this.ansi.drawWindow(x, y, this.maxlen, this.lines.length + 2, this.lines);
    }

    @Override
    public void keyPressed(int keyCode, int keyMods) {
        if (keyMods != 0) {
            return;
        }
        switch (keyCode) {
            case 27: {
                this.closed = true;
            }
        }
    }

    @Override
    public void keyTyped(char key) {
        switch (key) {
            case '\t': {
                this.nextField();
                break;
            }
            case '\n': {
                if (this.fields[this.field] instanceof Button) {
                    this.action = ((Button)this.fields[this.field]).action;
                }
                this.closed = true;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void nextField() {
        if (this.fields.length < 2) {
            return;
        }
        ++this.field;
        if (this.field == this.fields.length) {
            this.field = 0;
        }
        this.fields[this.field].gotoCurrentPos();
    }

    public String getAction() {
        return this.action;
    }
}

