/*
 * Decompiled with CFR 0.152.
 */
package javaforce.codec.speex.spi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javaforce.codec.speex.spi.SpeexEncoding;
import javaforce.codec.speex.spi.SpeexFileFormatType;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.AudioFileWriter;

public class SpeexAudioFileWriter
extends AudioFileWriter {
    public static final AudioFileFormat.Type[] NO_FORMAT = new AudioFileFormat.Type[0];
    public static final AudioFileFormat.Type[] SPEEX_FORMAT = new AudioFileFormat.Type[]{SpeexFileFormatType.SPEEX};

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes() {
        return SPEEX_FORMAT;
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        if (stream.getFormat().getEncoding() instanceof SpeexEncoding) {
            return SPEEX_FORMAT;
        }
        return NO_FORMAT;
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        AudioFileFormat.Type[] formats = this.getAudioFileTypes(stream);
        if (formats != null && formats.length > 0) {
            return this.write(stream, out);
        }
        throw new IllegalArgumentException("cannot write given file type");
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        AudioFileFormat.Type[] formats = this.getAudioFileTypes(stream);
        if (formats != null && formats.length > 0) {
            FileOutputStream fos = new FileOutputStream(out);
            return this.write(stream, fos);
        }
        throw new IllegalArgumentException("cannot write given file type");
    }

    private int write(AudioInputStream stream, OutputStream out) throws IOException {
        int temp;
        byte[] data = new byte[2048];
        int read = 0;
        while ((temp = stream.read(data, 0, 2048)) > 0) {
            out.write(data, 0, temp);
            read += temp;
        }
        out.flush();
        out.close();
        return read;
    }
}

