/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.STUN;
import javaforce.voip.RTP;
import javaforce.voip.RTPChannel;
import javaforce.voip.SDP;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SRTPChannelJ9
extends RTPChannel {
    private boolean server;
    public static String local_icepwd;
    public static TrustManager[] trustAllCerts;
    private ArrayList<byte[]> data_input = new ArrayList();
    private ArrayList<byte[]> data_output = new ArrayList();
    private static final short BINDING_REQUEST = 1;
    private static final short BINDING_RESPONSE = 257;
    private static final short MAPPED_ADDRESS = 1;
    private static final short USERNAME = 6;
    private static final short XOR_MAPPED_ADDRESS = 32;
    private static final short MESSAGE_INTEGRITY = 8;
    private static final short USE_CANDIDATE = 37;
    private static final short PRIORITY = 36;
    private static final short ICE_CONTROLLING = -32726;
    private static final short ICE_CONTROLLED = -32727;
    private static final short FINGERPRINT = -32728;
    private byte[] stun;

    public SRTPChannelJ9(RTP rtp, int ssrc, SDP.Stream stream, boolean server) {
        super(rtp, ssrc, stream);
        this.server = server;
    }

    @Override
    public boolean start() {
        JFLog.log("SRTPChannel.start()");
        if (!super.start()) {
            return false;
        }
        if (this.rtp.rawMode) {
            return true;
        }
        new Thread(){

            @Override
            public void run() {
                if (SRTPChannelJ9.this.server) {
                    UdpServer svr = new UdpServer();
                    svr.start();
                } else {
                    UdpClient clt = new UdpClient();
                    clt.start();
                }
            }
        }.start();
        return true;
    }

    public static void _log(String side, boolean client, String msg) {
        JFLog.log(side + ":" + (client ? "client" : "server") + ":" + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRTP(byte[] data, int off, int len) {
        ArrayList<byte[]> arrayList = this.data_output;
        synchronized (arrayList) {
            if (off == 0 && len == data.length) {
                this.data_output.add(data);
            } else {
                this.data_output.add(Arrays.copyOfRange(data, off, off + len));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRTP(byte[] data, int off, int len) {
        ArrayList<byte[]> arrayList = this.data_input;
        synchronized (arrayList) {
            if (off == 0 && len == data.length) {
                this.data_input.add(data);
            } else {
                this.data_input.add(Arrays.copyOfRange(data, off, off + len));
            }
        }
    }

    public static void initCtx(SSLContext ctx) {
        try {
            char[] passphrase = "password".toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream("dtls.key"), passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, passphrase);
            ctx.init(kmf.getKeyManagers(), trustAllCerts, new SecureRandom());
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private boolean isClassicStun(long id1) {
        return id1 >>> 32 != 554869826L;
    }

    private int IP4toInt(String ip) {
        String[] o = ip.split("[.]");
        int ret = 0;
        for (int a = 0; a < 4; ++a) {
            ret <<= 8;
            ret += JF.atoi(o[a]);
        }
        return ret;
    }

    protected void processSTUN(byte[] data, int off, int len) {
        JFLog.log("SRTPChannel:received STUN request");
        String username = null;
        String flipped = null;
        ByteBuffer bb = ByteBuffer.wrap(data, off, len);
        bb.order(ByteOrder.BIG_ENDIAN);
        int offset = off;
        short code = bb.getShort(offset);
        boolean auth = false;
        if (code != 1) {
            JFLog.log("RTPSecureChannel:Error:STUN Request is not Binding request");
            return;
        }
        int lengthOffset = offset += 2;
        short length = bb.getShort(offset);
        long id1 = bb.getLong(offset += 2);
        long id2 = bb.getLong(offset += 8);
        offset += 8;
        while (offset < len) {
            short attr = bb.getShort(offset);
            length = bb.getShort(offset += 2);
            offset += 2;
            switch (attr) {
                case 6: {
                    username = new String(data, offset, (int)length);
                    String[] f = username.split("[:]");
                    flipped = f[1] + ":" + f[0];
                    break;
                }
                case 8: {
                    bb.putShort(lengthOffset, (short)offset);
                    byte[] correct = STUN.calcMsgIntegrity(data, offset - 4, STUN.calcKey(local_icepwd));
                    byte[] supplied = Arrays.copyOfRange(data, offset, offset + 20);
                    auth = Arrays.equals(correct, supplied);
                }
            }
            offset += length;
            if ((length & 3) <= 0) continue;
            offset += 4 - (length & 3);
        }
        if (!auth) {
            return;
        }
        if (this.stun == null) {
            this.stun = new byte[1500];
        }
        bb = ByteBuffer.wrap(this.stun);
        bb.order(ByteOrder.BIG_ENDIAN);
        offset = 0;
        bb.putShort(offset, (short)257);
        lengthOffset = offset += 2;
        bb.putShort(offset, (short)0);
        bb.putLong(offset += 2, id1);
        bb.putLong(offset += 8, id2);
        offset += 8;
        if (this.isClassicStun(id1)) {
            bb.putShort(offset, (short)1);
            bb.putShort(offset += 2, (short)8);
            bb.put(offset += 2, (byte)0);
            bb.put(++offset, (byte)1);
            bb.putShort(++offset, (short)this.stream.port);
            bb.putInt(offset += 2, this.IP4toInt(this.stream.getIP()));
            offset += 4;
        } else {
            bb.putShort(offset, (short)32);
            bb.putShort(offset += 2, (short)8);
            bb.put(offset += 2, (byte)0);
            bb.put(++offset, (byte)1);
            bb.putShort(++offset, (short)(this.stream.port ^ bb.getShort(4)));
            bb.putInt(offset += 2, this.IP4toInt(this.stream.getIP()) ^ bb.getInt(4));
            offset += 4;
        }
        bb.putShort(lengthOffset, (short)(offset - 20 + 24));
        byte[] id = STUN.calcMsgIntegrity(this.stun, offset, STUN.calcKey(local_icepwd));
        int strlen = id.length;
        bb.putShort(offset, (short)8);
        bb.putShort(offset += 2, (short)strlen);
        System.arraycopy(id, 0, this.stun, offset += 2, strlen);
        if (((offset += strlen) & 3) > 0) {
            offset += 4 - (offset & 3);
        }
        bb.putShort(lengthOffset, (short)(offset - 20));
        try {
            if (RTP.useTURN) {
                this.rtp.stun1.sendData(this.turn1ch, this.stun, 0, offset);
            } else {
                this.rtp.sock1.send(this.stun, 0, offset, InetAddress.getByName(this.stream.getIP()), this.stream.getPort());
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    static {
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    public class UdpClient
    extends Thread {
        public SSLContext ctx;
        public SSLSessionContext sessctx;
        public SSLEngine ssl;

        @Override
        public void run() {
            try {
                JFLog.log("Client binding on port 2222");
                this.ctx = SSLContext.getInstance("DTLS");
                this.ctx.init(null, trustAllCerts, new SecureRandom());
                this.ssl = this.ctx.createSSLEngine("localhost", 2222);
                this.ssl.setUseClientMode(true);
                this.sessctx = this.ctx.getClientSessionContext();
                UdpHandshake handshake = new UdpHandshake();
                handshake.ssl = this.ssl;
                handshake.client = true;
                handshake.start();
                handshake.join();
                UdpReader reader = new UdpReader();
                reader.ssl = this.ssl;
                reader.client = true;
                UdpWriter writer = new UdpWriter();
                writer.ssl = this.ssl;
                writer.client = true;
                writer.reader = reader;
                reader.start();
                writer.start();
                reader.join();
                writer.join();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public class UdpServer
    extends Thread {
        public SSLContext ctx;
        public SSLSessionContext sessctx;
        public SSLEngine ssl;

        @Override
        public void run() {
            try {
                JFLog.log("Server binding on port 1111");
                this.ctx = SSLContext.getInstance("DTLS");
                SRTPChannelJ9.initCtx(this.ctx);
                this.ssl = this.ctx.createSSLEngine();
                this.ssl.setUseClientMode(false);
                this.sessctx = this.ctx.getServerSessionContext();
                UdpHandshake handshake = new UdpHandshake();
                handshake.ssl = this.ssl;
                handshake.client = false;
                handshake.start();
                handshake.join();
                UdpReader reader = new UdpReader();
                reader.ssl = this.ssl;
                UdpWriter writer = new UdpWriter();
                writer.ssl = this.ssl;
                writer.reader = reader;
                reader.start();
                writer.start();
                reader.join();
                writer.join();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public class UdpWriter
    extends Thread {
        public SSLEngine ssl;
        public boolean client;
        public ByteBuffer output;
        public ByteBuffer transfer;
        public UdpReader reader;

        public void log(String msg) {
            SRTPChannelJ9._log("writer", this.client, msg);
        }

        @Override
        public void run() {
            try {
                SSLSession sess = this.ssl.getSession();
                byte[] tmp = new byte[1024];
                Random r = new Random();
                r.nextBytes(tmp);
                this.output = ByteBuffer.wrap(tmp);
                this.transfer = ByteBuffer.allocateDirect(sess.getPacketBufferSize());
                int total = 0;
                while (true) {
                    SSLEngineResult res = this.ssl.wrap(this.output, this.transfer);
                    int consumed = res.bytesConsumed();
                    int produced = res.bytesProduced();
                    if (consumed == 0 && produced == 0) {
                        JF.sleep(10);
                        continue;
                    }
                    this.transfer.flip();
                    if (produced > 0) {
                        byte[] out = new byte[produced];
                        this.transfer.get(out);
                        SRTPChannelJ9.super.writeRTP(out, 0, out.length);
                    }
                    if (consumed > 0 && (total += consumed) == 1024) break;
                    this.output.flip();
                    this.output.compact();
                    this.transfer.compact();
                }
                this.log("done");
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public class UdpReader
    extends Thread {
        public SSLEngine ssl;
        public boolean client;
        public ByteBuffer transfer;
        public ByteBuffer input;

        public void log(String msg) {
            SRTPChannelJ9._log("reader", this.client, msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SSLSession sess = this.ssl.getSession();
                int maxAppSize = sess.getApplicationBufferSize();
                int maxPackSize = sess.getPacketBufferSize();
                this.input = ByteBuffer.allocate(maxAppSize + 50);
                this.transfer = ByteBuffer.allocateDirect(maxPackSize);
                int total = 0;
                do {
                    byte[] data;
                    ArrayList<byte[]> arrayList = SRTPChannelJ9.this.data_input;
                    synchronized (arrayList) {
                        if (SRTPChannelJ9.this.data_input.size() == 0) {
                            break;
                        }
                        data = SRTPChannelJ9.this.data_input.remove(0);
                    }
                    int length = data.length;
                    if (length > 0) {
                        int maxRead = this.transfer.remaining();
                        if (length > maxRead) {
                            length = maxRead;
                        }
                        this.log("rawread:" + length);
                        this.transfer.put(data, 0, length);
                    }
                    this.transfer.flip();
                    SSLEngineResult res = this.ssl.unwrap(this.transfer, this.input);
                    int consumed = res.bytesConsumed();
                    int produced = res.bytesProduced();
                    this.input.flip();
                    if (produced > 0) {
                        byte[] tmp = new byte[produced];
                        this.input.get(tmp);
                        if ((total += produced) == 1024) break;
                    }
                    this.transfer.compact();
                    this.input.compact();
                } while (total != 1024);
                this.log("done");
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public class UdpHandshake
    extends Thread {
        public SSLEngine ssl;
        public boolean client;
        public ByteBuffer intransfer;
        public ByteBuffer outtransfer;
        public ByteBuffer input;
        public ByteBuffer output;

        public void log(String msg) {
            SRTPChannelJ9._log("handshake", this.client, msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SSLSession sess = this.ssl.getSession();
                int maxAppSize = sess.getApplicationBufferSize();
                int maxPackSize = sess.getPacketBufferSize();
                this.input = ByteBuffer.allocate(maxAppSize + 50);
                this.output = ByteBuffer.allocate(maxAppSize + 50);
                this.intransfer = ByteBuffer.allocateDirect(maxPackSize * 2);
                this.outtransfer = ByteBuffer.allocateDirect(maxPackSize * 2);
                block11: while (true) {
                    this.log("status=" + String.valueOf((Object)this.ssl.getHandshakeStatus()));
                    SSLEngineResult.HandshakeStatus status = this.ssl.getHandshakeStatus();
                    if (status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                        status = this.client ? SSLEngineResult.HandshakeStatus.NEED_WRAP : SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                    }
                    switch (status) {
                        case NEED_TASK: {
                            Runnable runnable;
                            while ((runnable = this.ssl.getDelegatedTask()) != null) {
                                runnable.run();
                            }
                            continue block11;
                        }
                        case NEED_WRAP: {
                            SSLEngineResult res = this.ssl.wrap(this.output, this.outtransfer);
                            if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                this.log("done");
                                return;
                            }
                            int consumed = res.bytesConsumed();
                            int produced = res.bytesProduced();
                            if (produced > 0) {
                                this.log("rawwrite:" + produced);
                                byte[] out = new byte[produced];
                                this.outtransfer.flip();
                                if (this.outtransfer.remaining() != produced) {
                                    throw new Exception("transfer.remaining() != produced");
                                }
                                this.outtransfer.get(out);
                                SRTPChannelJ9.super.writeRTP(out, 0, out.length);
                            }
                            this.outtransfer.compact();
                            this.output.compact();
                            break;
                        }
                        case NEED_UNWRAP: {
                            byte[] data;
                            ArrayList<byte[]> arrayList = SRTPChannelJ9.this.data_input;
                            synchronized (arrayList) {
                                if (SRTPChannelJ9.this.data_input.size() == 0) {
                                    break;
                                }
                                data = SRTPChannelJ9.this.data_input.remove(0);
                            }
                            int length = data.length;
                            if (length > 0) {
                                this.log("rawread:" + length);
                                this.intransfer.put(data, 0, length);
                            }
                            this.intransfer.flip();
                            SSLEngineResult res = this.ssl.unwrap(this.intransfer, this.input);
                            if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                this.log("done");
                                return;
                            }
                            int consumed = res.bytesConsumed();
                            int produced = res.bytesProduced();
                            this.intransfer.compact();
                            this.input.compact();
                            break;
                        }
                        case NEED_UNWRAP_AGAIN: {
                            this.intransfer.limit(0);
                            SSLEngineResult res = this.ssl.unwrap(this.intransfer, this.input);
                            if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                this.log("done");
                                return;
                            }
                            int consumed = res.bytesConsumed();
                            int produced = res.bytesProduced();
                            this.intransfer.compact();
                            this.input.compact();
                        }
                    }
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                return;
            }
        }
    }
}

