/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

public class Camera {
    private long ctx = 0L;
    private int[] mirror;

    private native long cameraInit();

    private native boolean cameraUninit(long var1);

    private native String[] cameraListDevices(long var1);

    private native String[] cameraListModes(long var1, int var3);

    private native boolean cameraStart(long var1, int var3, int var4, int var5);

    private native boolean cameraStop(long var1);

    private native int[] cameraGetFrame(long var1);

    private native int cameraGetWidth(long var1);

    private native int cameraGetHeight(long var1);

    public boolean init() {
        this.ctx = this.cameraInit();
        return this.ctx != 0L;
    }

    public boolean uninit() {
        return this.cameraUninit(this.ctx);
    }

    public String[] listDevices() {
        return this.cameraListDevices(this.ctx);
    }

    public String[] listModes(int deviceIdx) {
        return this.cameraListModes(this.ctx, deviceIdx);
    }

    public boolean start(int deviceIdx, int width, int height) {
        return this.cameraStart(this.ctx, deviceIdx, width, height);
    }

    public boolean stop() {
        return this.cameraStop(this.ctx);
    }

    public int[] getFrame() {
        return this.cameraGetFrame(this.ctx);
    }

    public int[] getFrameMirror() {
        int[] px = this.cameraGetFrame(this.ctx);
        if (px == null) {
            return null;
        }
        if (this.mirror == null || this.mirror.length != px.length) {
            this.mirror = new int[px.length];
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int src = 0;
        int dst = 0;
        for (int y = 0; y < height; ++y) {
            src += width;
            for (int x = 0; x < width; ++x) {
                this.mirror[dst++] = px[--src];
            }
            src += width;
        }
        return this.mirror;
    }

    public int getWidth() {
        return this.cameraGetWidth(this.ctx);
    }

    public int getHeight() {
        return this.cameraGetHeight(this.ctx);
    }
}

