package javaforce.media;

/** AudioGenerate
 *
 * Generated by ChatGPT
 *
 * @author pquiring
 */

public class AudioGenerate {
  private double phaseOffset;
  private static final double TWO_PI = 2 * Math.PI;

  public static final int SINE = 1;
  public static final int SQUARE = 2;
  public static final int SAW = 3;

  /** Generate sound wave.
   *
   * @param out = output
   * @param type = wave type
   * @param sampleRate = sample rate (44100, etc.)
   * @param frequency = frequency of wave
   * @param amplitude = amplitude (0.0 to 1.0)
   */
  public void generate(short[] out, int type, int sampleRate, int frequency, float amplitude) {
    switch (type) {
      case SINE: generate_sine(out, sampleRate, frequency, amplitude); break;
      case SQUARE: generate_square(out, sampleRate, frequency, amplitude); break;
      case SAW: generate_saw(out, sampleRate, frequency, amplitude); break;
    }
  }

  /**
   * Resets the phase offset to zero.
   */
  public void reset() {
    phaseOffset = 0.0;
  }

  private void generate_sine(short[] out, double rate, double frequency, double amplitude) {
    int len = out.length;

    double phaseIncrement = TWO_PI * frequency / rate;

    for(int i=0;i<len;i++) {
      out[i] = (short)((amplitude * Math.sin(phaseOffset)) * Short.MAX_VALUE);
      phaseOffset += phaseIncrement;
      if (phaseOffset >= TWO_PI) {
        phaseOffset -= TWO_PI;
      }
    }
  }

  private void generate_square(short[] out, double rate, double frequency, double amplitude) {
    int len = out.length;

    double phaseIncrement = TWO_PI * frequency / rate;

    for(int i=0;i<len;i++) {
      out[i] = (short)((Math.sin(phaseOffset) >= 0 ? amplitude : -amplitude) * Short.MAX_VALUE);
      phaseOffset += phaseIncrement;
      if (phaseOffset >= TWO_PI) {
        phaseOffset -= TWO_PI;
      }
    }
  }

  private void generate_saw(short[] out, double rate, double frequency, double amplitude) {
    int len = out.length;

    double phaseIncrement = TWO_PI * frequency / rate;

    for(int i=0;i<len;i++) {
      out[i] = (short)((amplitude * (2.0 * (phaseOffset - Math.floor(phaseOffset + 0.5)))) * Short.MAX_VALUE);
      phaseOffset += phaseIncrement;
      if (phaseOffset >= TWO_PI) {
        phaseOffset -= TWO_PI;
      }
    }
  }
}
