/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFImage;
import javaforce.awt.RFB;
import javaforce.awt.VNCRobot;
import javaforce.webui.Button;
import javaforce.webui.Canvas;
import javaforce.webui.Component;
import javaforce.webui.LoginPanel;
import javaforce.webui.Panel;
import javaforce.webui.Point;
import javaforce.webui.ToolBar;
import javaforce.webui.WebUIClient;
import javaforce.webui.event.Resized;

public class VNCWebConsole
extends Thread
implements Resized {
    private int vnc_port;
    private String vnc_password;
    private int opts;
    private Panel panel;
    private ToolBar tools;
    private Canvas canvas;
    private RFB rfb;
    private WebUIClient client;
    private static final boolean debug = false;
    private static final boolean debugKeys = false;
    public static final int OPT_TOOLBAR = 1;
    public static final int OPT_SCALE = 2;
    private boolean init_scaled;
    private boolean scaled;

    public VNCWebConsole(int vnc_port, String password, int opts, Canvas canvas) {
        this.vnc_port = vnc_port;
        this.vnc_password = password;
        this.opts = opts;
        this.canvas = canvas;
    }

    private static Panel createLoginPanel(int vnc_port, int opts, WebUIClient client) {
        return new LoginPanel("VNCWeb", false, (user, pass) -> {
            Panel panel = VNCWebConsole.createPanel(vnc_port, pass, opts, client);
            client.setPanel(panel);
            return true;
        });
    }

    public static Panel createPanel(int vnc_port, String password, int opts, WebUIClient client) {
        if (password == null) {
            return VNCWebConsole.createLoginPanel(vnc_port, opts, client);
        }
        boolean opt_toolbar = (opts & 1) != 0;
        boolean opt_scale = (opts & 2) != 0;
        Panel panel = new Panel();
        Canvas canvas = new Canvas();
        canvas.setSize(0, 0);
        VNCWebConsole console = new VNCWebConsole(vnc_port, password, opts, canvas);
        console.panel = panel;
        canvas.addResizedListener(console);
        panel.addResizedListener(console);
        panel.requestSize();
        canvas.settransformorigin(0.0f, 0.0f);
        if (opt_toolbar) {
            ToolBar tools;
            console.tools = tools = new ToolBar();
            panel.add(tools);
            Button refresh = new Button("Refresh");
            tools.add(refresh);
            Button cad = new Button("C+A+D");
            tools.add(cad);
            Button winkey = new Button("WinKey");
            tools.add(winkey);
            Button scale = new Button("Scale");
            tools.add(scale);
            refresh.addClickListener((me, cmp) -> console.refresh());
            cad.addClickListener((me, cmp) -> console.cad());
            winkey.addClickListener((me, cmp) -> console.winkey());
            scale.addClickListener((me, cmp) -> console.scale());
            tools.addResizedListener(console);
            tools.requestSize();
        }
        panel.add(canvas);
        canvas.addMouseDownListener((me, cmp) -> {
            console.mouse(me.x, me.y, me.buttons);
            canvas.setFocus();
        });
        canvas.addMouseUpListener((me, cmp) -> console.mouse(me.x, me.y, me.buttons));
        canvas.addMouseMoveListener((me, cmp) -> console.mouse(me.x, me.y, me.buttons));
        canvas.addKeyDownListenerPreventDefault((ke, cmp) -> {
            if (ke.keyChar != '\u0000') {
                console.keyDown(ke.keyChar, false);
            } else {
                console.keyDown(ke.keyCode, true);
            }
        });
        canvas.addKeyUpListenerPreventDefault((ke, cmp) -> {
            if (ke.keyChar != '\u0000') {
                console.keyUp(ke.keyChar, false);
            } else {
                console.keyUp(ke.keyCode, true);
            }
        });
        if (opt_scale) {
            console.init_scaled = true;
        }
        console.start();
        return panel;
    }

    private boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public void run() {
        this.client = this.canvas.getClient();
        while (this.isConnected()) {
            this.rfb = new RFB();
            if (!this.rfb.connect("127.0.0.1", this.vnc_port)) {
                JFLog.log("VNCWeb:connection failed");
                JF.sleep(1000);
                continue;
            }
            float server_version = this.rfb.readVersion();
            this.rfb.writeVersion(RFB.VERSION_3_8);
            byte[] auths = this.rfb.readAuthTypes();
            if (auths == null || auths.length == 0) {
                JFLog.log("VNCWeb:No auth types available");
                return;
            }
            this.rfb.writeAuthType(auths[0]);
            boolean ok = false;
            switch (auths[0]) {
                case 0: {
                    break;
                }
                case 1: {
                    ok = true;
                    break;
                }
                case 2: {
                    byte[] challenge = this.rfb.readAuthChallenge();
                    byte[] response = RFB.encodeResponse(challenge, this.vnc_password.getBytes());
                    this.rfb.writeAuthResponse(response);
                    ok = this.rfb.readAuthResult();
                }
            }
            if (!ok) {
                JFLog.log("VNCWeb:auth failed");
                this.client.setPanel(VNCWebConsole.createLoginPanel(this.vnc_port, this.opts, this.client));
                return;
            }
            this.rfb.writeClientInit(true);
            if (!this.rfb.readServerInit()) {
                JFLog.log("VNCWeb:server init failed");
                JF.sleep(1000);
                continue;
            }
            int width = this.rfb.getWidth();
            int height = this.rfb.getHeight();
            this.canvas.setSize(width, height);
            this.canvas.setFocus();
            if (this.init_scaled) {
                this.scale();
                this.init_scaled = false;
            }
            this.main();
            this.rfb.disconnect();
        }
    }

    public void refresh() {
        int width = this.rfb.getWidth();
        int height = this.rfb.getHeight();
        this.rfb.writeBufferUpdateRequest(0, 0, width, height, false);
    }

    public void cad() {
        this.keyDown(17, true);
        this.keyDown(18, true);
        JF.sleep(10);
        this.keyDown(127, true);
        JF.sleep(50);
        this.keyUp(127, true);
        JF.sleep(10);
        this.keyUp(18, true);
        this.keyUp(17, true);
    }

    public void winkey() {
        this.keyDown(17, true);
        JF.sleep(10);
        this.keyDown(27, true);
        JF.sleep(50);
        this.keyUp(27, true);
        JF.sleep(10);
        this.keyUp(17, true);
    }

    public void scale() {
        if (this.scaled) {
            this.scaled = false;
            this.canvas.setscale(1.0f, 1.0f);
        } else {
            this.scaled = true;
            this.canvas.requestSize();
        }
    }

    @Override
    public void onResized(Component cmp, int width, int height) {
        if (!this.scaled) {
            return;
        }
        if (cmp != this.canvas) {
            return;
        }
        if (width == 0 || height == 0) {
            return;
        }
        float panel_width = this.panel.getWidth();
        float panel_height = this.panel.getHeight();
        if (panel_width == 0.0f || panel_height == 0.0f) {
            JFLog.log("VNCWeb:scale:panel size not known yet");
            return;
        }
        if (this.tools != null) {
            float tools_height = this.tools.getHeight();
            if (tools_height == 0.0f) {
                JFLog.log("VNCWeb:scale:tools size not known yet");
                return;
            }
            panel_height -= tools_height;
        }
        float canvas_width = width;
        float canvas_height = height;
        float scale_width = panel_width / canvas_width;
        float scale_height = panel_height / canvas_height;
        this.canvas.setscale(scale_width, scale_height);
    }

    public void mouse(int x, int y, int buttons) {
        if (this.rfb == null || !this.rfb.isConnected()) {
            return;
        }
        boolean b1 = (buttons & 1) != 0;
        boolean b2 = (buttons & 2) != 0;
        boolean b3 = (buttons & 4) != 0;
        buttons = 0;
        if (b1) {
            buttons |= 1;
        }
        if (b3) {
            buttons |= 2;
        }
        if (b2) {
            buttons |= 4;
        }
        this.rfb.writeMouseEvent(x, y, buttons);
    }

    public void keyDown(int code, boolean convert) {
        if (this.rfb == null || !this.rfb.isConnected()) {
            return;
        }
        if (convert) {
            code = VNCRobot.convertJavaKeyCode(code);
        }
        this.rfb.writeKeyEvent(code, true);
    }

    public void keyUp(int code, boolean convert) {
        if (this.rfb == null || !this.rfb.isConnected()) {
            return;
        }
        if (convert) {
            code = VNCRobot.convertJavaKeyCode(code);
        }
        this.rfb.writeKeyEvent(code, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void main() {
        this.rfb.writeEncodingsFast();
        this.rfb.writePixelFormat();
        int width = this.rfb.getWidth();
        int height = this.rfb.getHeight();
        this.rfb.writeBufferUpdateRequest(0, 0, width, height, false);
        try {
            block11: while (this.isConnected() && this.rfb.isConnected()) {
                int msg = this.rfb.readMessageType();
                switch (msg) {
                    case -1: {
                        JFLog.log("VNCWeb:Connection closed");
                        return;
                    }
                    case 0: {
                        RFB.Rectangle rect = this.rfb.readBufferUpdate();
                        int width2 = this.rfb.getWidth();
                        int height2 = this.rfb.getHeight();
                        if (rect.newSize) {
                            this.canvas.setSize(width2, height2);
                            this.rfb.writeBufferUpdateRequest(0, 0, width2, height2, false);
                            continue block11;
                        }
                        JFImage image = this.rfb.getImage(rect);
                        this.rfb.writeBufferUpdateRequest(0, 0, width2, height2, true);
                        this.canvas.drawImage(image, new Point(rect.x, rect.y));
                        continue block11;
                    }
                    case 2: {
                        this.rfb.readBell();
                        continue block11;
                    }
                    case 1: {
                        this.rfb.readColorMap();
                        continue block11;
                    }
                    case 3: {
                        this.rfb.readCutText();
                        continue block11;
                    }
                }
                JFLog.log("VNCWeb:Unknown msg:" + msg);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        try {
            this.rfb.disconnect();
            return;
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

