/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl.model;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LE;
import javaforce.gl.Model;
import javaforce.gl.Object3;
import javaforce.gl.Rotate3;
import javaforce.gl.Scale3;
import javaforce.gl.Translate3;
import javaforce.gl.UVMap;
import javaforce.gl.model.Model_IO;

public class Model3DS
implements Model_IO {
    private static final int _3DS_FLG_TENSION = 1;
    private static final int _3DS_FLG_CONTINUITY = 2;
    private static final int _3DS_FLG_BIAS = 4;
    private static final int _3DS_FLG_EASE_TO = 8;
    private static final int _3DS_FLG_EASE_FROM = 16;
    public byte[] data;
    public int datapos;
    public static boolean debug = false;

    public Model load(String filename) {
        try {
            FileInputStream is = new FileInputStream(filename);
            Model model = this.load3ds(is);
            ((InputStream)is).close();
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Model load(InputStream is) {
        try {
            return this.load3ds(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean eof() {
        return this.datapos >= this.data.length;
    }

    private int readuint16() {
        int uint16 = LE.getuint16(this.data, this.datapos);
        this.datapos += 2;
        return uint16;
    }

    private int readuint32() {
        int uint32 = LE.getuint32(this.data, this.datapos);
        this.datapos += 4;
        return uint32;
    }

    private float readfloat() {
        return Float.intBitsToFloat(this.readuint32());
    }

    private Model load3ds(InputStream is) throws Exception {
        int a;
        int _siz;
        Object3 obj = null;
        boolean off = false;
        boolean done_vertex = false;
        boolean done_pts = false;
        int vertexidx = -1;
        int vertexcnt = -1;
        String objname = "";
        int objidx = -1;
        String matname = "";
        int mapidx = -1;
        int skip = 0;
        this.datapos = 0;
        this.data = JF.readAll(is);
        ArrayList<material> matlist = new ArrayList<material>();
        ArrayList<String> objlist = new ArrayList<String>();
        Model mod = new Model();
        while (!this.eof()) {
            int head_id = this.readuint16();
            int head_len = this.readuint32();
            if (head_len == -1) break;
            if (head_len < 6) {
                throw new Exception("head_len < 6 (" + head_len + ")");
            }
            head_len -= 6;
            switch (head_id) {
                case 19789: {
                    break;
                }
                case 15677: {
                    break;
                }
                case 45055: {
                    matname = "";
                    break;
                }
                case 40960: {
                    matname = this.readname(head_len);
                    break;
                }
                case 41472: {
                    break;
                }
                case 41728: {
                    material mat = new material();
                    String fn = this.readname(head_len);
                    mat.name = matname;
                    mat.filename = fn;
                    matlist.add(mat);
                    break;
                }
                case 16384: {
                    objname = this.readname(-1);
                    if (debug) {
                        JFLog.log("obj=" + objname);
                    }
                    done_vertex = false;
                    done_pts = false;
                    break;
                }
                case 16640: {
                    break;
                }
                case 16656: {
                    int b;
                    skip = head_len;
                    if (done_vertex) {
                        JFLog.log("Warning : 2 vertex lists found for 1 object?");
                        break;
                    }
                    obj = new Object3();
                    obj.type = 4;
                    obj.name = objname;
                    mapidx = -1;
                    mod.ol.add(obj);
                    objlist.add(objname);
                    _siz = this.readuint16();
                    skip -= 2;
                    vertexidx = obj.vpl.size();
                    vertexcnt = _siz;
                    if (_siz == 0) break;
                    float[] _float = new float[_siz * 3];
                    for (a = 0; a < _siz; ++a) {
                        for (b = 0; b < 3; ++b) {
                            _float[a * 3 + b] = this.readfloat();
                            skip -= 4;
                        }
                        if (!debug) continue;
                        JFLog.log(String.format("v=%3.3f,%3.3f,%3.3f", Float.valueOf(_float[a * 3 + 0]), Float.valueOf(_float[a * 3 + 1]), Float.valueOf(_float[a * 3 + 2])));
                    }
                    obj.addVertex(_float);
                    _float = null;
                    done_vertex = true;
                    break;
                }
                case 16672: {
                    int b;
                    _siz = this.readuint16();
                    skip = _siz * 2 * 4;
                    if (!done_vertex) {
                        JFLog.log("Warning : pts list before vertex list?");
                        break;
                    }
                    if (done_pts) {
                        JFLog.log("Warning : 2 pts lists found for 1 object?");
                        break;
                    }
                    if (_siz == 0) break;
                    int[] _pts = new int[3];
                    for (a = 0; a < _siz; ++a) {
                        for (b = 0; b < 3; ++b) {
                            _pts[b] = (short)this.readuint16();
                            skip -= 2;
                        }
                        this.readuint16();
                        skip -= 2;
                        obj.addPoly(_pts);
                        if (!debug) continue;
                        JFLog.log("p=" + _pts[0] + "," + _pts[1] + "," + _pts[2]);
                    }
                    _pts = null;
                    done_pts = true;
                    break;
                }
                case 16688: {
                    boolean ok;
                    String name = this.readname(head_len);
                    UVMap map = obj.createUVMap();
                    map.name = "uvmap" + ++mapidx;
                    if (obj != null) {
                        ok = false;
                        for (a = 0; a < matlist.size(); ++a) {
                            int idx;
                            if (!((material)matlist.get((int)a)).name.equals(name)) continue;
                            map.textureIndex = idx = mod.addTexture(((material)matlist.get((int)a)).filename);
                            ok = true;
                            break;
                        }
                    }
                    if (!debug) break;
                    JFLog.log("mat=" + map.textureIndex);
                    break;
                }
                case 16704: {
                    _siz = this.readuint16();
                    skip = _siz * 2 * 4;
                    if (!done_vertex) {
                        JFLog.log("Warning:Texture coords (UV) list before vertex list");
                        break;
                    }
                    if (_siz != vertexcnt) {
                        JFLog.log("Warning:texture list siz != vertex list siz");
                        break;
                    }
                    if (_siz == 0) break;
                    float[] _float = new float[2];
                    for (a = 0; a < _siz; ++a) {
                        _float[0] = this.readfloat();
                        skip -= 4;
                        _float[1] = 1.0f - this.readfloat();
                        skip -= 4;
                        obj.addText(_float, mapidx);
                        if (!debug) continue;
                        JFLog.log(String.format("t=%3.3f,%3.3f", Float.valueOf(_float[0]), Float.valueOf(_float[1])));
                    }
                    _float = null;
                    break;
                }
                case 16736: {
                    int u32;
                    int s = 0;
                    for (a = 0; a < 9; ++a) {
                        u32 = this.readuint32();
                        if (a <= 0 || a % 3 != 0) continue;
                        ++s;
                    }
                    obj.org.x = this.readfloat();
                    obj.org.y = this.readfloat();
                    obj.org.z = this.readfloat();
                    if (!debug) break;
                    JFLog.log("pos=" + obj.org.x + "," + obj.org.y + "," + obj.org.z);
                    break;
                }
                case 45056: {
                    break;
                }
                case 45058: {
                    objidx = -1;
                    break;
                }
                case 45072: {
                    String name = this.readname(-1);
                    this.readuint16();
                    this.readuint16();
                    int parent = this.readuint16();
                    objidx = 0;
                    boolean ok = false;
                    for (a = 0; a < objlist.size(); ++a) {
                        if (((String)objlist.get(a)).equals(name)) {
                            ok = true;
                            break;
                        }
                        ++objidx;
                    }
                    if (!ok) {
                        objidx = -1;
                        break;
                    }
                    obj = mod.ol.get(objidx);
                    if (parent != 65535) {
                        obj.parent = parent;
                    }
                    obj = null;
                    break;
                }
                case 45088: {
                    int frameno;
                    int b;
                    skip = head_len;
                    if (objidx == -1) break;
                    obj = mod.ol.get(objidx);
                    int u16 = this.readuint16();
                    skip -= 2;
                    int u32 = this.readuint32();
                    skip -= 4;
                    u32 = this.readuint32();
                    skip -= 4;
                    int keys = this.readuint32();
                    skip -= 4;
                    float[] _float = new float[3];
                    for (a = 0; a < keys; ++a) {
                        frameno = this.readuint32();
                        skip -= 4;
                        u16 = this.readuint16();
                        skip -= 2;
                        u32 = 0;
                        if ((u16 & 1) != 0) {
                            ++u32;
                        }
                        if ((u16 & 2) != 0) {
                            ++u32;
                        }
                        if ((u16 & 4) != 0) {
                            ++u32;
                        }
                        if ((u16 & 8) != 0) {
                            ++u32;
                        }
                        if ((u16 & 0x10) != 0) {
                            ++u32;
                        }
                        if (u32 > 0) {
                            this.datapos += u32 * 4;
                            skip -= u32 * 4;
                        }
                        Translate3 trans = new Translate3();
                        for (b = 0; b < 3; ++b) {
                            _float[b] = this.readfloat();
                            skip -= 4;
                        }
                        trans.x = _float[0];
                        trans.y = _float[1];
                        trans.z = _float[2];
                        obj.tl.put(frameno, trans);
                        if (obj.maxframeCount >= frameno) continue;
                        obj.maxframeCount = frameno;
                    }
                    _float = null;
                    obj = null;
                    break;
                }
                case 45089: {
                    int frameno;
                    int b;
                    skip = head_len;
                    if (objidx == -1) break;
                    obj = mod.ol.get(objidx);
                    int u16 = this.readuint16();
                    skip -= 2;
                    int u32 = this.readuint32();
                    skip -= 4;
                    u32 = this.readuint32();
                    skip -= 4;
                    int keys = this.readuint32();
                    skip -= 4;
                    float[] _float = new float[4];
                    for (a = 0; a < keys; ++a) {
                        frameno = this.readuint32();
                        skip -= 4;
                        u16 = this.readuint16();
                        skip -= 2;
                        u32 = 0;
                        if ((u16 & 1) != 0) {
                            ++u32;
                        }
                        if ((u16 & 2) != 0) {
                            ++u32;
                        }
                        if ((u16 & 4) != 0) {
                            ++u32;
                        }
                        if ((u16 & 8) != 0) {
                            ++u32;
                        }
                        if ((u16 & 0x10) != 0) {
                            ++u32;
                        }
                        if (u32 > 0) {
                            this.datapos += u32 * 4;
                            skip -= u32 * 4;
                        }
                        Rotate3 rot = new Rotate3();
                        for (b = 0; b < 4; ++b) {
                            _float[b] = this.readfloat();
                            skip -= 4;
                        }
                        rot.angle = _float[0] * 57.29578f;
                        rot.x = _float[1];
                        rot.y = _float[2];
                        rot.z = _float[3];
                        obj.rl.put(frameno, rot);
                        if (obj.maxframeCount >= frameno) continue;
                        obj.maxframeCount = frameno;
                    }
                    _float = null;
                    obj = null;
                    break;
                }
                case 45090: {
                    int frameno;
                    int b;
                    skip = head_len;
                    if (objidx == -1) break;
                    obj = mod.ol.get(objidx);
                    int u16 = this.readuint16();
                    skip -= 2;
                    int u32 = this.readuint32();
                    skip -= 4;
                    u32 = this.readuint32();
                    skip -= 4;
                    int keys = this.readuint32();
                    skip -= 4;
                    float[] _float = new float[3];
                    for (a = 0; a < keys; ++a) {
                        frameno = this.readuint32();
                        skip -= 4;
                        u16 = this.readuint16();
                        skip -= 2;
                        u32 = 0;
                        if ((u16 & 1) != 0) {
                            ++u32;
                        }
                        if ((u16 & 2) != 0) {
                            ++u32;
                        }
                        if ((u16 & 4) != 0) {
                            ++u32;
                        }
                        if ((u16 & 8) != 0) {
                            ++u32;
                        }
                        if ((u16 & 0x10) != 0) {
                            ++u32;
                        }
                        if (u32 > 0) {
                            this.datapos += u32 * 4;
                            skip -= u32 * 4;
                        }
                        Scale3 scale = new Scale3();
                        for (b = 0; b < 3; ++b) {
                            _float[b] = this.readfloat();
                            skip -= 4;
                        }
                        scale.x = _float[0];
                        scale.y = _float[1];
                        scale.z = _float[2];
                        obj.sl.put(frameno, scale);
                        if (obj.maxframeCount >= frameno) continue;
                        obj.maxframeCount = frameno;
                    }
                    _float = null;
                    obj = null;
                    break;
                }
                default: {
                    skip = head_len;
                }
            }
            if (skip <= 0) continue;
            this.datapos += skip;
            skip = 0;
        }
        _siz = mod.ol.size();
        for (a = 0; a < _siz; ++a) {
            obj = mod.ol.get(a);
        }
        matlist.clear();
        objlist.clear();
        return mod;
    }

    private String readname(int maxread) {
        Object ret = "";
        while (!this.eof()) {
            char ch = (char)this.data[this.datapos++];
            if (maxread != -1 && --maxread == 0 || ch == '\u0000') break;
            ret = (String)ret + ch;
        }
        if (maxread > 0) {
            this.datapos += maxread;
        }
        return ret;
    }

    @Override
    public boolean save(Model model, OutputStream os) {
        return false;
    }

    private static class material {
        String name;
        String filename;

        private material() {
        }
    }
}

