/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.SOCKS;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javaforce.net.IP4;
import javaforce.net.IP4Port;
import javaforce.net.Subnet4;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;

public class SOCKSServer {
    public static final String busPack = "net.sf.jfsocks";
    public static boolean debug = false;
    private ServerSocket ss;
    private Server server;
    private ArrayList<SocksWorker> socks_workers = new ArrayList();
    private ArrayList<ForwardLocalWorker> forward_local_workers = new ArrayList();
    private ArrayList<ForwardRemoteWorker> forward_remote_workers = new ArrayList();
    private Object lock = new Object();
    private boolean socks4 = true;
    private boolean socks5 = false;
    private boolean socks_bind = false;
    private int socks_bind_timeout = 3600000;
    private int forward_remote_timeout = 300000;
    private IP4Port bind = new IP4Port();
    private IP4Port bind_cmd = new IP4Port();
    private boolean secure = false;
    private boolean secure_verify = false;
    private ArrayList<String> user_pass_list;
    private ArrayList<Subnet4> subnet_dest_list;
    private ArrayList<Subnet4> subnet_src_list;
    private ArrayList<ForwardLocal> forward_local_list;
    private ArrayList<ForwardRemote> forward_remote_list;
    private KeyMgmt keys = new KeyMgmt();
    private static final String defaultConfig = "[global]\nport=1080\n#bind=192.168.100.2\n#bindcmd=192.168.110.2\nsecure=false\n#secure.verify=false\nsocks4=true\nsocks5=false\nsocks.bind=false\n#socks.bind.timeout=3600000\n#auth=user:pass\n#src.ipnet=192.168.2.0/255.255.255.0\n#src.ip=192.168.3.2\n#dest.ipnet=192.168.0.0/255.255.255.0\n#dest.ip=192.168.1.6\n#forwardlocal=192.168.100.2:80,192.168.200.2:80\n#forwardremote=[user:pass@]192.168.110.2:1080,0.0.0.0,80,192.168.200.2:80[,true]\n#forwardremote.timeout=300000\n";
    private static SOCKSServer socks;
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfsocks.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfsocks.log";
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33008;
        }
        return 777;
    }

    public SOCKSServer() {
    }

    public SOCKSServer(int port, boolean secure) {
        this.bind.port = port;
        this.secure = secure;
    }

    private boolean log(Exception e) {
        if (e instanceof SocketException) {
            JFLog.log("Connection lost (SocketException)");
            return false;
        }
        if (e instanceof SSLException) {
            JFLog.log("Connection lost (SSLException)");
            return false;
        }
        JFLog.log(e);
        return true;
    }

    public void addUserPass(String user, String pass) {
        String user_pass = user + ":" + pass;
        this.user_pass_list.add(user_pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(SocksWorker sess) {
        Object object = this.lock;
        synchronized (object) {
            this.socks_workers.add(sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(SocksWorker sess) {
        Object object = this.lock;
        synchronized (object) {
            this.socks_workers.remove(sess);
        }
    }

    public static String getKeyFile() {
        return JF.getConfigPath() + "/jfsocks.key";
    }

    public void start() {
        this.stop();
        this.server = new Server();
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.server == null) {
            return;
        }
        this.server.active = false;
        try {
            this.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.lock;
        synchronized (object) {
            ForwardRemoteWorker[] remotes;
            ForwardLocalWorker[] locals;
            SocksWorker[] socks;
            for (SocksWorker s : socks = this.socks_workers.toArray(new SocksWorker[0])) {
                s.close();
            }
            this.socks_workers.clear();
            for (ForwardLocalWorker f : locals = this.forward_local_workers.toArray(new ForwardLocalWorker[0])) {
                f.close();
            }
            this.forward_local_workers.clear();
            for (ForwardRemoteWorker f : remotes = this.forward_remote_workers.toArray(new ForwardRemoteWorker[0])) {
                f.close();
            }
            this.forward_remote_workers.clear();
        }
        this.server = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfig() {
        JFLog.log("loadConfig");
        this.user_pass_list = new ArrayList();
        this.subnet_src_list = new ArrayList();
        this.subnet_dest_list = new ArrayList();
        this.forward_local_list = new ArrayList();
        this.forward_remote_list = new ArrayList();
        Section section = Section.None;
        this.bind.setIP("0.0.0.0");
        this.bind.port = 1080;
        try {
            BufferedReader br = new BufferedReader(new FileReader(SOCKSServer.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            block52: while (true) {
                String ln;
                if ((ln = br.readLine()) == null) {
                    br.close();
                    this.config = cfg.toString();
                    return;
                }
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                int idx = ln.indexOf("=");
                if (idx == -1) continue;
                String key = ln.substring(0, idx);
                String value = ln.substring(idx + 1);
                switch (section.ordinal()) {
                    case 0: 
                    case 1: {
                        switch (key) {
                            case "port": {
                                this.bind.port = Integer.valueOf(ln.substring(5));
                                break;
                            }
                            case "bind": {
                                if (this.bind.setIP(value)) break;
                                JFLog.log("SOCKS:bind:Invalid IP:" + value);
                                break;
                            }
                            case "bindcmd": {
                                if (this.bind_cmd.setIP(value)) break;
                                JFLog.log("SOCKS:bindcmd:Invalid IP:" + value);
                                break;
                            }
                            case "secure": {
                                this.secure = value.equals("true");
                                break;
                            }
                            case "secure.verify": {
                                this.secure_verify = value.equals("true");
                                break;
                            }
                            case "socks4": {
                                this.socks4 = value.equals("true");
                                break;
                            }
                            case "socks5": {
                                this.socks5 = value.equals("true");
                                break;
                            }
                            case "socks.bind": {
                                this.socks_bind = value.equals("true");
                                break;
                            }
                            case "socks.bind.timeout": {
                                this.socks_bind_timeout = Integer.valueOf(value);
                                if (this.socks_bind_timeout < 60000) {
                                    this.socks_bind_timeout = 60000;
                                }
                                if (this.socks_bind_timeout <= 86400000) break;
                                this.socks_bind_timeout = 86400000;
                                break;
                            }
                            case "forward.remote.wait": 
                            case "forwardremote.timeout": {
                                this.forward_remote_timeout = Integer.valueOf(value);
                                if (this.forward_remote_timeout < 60000) {
                                    this.forward_remote_timeout = 60000;
                                }
                                if (this.forward_remote_timeout <= 86400000) break;
                                this.forward_remote_timeout = 86400000;
                                break;
                            }
                            case "auth": {
                                this.user_pass_list.add(value);
                                break;
                            }
                            case "ipnet": 
                            case "dest.ipnet": {
                                Subnet4 subnet = new Subnet4();
                                idx = value.indexOf(47);
                                if (idx == -1) {
                                    JFLog.log("SOCKS:Invalid IP Subnet:" + value);
                                    break;
                                }
                                String ip = value.substring(0, idx);
                                String mask = value.substring(idx + 1);
                                if (!subnet.setIP(ip)) {
                                    JFLog.log("SOCKS:Invalid IP:" + ip);
                                    break;
                                }
                                if (!subnet.setMask(mask)) {
                                    JFLog.log("SOCKS:Invalid netmask:" + mask);
                                    break;
                                }
                                JFLog.log("Dest Allow IP Network=" + subnet.toString());
                                this.subnet_dest_list.add(subnet);
                                break;
                            }
                            case "ip": 
                            case "dest.ip": {
                                Subnet4 subnet = new Subnet4();
                                if (!subnet.setIP(value)) {
                                    JFLog.log("SOCKS:Invalid IP:" + value);
                                    break;
                                }
                                subnet.setMask("255.255.255.255");
                                JFLog.log("Dest Allow IP Address=" + subnet.toString());
                                this.subnet_dest_list.add(subnet);
                                break;
                            }
                            case "src.ipnet": {
                                Subnet4 subnet = new Subnet4();
                                idx = value.indexOf(47);
                                if (idx == -1) {
                                    JFLog.log("SOCKS:Invalid IP Subnet:" + value);
                                    break;
                                }
                                String ip = value.substring(0, idx);
                                String mask = value.substring(idx + 1);
                                if (!subnet.setIP(ip)) {
                                    JFLog.log("SOCKS:Invalid IP:" + ip);
                                    break;
                                }
                                if (!subnet.setMask(mask)) {
                                    JFLog.log("SOCKS:Invalid netmask:" + mask);
                                    break;
                                }
                                JFLog.log("Source Allow IP Network=" + subnet.toString());
                                this.subnet_src_list.add(subnet);
                                break;
                            }
                            case "src.ip": {
                                Subnet4 subnet = new Subnet4();
                                if (!subnet.setIP(value)) {
                                    JFLog.log("SOCKS:Invalid IP:" + value);
                                    break;
                                }
                                subnet.setMask("255.255.255.255");
                                JFLog.log("Source Allow IP Address=" + subnet.toString());
                                this.subnet_src_list.add(subnet);
                                break;
                            }
                            case "forward": 
                            case "forwardlocal": {
                                String[] p = value.split(",");
                                if (p.length != 2) {
                                    JFLog.log(key + ":Invalid option:" + value);
                                    break;
                                }
                                Object forward = new ForwardLocal();
                                if (!((ForwardLocal)forward).set_from(p[0])) {
                                    JFLog.log(key + ":Invalid from:" + p[0]);
                                    break;
                                }
                                if (!((ForwardLocal)forward).set_to(p[1])) {
                                    JFLog.log(key + ":Invalid to:" + p[1]);
                                    break;
                                }
                                this.forward_local_list.add((ForwardLocal)forward);
                                break;
                            }
                            case "forwardremote": {
                                String[] p = value.split(",");
                                if (p.length < 4) {
                                    JFLog.log("bindforward:Invalid option:" + value);
                                    break;
                                }
                                Object forward = new ForwardRemote();
                                String bind = p[0];
                                int atidx = bind.indexOf(64);
                                if (atidx != -1) {
                                    String user_pass = bind.substring(0, atidx);
                                    bind = bind.substring(atidx + 1);
                                    int colonidx = user_pass.indexOf(58);
                                    if (colonidx != -1) {
                                        ((ForwardRemote)forward).user = user_pass.substring(0, colonidx);
                                        ((ForwardRemote)forward).pass = user_pass.substring(colonidx + 1);
                                    }
                                }
                                if (!((ForwardRemote)forward).set_socks(bind)) {
                                    JFLog.log("bindforward:Invalid bind address:" + p[0]);
                                    break;
                                }
                                ((ForwardRemote)forward).set_from(p[1]);
                                ((ForwardRemote)forward).set_port(Integer.valueOf(p[2]));
                                if (!((ForwardRemote)forward).set_to(p[3])) {
                                    JFLog.log("bindforward:Invalid to:" + p[3]);
                                    break;
                                }
                                if (p.length > 4) {
                                    ((ForwardRemote)forward).secure = p[4].equals("true");
                                }
                                this.forward_remote_list.add((ForwardRemote)forward);
                                break;
                            }
                            case "debug": {
                                debug = value.equals("true");
                            }
                        }
                        continue block52;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            JFLog.log("config not found, creating defaults.");
            try {
                FileOutputStream fos = new FileOutputStream(SOCKSServer.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
                return;
            }
            catch (Exception e2) {
                JFLog.log(e2);
                return;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private boolean ip_src_allowed(String ip4) {
        if (this.subnet_src_list.size() == 0) {
            return true;
        }
        IP4 target = new IP4();
        if (!target.setIP(ip4)) {
            return false;
        }
        for (Subnet4 net : this.subnet_src_list) {
            if (!net.isWithin(target)) continue;
            return true;
        }
        return false;
    }

    private boolean ip_dest_allowed(String ip4) {
        if (this.subnet_dest_list.size() == 0) {
            return true;
        }
        IP4 target = new IP4();
        if (!target.setIP(ip4)) {
            return false;
        }
        for (Subnet4 net : this.subnet_dest_list) {
            if (!net.isWithin(target)) continue;
            return true;
        }
        return false;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(SOCKSServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        socks = new SOCKSServer();
        socks.start();
    }

    public static void serviceStop() {
        JFLog.log("SOCKS : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        socks.stop();
    }

    public static boolean createKeys() {
        return KeyMgmt.keytool(new String[]{"-genkey", "-debug", "-alias", "jfsocks", "-keypass", "password", "-storepass", "password", "-keystore", SOCKSServer.getKeyFile(), "-validity", "3650", "-dname", "CN=jfsocks.sourceforge.net, OU=user, O=server, C=CA", "-keyalg", "RSA", "-keysize", "2048"});
    }

    private class Server
    extends Thread {
        public boolean active;

        private Server() {
        }

        @Override
        public void run() {
            JFLog.append(JF.getLogPath() + "/jfsocks.log", true);
            JFLog.setRetention(30);
            JFLog.log("SOCKS : Starting service");
            this.active = true;
            try {
                SOCKSServer.this.loadConfig();
                SOCKSServer.this.busClient = new JBusClient(SOCKSServer.busPack, new JBusMethods());
                SOCKSServer.this.busClient.setPort(SOCKSServer.getBusPort());
                SOCKSServer.this.busClient.start();
                if (SOCKSServer.this.secure) {
                    JFLog.log("CreateServerSocketSSL");
                    SOCKSServer.this.keys.setRootAlias("jfsocks");
                    if (new File(SOCKSServer.getKeyFile()).exists()) {
                        Iterator<ForwardRemote> fis = new FileInputStream(SOCKSServer.getKeyFile());
                        SOCKSServer.this.keys.open((InputStream)((Object)fis), "password");
                        ((FileInputStream)((Object)fis)).close();
                    } else {
                        JFLog.log("Warning:Server SSL Keys not generated!");
                    }
                    SOCKSServer.this.ss = JF.createServerSocketSSL(SOCKSServer.this.keys);
                    if (SOCKSServer.this.secure_verify) {
                        JF.clientKeys = SOCKSServer.this.keys;
                        JF.clientKeysAlias = "jfsocks";
                        ((SSLServerSocket)SOCKSServer.this.ss).setNeedClientAuth(true);
                    }
                } else {
                    SOCKSServer.this.ss = new ServerSocket();
                }
                SOCKSServer.this.ss.bind(SOCKSServer.this.bind.toInetSocketAddress());
                this.active = true;
                for (ForwardLocal fl : SOCKSServer.this.forward_local_list) {
                    ForwardLocalWorker flw = new ForwardLocalWorker(fl);
                    flw.start();
                    SOCKSServer.this.forward_local_workers.add(flw);
                }
                for (ForwardRemote fr : SOCKSServer.this.forward_remote_list) {
                    ForwardRemoteWorker frw = new ForwardRemoteWorker(fr);
                    frw.start();
                    SOCKSServer.this.forward_remote_workers.add(frw);
                }
                while (this.active) {
                    try {
                        Socket s = SOCKSServer.this.ss.accept();
                        InetSocketAddress sa = (InetSocketAddress)s.getRemoteSocketAddress();
                        String src_ip = sa.getAddress().getHostAddress();
                        if (src_ip.equals("0:0:0:0:0:0:0:1")) {
                            src_ip = "127.0.0.1";
                        }
                        if (!SOCKSServer.this.ip_src_allowed(src_ip)) {
                            JFLog.log("SOCKS:Source IP blocked:" + src_ip);
                            s.close();
                            continue;
                        }
                        SocksWorker sess = new SocksWorker(s);
                        SOCKSServer.this.addSession(sess);
                        sess.start();
                    }
                    catch (Exception e) {
                        SOCKSServer.this.log(e);
                    }
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public class SocksWorker
    extends Thread {
        private Socket c;
        private Socket o;
        private ProxyData pd1;
        private ProxyData pd2;
        private boolean connected = false;
        private InputStream cis = null;
        private OutputStream cos = null;
        private byte[] req = new byte[1500];
        private int reqSize = 0;

        public SocksWorker(Socket s) {
            this.c = s;
        }

        public void close() {
            if (this.c != null) {
                try {
                    this.c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.o != null) {
                try {
                    this.o.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.pd1 != null) {
                this.pd1.close();
            }
            if (this.pd2 != null) {
                this.pd2.close();
            }
        }

        @Override
        public void run() {
            block18: {
                try {
                    int read;
                    JFLog.log("Session start");
                    this.cis = this.c.getInputStream();
                    this.cos = this.c.getOutputStream();
                    while (this.c.isConnected() && (read = this.cis.read(this.req, this.reqSize, 1500 - this.reqSize)) >= 0) {
                        this.reqSize += read;
                        if (this.reqSize == 0) continue;
                        if (this.req[0] == 4) {
                            int a;
                            int null_count;
                            if (this.reqSize < 8) continue;
                            String ip3 = String.format("%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF);
                            if (ip3.equals("0.0.0")) {
                                null_count = 0;
                                for (a = 8; a < this.reqSize; ++a) {
                                    if (this.req[a] != 0) continue;
                                    ++null_count;
                                }
                                if (null_count == 2) break;
                                if (null_count <= 2) continue;
                                throw new Exception("SOCKS4:bad request:too many nulls:expect=2");
                            }
                            null_count = 0;
                            for (a = 8; a < this.reqSize; ++a) {
                                if (this.req[a] != 0) continue;
                                ++null_count;
                            }
                            if (null_count == 1) break;
                            if (null_count <= 1) continue;
                            throw new Exception("SOCKS4:bad request:too many nulls:expect=1");
                        }
                        if (this.req[0] == 5) {
                            int nauth;
                            if (this.reqSize < 3 || this.reqSize != (nauth = this.req[1] & 0xFF) + 2) continue;
                            break;
                        }
                        throw new Exception("bad request:not SOCKS4/5 request");
                    }
                    switch (this.req[0]) {
                        case 4: {
                            this.socks4();
                            break;
                        }
                        case 5: {
                            this.socks5();
                            break;
                        }
                        default: {
                            throw new Exception("bad request:not SOCKS4/5 request");
                        }
                    }
                }
                catch (Exception e) {
                    if (!SOCKSServer.this.log(e) || this.connected) break block18;
                    byte[] reply = null;
                    switch (this.req[0]) {
                        case 4: {
                            reply = new byte[8];
                            break;
                        }
                        case 5: {
                            reply = new byte[10];
                            reply[3] = 1;
                        }
                    }
                    reply[0] = this.req[0];
                    reply[1] = 91;
                    try {
                        this.cos.write(reply);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.close();
            SOCKSServer.this.removeSession(this);
        }

        private void socks4() throws Exception {
            if (!SOCKSServer.this.socks4) {
                throw new Exception("SOCKS4:not enabled");
            }
            JFLog.log("socks4 connection started");
            switch (this.req[1]) {
                case 1: {
                    this.socks4_connect();
                    return;
                }
                case 2: {
                    this.socks4_bind();
                    return;
                }
            }
            throw new Exception("SOCKS4:bad request");
        }

        private void socks4_connect() throws Exception {
            String dest;
            int port = BE.getuint16(this.req, 2);
            String ip3 = String.format("%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF);
            if (ip3.equals("0.0.0")) {
                int user_null = -1;
                int domain_null = -1;
                for (int a = 8; a < this.reqSize; ++a) {
                    if (this.req[a] != 0) continue;
                    if (user_null == -1) {
                        user_null = a;
                        continue;
                    }
                    domain_null = a;
                }
                String user_id = new String(this.req, 8, user_null - 8);
                dest = new String(this.req, 8, domain_null - 8);
                dest = InetAddress.getByName(dest).getHostAddress();
            } else {
                dest = String.format("%d.%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF, this.req[7] & 0xFF);
            }
            if (!SOCKSServer.this.ip_dest_allowed(dest)) {
                throw new Exception("SOCKS:Target IP outside of allowed IP Subnets:" + dest);
            }
            this.o = new Socket(dest, port);
            this.connected = true;
            byte[] reply = new byte[8];
            reply[0] = 0;
            reply[1] = 90;
            this.cos.write(reply);
            this.pd1 = new ProxyData(this.c, this.o, "s4-1");
            this.pd1.start();
            this.pd2 = new ProxyData(this.o, this.c, "s4-2");
            this.pd2.start();
            this.pd1.join();
            this.pd2.join();
            JFLog.log("SOCKS4:connect() Session end");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void socks4_bind() throws Exception {
            if (!SOCKSServer.this.socks_bind) {
                throw new Exception("SOCKS.bind disabled!");
            }
            int port = BE.getuint16(this.req, 2);
            String src = String.format("%d.%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF, this.req[7] & 0xFF);
            byte[] reply = new byte[8];
            reply[0] = 0;
            reply[1] = 90;
            this.cos.write(reply);
            ServerSocket ss = null;
            try {
                if (SOCKSServer.this.bind_cmd.isEmpty()) {
                    ss = new ServerSocket(port);
                } else {
                    IP4Port iP4Port = SOCKSServer.this.bind_cmd;
                    synchronized (iP4Port) {
                        ss = new ServerSocket();
                        SOCKSServer.this.bind_cmd.port = port;
                        ss.bind(SOCKSServer.this.bind_cmd.toInetSocketAddress());
                    }
                }
                ss.setSoTimeout(SOCKSServer.this.socks_bind_timeout);
                this.o = ss.accept();
                String src_addr = this.o.getInetAddress().getHostAddress();
                if (src_addr.equals("0:0:0:0:0:0:0:1")) {
                    src_addr = "127.0.0.1";
                }
                int src_port = this.o.getPort();
                if (!src.equals("0.0.0.0") && !src.equals(src_addr)) {
                    throw new Exception("SOCKS4:bind:unexpected host connected:" + src_addr);
                }
                this.connected = true;
                reply[0] = 0;
                reply[1] = 90;
                IP4 src_ip = new IP4();
                src_ip.setIP(src_addr);
                reply[2] = (byte)(src_port & 0xFF);
                reply[3] = (byte)(src_port & 0xFF);
                for (int a = 0; a < 4; ++a) {
                    reply[4 + a] = src_ip.ip[0 + a];
                }
                this.cos.write(reply);
                this.pd1 = new ProxyData(this.c, this.o, "s4-1");
                this.pd1.start();
                this.pd2 = new ProxyData(this.o, this.c, "s4-2");
                this.pd2.start();
                this.pd1.join();
                this.pd2.join();
            }
            catch (Exception e) {
                SOCKSServer.this.log(e);
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JFLog.log("SOCKS4:bind() Session end");
        }

        private void socks5() throws Exception {
            int read;
            int pass_len;
            String pass;
            int user_len;
            String user;
            String user_pass;
            int read2;
            JFLog.log("socks5 connection started");
            if (!SOCKSServer.this.socks5) {
                throw new Exception("SOCKS5:not enabled");
            }
            int nauth = this.req[1] & 0xFF;
            boolean auth_type_2 = false;
            for (int a = 0; a < nauth; ++a) {
                if (this.req[a + 2] != 2) continue;
                auth_type_2 = true;
                break;
            }
            if (!auth_type_2) {
                throw new Exception("SOCKS5:auth not supported");
            }
            byte[] reply = new byte[]{5, 2};
            this.cos.write(reply);
            this.reqSize = 0;
            while (this.c.isConnected() && (read2 = this.cis.read(this.req, this.reqSize, 1500 - this.reqSize)) >= 0) {
                int pass_len2;
                this.reqSize += read2;
                if (this.reqSize < 5) continue;
                if (this.req[0] != 1) {
                    throw new Exception("SOCKS5:invalid auth request");
                }
                int user_len2 = this.req[1] & 0xFF;
                if (this.reqSize < 3 + user_len2 || this.reqSize < 3 + user_len2 + (pass_len2 = this.req[2 + user_len2] & 0xFF)) continue;
            }
            if (!SOCKSServer.this.user_pass_list.contains(user_pass = (user = new String(this.req, 2, user_len = this.req[1] & 0xFF)) + ":" + (pass = new String(this.req, 3 + user_len, pass_len = this.req[2 + user_len] & 0xFF)))) {
                throw new Exception("SOCKS5:user/pass not authorized");
            }
            reply = new byte[]{1, 0};
            this.cos.write(reply);
            this.reqSize = 0;
            int toRead = 10;
            while (this.c.isConnected() && (read = this.cis.read(this.req, this.reqSize, toRead - this.reqSize)) >= 0) {
                this.reqSize += read;
                if (this.reqSize < 10) continue;
                int dest_type = this.req[3] & 0xFF;
                if (dest_type == 1) {
                    if (this.reqSize != toRead) continue;
                    break;
                }
                if (dest_type == 3) {
                    int domain_len = this.req[4] & 0xFF;
                    toRead = 5 + domain_len + 2;
                    if (this.reqSize != toRead) continue;
                    break;
                }
                if (dest_type == 4) {
                    throw new Exception("SOCKS5:IP6 not supported");
                }
                throw new Exception("SOCKS5:dest_type not supported:" + dest_type);
            }
            if (this.req[0] != 5) {
                throw new Exception("SOCKS5:bad connection request:version != 0x05");
            }
            switch (this.req[1]) {
                case 1: {
                    this.socks5_connect();
                    return;
                }
                case 2: {
                    this.socks5_bind();
                    return;
                }
            }
            throw new Exception("SOCKS5:cmd not supported:" + this.req[1]);
        }

        private void socks5_connect() throws Exception {
            String dest = null;
            int port = BE.getuint16(this.req, this.reqSize - 2);
            switch (this.req[3]) {
                case 1: {
                    dest = String.format("%d.%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF, this.req[7] & 0xFF);
                    break;
                }
                case 3: {
                    dest = new String(this.req, 5, this.req[4] & 0xFF);
                    dest = InetAddress.getByName(dest).getHostAddress();
                    break;
                }
                default: {
                    throw new Exception("SOCKS5:bad connection request:addr type not supported:" + this.req[3]);
                }
            }
            if (!SOCKSServer.this.ip_dest_allowed(dest)) {
                throw new Exception("SOCKS:Target IP outside of allowed IP Subnets:" + dest);
            }
            byte[] reply = new byte[this.reqSize];
            System.arraycopy(this.req, 0, reply, 0, this.reqSize);
            reply[1] = 0;
            this.cos.write(reply);
            JFLog.log("SOCKS5:Connect:" + dest + ":" + port);
            this.o = new Socket(dest, port);
            this.connected = true;
            this.pd1 = new ProxyData(this.c, this.o, "s5-1");
            this.pd1.start();
            this.pd2 = new ProxyData(this.o, this.c, "s5-2");
            this.pd2.start();
            this.pd1.join();
            this.pd2.join();
            JFLog.log("SOCKS5:connect() Session end");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void socks5_bind() throws Exception {
            if (!SOCKSServer.this.socks_bind) {
                throw new Exception("SOCKS.bind disabled!");
            }
            String src = null;
            int port = BE.getuint16(this.req, this.reqSize - 2);
            switch (this.req[3]) {
                case 1: {
                    src = String.format("%d.%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF, this.req[7] & 0xFF);
                    break;
                }
                case 3: {
                    src = new String(this.req, 5, this.req[4] & 0xFF);
                    src = InetAddress.getByName(src).getHostAddress();
                    break;
                }
                default: {
                    throw new Exception("SOCKS5:bad connection request:addr type not supported:" + this.req[3]);
                }
            }
            byte[] reply = new byte[this.reqSize];
            System.arraycopy(this.req, 0, reply, 0, this.reqSize);
            reply[1] = 0;
            this.cos.write(reply);
            ServerSocket ss = null;
            try {
                if (SOCKSServer.this.bind_cmd.isEmpty()) {
                    ss = new ServerSocket(port);
                } else {
                    IP4Port iP4Port = SOCKSServer.this.bind_cmd;
                    synchronized (iP4Port) {
                        ss = new ServerSocket();
                        SOCKSServer.this.bind_cmd.port = port;
                        ss.bind(SOCKSServer.this.bind_cmd.toInetSocketAddress());
                    }
                }
                ss.setSoTimeout(SOCKSServer.this.socks_bind_timeout);
                this.o = ss.accept();
                String src_addr = this.o.getInetAddress().getHostAddress();
                if (src_addr.equals("0:0:0:0:0:0:0:1")) {
                    src_addr = "127.0.0.1";
                }
                int src_port = this.o.getPort();
                if (!src.equals("0.0.0.0") && !src.equals(src_addr)) {
                    throw new Exception("SOCKS5:bind:unexpected host connected:" + src_addr);
                }
                reply = new byte[10];
                reply[0] = 5;
                reply[1] = 0;
                reply[2] = 0;
                reply[3] = 1;
                IP4 src_ip = new IP4();
                src_ip.setIP(src_addr);
                for (int a = 0; a < 4; ++a) {
                    reply[4 + a] = src_ip.ip[0 + a];
                }
                reply[8] = (byte)(src_port & 0xFF);
                reply[9] = (byte)(src_port & 0xFF);
                this.cos.write(reply);
                this.connected = true;
                this.pd1 = new ProxyData(this.c, this.o, "s5-1");
                this.pd1.start();
                this.pd2 = new ProxyData(this.o, this.c, "s5-2");
                this.pd2.start();
                this.pd1.join();
                this.pd2.join();
            }
            catch (Exception e) {
                SOCKSServer.this.log(e);
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JFLog.log("SOCKS5:bind() Session end");
        }
    }

    public class ForwardLocalWorker
    extends Thread {
        private ForwardLocal forward;
        private ServerSocket ss;

        public ForwardLocalWorker(ForwardLocal forward) {
            this.forward = forward;
        }

        @Override
        public void run() {
            try {
                this.ss = new ServerSocket();
                this.ss.bind(this.forward.from.toInetSocketAddress());
                while (SOCKSServer.this.server.active) {
                    Socket from = this.ss.accept();
                    try {
                        Socket to = new Socket(this.forward.to.toInetAddress(), this.forward.to.port);
                        ProxyData pd1 = new ProxyData(from, to, "f-1");
                        pd1.start();
                        ProxyData pd2 = new ProxyData(to, from, "f-2");
                        pd2.start();
                    }
                    catch (Exception e) {
                        SOCKSServer.this.log(e);
                    }
                }
            }
            catch (Exception e) {
                SOCKSServer.this.log(e);
                JF.sleep(1000);
            }
        }

        public void close() {
            try {
                this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class ForwardRemoteWorker
    extends Thread {
        private ForwardRemote forward;

        public ForwardRemoteWorker(ForwardRemote forward) {
            this.forward = forward;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
lbl1:
            // 3 sources

            try {
                while (SOCKSServer.this.server.active) {
                    block11: {
                        wait = true;
                        try {
                            from = null;
                            from = this.forward.secure != false ? JF.connectSSL(this.forward.socks.toIP4String(), this.forward.socks.port, SOCKSServer.this.keys) : new Socket(this.forward.socks.toInetAddress(), this.forward.socks.port);
                            if (this.forward.user != null && this.forward.pass != null) {
                                if (!SOCKS.bind(from, this.forward.from.toString(), this.forward.port, this.forward.user, this.forward.pass)) {
                                    throw new Exception("SOCKS5:bind:failed");
                                }
                            } else if (!SOCKS.bind(from, this.forward.from.toString(), this.forward.port)) {
                                throw new Exception("SOCKS4:bind:failed");
                            }
                            to = new Socket(this.forward.to.toInetAddress(), this.forward.to.port);
                            pd1 = new ProxyData(from, to, "f-1");
                            pd1.start();
                            pd2 = new ProxyData(to, from, "f-2");
                            pd2.start();
                            wait = false;
                        }
                        catch (Exception e) {
                            SOCKSServer.this.log(e);
                            JF.sleep(1000);
                        }
                        if (!wait) break block11;
                        for (wait_time = 0; SOCKSServer.this.server.active && wait_time < SOCKSServer.this.forward_remote_timeout; wait_time += 1000) {
                            JF.sleep(1000);
                        }
                        ** GOTO lbl1
                    }
                    for (wait_time = 0; SOCKSServer.this.server.active && wait_time < 5000; wait_time += 1000) {
                        JF.sleep(1000);
                    }
                    ** GOTO lbl1
                }
            }
            catch (Exception e) {
                SOCKSServer.this.log(e);
            }
        }

        public void close() {
            try {
                SOCKSServer.this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static enum Section {
        None,
        Global;

    }

    private class ForwardLocal {
        public IP4Port from = new IP4Port();
        public IP4Port to = new IP4Port();

        private ForwardLocal() {
        }

        public boolean set_from(String ip_port) {
            int idx = ip_port.indexOf(58);
            if (idx == -1) {
                return false;
            }
            String ip = ip_port.substring(0, idx);
            String port = ip_port.substring(idx + 1);
            if (!this.from.setIP(ip)) {
                return false;
            }
            return this.from.setPort(port);
        }

        public boolean set_to(String ip_port) {
            int idx = ip_port.indexOf(58);
            if (idx == -1) {
                return false;
            }
            String ip = ip_port.substring(0, idx);
            String port = ip_port.substring(idx + 1);
            if (!this.to.setIP(ip)) {
                return false;
            }
            return this.to.setPort(port);
        }

        public String toString() {
            return this.from.toString() + " -> " + this.to.toString();
        }
    }

    private class ForwardRemote {
        public String user;
        public String pass;
        public IP4Port socks = new IP4Port();
        public IP4 from = new IP4();
        public int port;
        public IP4Port to = new IP4Port();
        public boolean secure;

        private ForwardRemote() {
        }

        public boolean set_socks(String ip_port) {
            int idx = ip_port.indexOf(58);
            if (idx == -1) {
                return false;
            }
            String ip = ip_port.substring(0, idx);
            String port = ip_port.substring(idx + 1);
            if (!this.socks.setIP(ip)) {
                return false;
            }
            return this.socks.setPort(port);
        }

        public boolean set_from(String host) {
            return this.from.setIP(host);
        }

        public void set_port(int port) {
            this.port = port;
        }

        public boolean set_to(String ip_port) {
            int idx = ip_port.indexOf(58);
            if (idx == -1) {
                return false;
            }
            String ip = ip_port.substring(0, idx);
            String port = ip_port.substring(idx + 1);
            if (!this.to.setIP(ip)) {
                return false;
            }
            return this.to.setPort(port);
        }

        public String toString() {
            return this.socks.toString() + " bind port " + this.port + " -> " + this.to.toString();
        }
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = SOCKSServer.socks.busClient;
            JBusClient cfr_ignored_1 = SOCKSServer.socks.busClient;
            SOCKSServer.socks.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(SOCKSServer.socks.config)));
        }

        public void setConfig(String cfg) {
            JFLog.log("setConfig");
            try {
                FileOutputStream fos = new FileOutputStream(SOCKSServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            JFLog.log("restart");
            socks.stop();
            socks = new SOCKSServer();
            socks.start();
        }

        public void genKeys(String pack) {
            if (SOCKSServer.createKeys()) {
                JFLog.log("Generated Keys");
                JBusClient cfr_ignored_0 = SOCKSServer.socks.busClient;
                SOCKSServer.socks.busClient.call(pack, "genKeysStatus", JBusClient.quote("OK"));
            } else {
                JBusClient cfr_ignored_1 = SOCKSServer.socks.busClient;
                SOCKSServer.socks.busClient.call(pack, "genKeysStatus", JBusClient.quote("ERROR"));
            }
        }

        public void getKeys(String pack) {
            try {
                FileInputStream fis = new FileInputStream(SOCKSServer.getKeyFile());
                byte[] data = fis.readAllBytes();
                fis.close();
                JBusClient cfr_ignored_0 = SOCKSServer.socks.busClient;
                SOCKSServer.socks.busClient.call(pack, "giveKeys", JBusClient.encodeByteArray(data));
            }
            catch (Exception e) {
                JFLog.log(e);
                JBusClient cfr_ignored_1 = SOCKSServer.socks.busClient;
                SOCKSServer.socks.busClient.call(pack, "giveKeys", JBusClient.quote(""));
            }
        }

        public void setKeys(String pack, String data) {
            byte[] keys = JBusClient.decodeByteArray(data);
            if (JF.writeFile(SOCKSServer.getKeyFile(), keys)) {
                JBusClient cfr_ignored_0 = SOCKSServer.socks.busClient;
                SOCKSServer.socks.busClient.call(pack, "setKeysStatus", JBusClient.quote("OK"));
            } else {
                JBusClient cfr_ignored_1 = SOCKSServer.socks.busClient;
                SOCKSServer.socks.busClient.call(pack, "setKeysStatus", JBusClient.quote("ERROR"));
            }
        }
    }

    public class ProxyData
    extends Thread {
        private Socket sRead;
        private Socket sWrite;
        private volatile boolean active;
        private String name;

        public ProxyData(Socket sRead, Socket sWrite, String name) {
            this.sRead = sRead;
            this.sWrite = sWrite;
            this.name = name;
        }

        @Override
        public void run() {
            try {
                int read;
                InputStream is = this.sRead.getInputStream();
                OutputStream os = this.sWrite.getOutputStream();
                byte[] buf = new byte[1500];
                this.active = true;
                while (this.active && (read = is.read(buf)) >= 0) {
                    if (read <= 0) continue;
                    os.write(buf, 0, read);
                }
            }
            catch (Exception e) {
                SOCKSServer.this.log(e);
            }
            try {
                this.sRead.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sWrite.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void close() {
            this.active = false;
        }
    }
}

