/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.XML;

public class BuildTools {
    private XML xml;
    private Properties versions;
    private String file;
    private boolean debug = false;

    public boolean loadXML(String xmlfile) {
        this.file = xmlfile;
        this.xml = new XML();
        try {
            this.xml.read(new FileInputStream(xmlfile));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return false;
        }
    }

    public String getTag(String name) {
        XML.XMLTag tag = this.xml.getTag(new String[]{"project", name});
        if (tag == null) {
            return "";
        }
        return tag.content;
    }

    public String getTag(String[] path) {
        XML.XMLTag tag = this.xml.getTag(path);
        if (tag == null) {
            return "";
        }
        return tag.content;
    }

    public String getProperty(String name) {
        int cnt = this.xml.root.getChildCount();
        for (int a = 0; a < cnt; ++a) {
            XML.XMLTag tag = this.xml.root.getChildAt(a);
            if (!tag.name.equals("property")) continue;
            int attrs = tag.attrs.size();
            String attrName = null;
            String attrValue = null;
            for (int b = 0; b < attrs; ++b) {
                XML.XMLAttr attr = tag.attrs.get(b);
                if (attr.name.equals("name")) {
                    attrName = attr.value;
                }
                if (attr.name.equals("value")) {
                    attrValue = attr.value;
                }
                if (!attr.name.equals("location")) continue;
                attrValue = attr.value;
            }
            if (attrName == null || !attrName.equals(name)) continue;
            if (attrValue.equals("${javaforce-version}")) {
                attrValue = this.getVersion("javaforce-version");
            }
            return attrValue;
        }
        if (this.debug) {
            JFLog.log("error:property not found:" + name + ":file=" + this.file);
        }
        return "";
    }

    public String getVersion(String name) {
        String home = this.getProperty("home");
        if (this.versions == null) {
            try {
                this.versions = new Properties();
                FileInputStream fis = new FileInputStream(home + "/versions.properties");
                this.versions.load(fis);
                fis.close();
            }
            catch (Exception e) {
                JFLog.log(e);
                return null;
            }
        }
        return this.versions.getProperty(name);
    }

    public static void chmod_x(String file) {
        new File(file).setExecutable(true);
    }

    public static boolean checkFiles(String files_lst) {
        try {
            File files = new File(files_lst);
            if (!files.exists()) {
                JFLog.log("Error:" + files_lst + " not found");
                return false;
            }
            BuildTools.cleanFiles(files_lst);
            FileInputStream fis = new FileInputStream(files);
            String[] lns = new String(fis.readAllBytes()).split("\n");
            fis.close();
            for (String ln : lns) {
                File file;
                if (ln.length() == 0 || (file = new File(ln)).exists()) continue;
                JFLog.log("Error:File not found:" + ln);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public String[] getSubProjects() {
        if (!this.file.endsWith(File.separator + "build.xml")) {
            return new String[0];
        }
        if (!new File("projects.lst").exists()) {
            return new String[0];
        }
        try {
            byte[] data = JF.readFile("projects.lst");
            String[] subs = new String(data).replaceAll("\r", "").split("\n");
            ArrayList<String> list = new ArrayList<String>();
            for (String sub : subs) {
                if ((sub = sub.trim()).length() == 0 || sub.equals("build")) continue;
                list.add(sub);
            }
            return list.toArray(JF.StringArrayType);
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public static void cleanFiles(String files) {
        try {
            FileInputStream fis = new FileInputStream(files);
            String content = new String(fis.readAllBytes());
            fis.close();
            String clean = content.replaceAll("\r", "");
            if (content.equals(clean)) {
                return;
            }
            FileOutputStream fos = new FileOutputStream(files);
            fos.write(clean.getBytes());
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

