/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SRTPContext {
    static int KEYLEN = 16;
    static int MACKEYLEN = 20;
    static int BLOCKSZ = 16;
    private Cipher _anAES;
    private byte[] _sessionKey = new byte[0];
    ByteBuffer _masterSalt;
    private byte[] _cipherSalt;
    private byte[] _sessionAuth;
    private int _tag;
    private int _authTail;
    byte[] _masterKey;
    private int _mki;
    private int _mkiLen;
    private int _kdr;
    private int _keyLife;
    private boolean _in;

    SRTPContext(boolean in) {
        this._in = in;
    }

    SRTPContext() {
        this(false);
    }

    private static byte[] saba(short[] s) {
        byte[] r = new byte[s.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = (byte)s[i];
        }
        return r;
    }

    public int getAuthTail() {
        return this._authTail;
    }

    static void bbxor(ByteBuffer l, ByteBuffer r) {
        int num = Math.min(l.capacity(), r.capacity());
        for (int i = 0; i < num; ++i) {
            byte a = (byte)(r.get(i) ^ l.get(i));
            l.put(i, a);
        }
    }

    ByteBuffer cloneByteBuffer(ByteBuffer orig) {
        ByteBuffer ret = ByteBuffer.allocate(orig.capacity());
        ret.put(orig.array(), 0, orig.capacity());
        return ret;
    }

    void deriveKeys(long index) throws GeneralSecurityException {
        if (this.haveKeys() && this._kdr != 0 && index % (long)this._kdr == 0L) {
            this.deriveKeys(index, this._kdr);
        } else if (!this.haveKeys()) {
            this.deriveKeys(0L, 0);
        }
    }

    private void deriveKeys(long index, int kdr) throws GeneralSecurityException {
        byte label = 0;
        ByteBuffer myinpblk = this.cloneByteBuffer(this._masterSalt);
        ByteBuffer lex = ByteBuffer.allocate(BLOCKSZ);
        long idivk = kdr == 0 ? 0L : index / (long)kdr;
        lex.putLong(6, idivk);
        lex.put(7, label);
        SRTPContext.bbxor(myinpblk, lex);
        this._sessionKey = this.getKeyBytes(myinpblk, KEYLEN);
        label = 2;
        myinpblk = this.cloneByteBuffer(this._masterSalt);
        lex = ByteBuffer.allocate(BLOCKSZ);
        idivk = kdr == 0 ? 0L : index / (long)kdr;
        lex.putLong(6, idivk);
        lex.put(7, label);
        SRTPContext.bbxor(myinpblk, lex);
        this._cipherSalt = this.getKeyBytes(myinpblk, KEYLEN);
        this._cipherSalt[14] = 0;
        this._cipherSalt[15] = 0;
        label = 1;
        myinpblk = this.cloneByteBuffer(this._masterSalt);
        lex = ByteBuffer.allocate(BLOCKSZ);
        idivk = kdr == 0 ? 0L : index / (long)kdr;
        lex.putLong(6, idivk);
        lex.put(7, label);
        SRTPContext.bbxor(myinpblk, lex);
        this._sessionAuth = this.getKeyBytes(myinpblk, MACKEYLEN);
    }

    void getCypherStreamBytes(Cipher aes, ByteBuffer asalt, ByteBuffer stream) throws GeneralSecurityException {
        char bno;
        int blocksz = 16;
        int toget = stream.capacity() - 32;
        stream.position(0);
        char blks = toget / blocksz;
        for (bno = '\u0000'; bno < blks; bno = (char)(bno + '\u0001')) {
            asalt.putChar(14, bno);
            asalt.position(0);
            aes.update(asalt, stream);
        }
        asalt.putChar(14, bno);
        asalt.position(0);
        aes.doFinal(asalt, stream);
    }

    private byte[] getKeyBytes(ByteBuffer inp, int want) throws GeneralSecurityException {
        int blocksz = 16;
        byte[] ret = null;
        if (want == blocksz) {
            ByteBuffer slop = ByteBuffer.allocate(want * 2);
            inp.putChar(14, '\u0000');
            inp.position(0);
            this._anAES.doFinal(inp, slop);
            ret = new byte[want];
            slop.position(0);
            slop.get(ret);
        } else {
            ByteBuffer stream = ByteBuffer.allocate(want + 32);
            this.getCypherStreamBytes(this._anAES, inp, stream);
            ret = new byte[want];
            System.arraycopy(stream.array(), 0, ret, 0, want);
        }
        return ret;
    }

    Mac getAuthMac() throws GeneralSecurityException {
        SecretKeySpec key = new SecretKeySpec(this._sessionAuth, "HmacSHA1");
        Mac m = Mac.getInstance("HmacSHA1");
        m.init(key);
        return m;
    }

    void decipher(ByteBuffer in, ByteBuffer out, ByteBuffer pepper) throws GeneralSecurityException {
        SecretKeySpec keyp = new SecretKeySpec(this._sessionKey, "AES");
        Cipher aes = Cipher.getInstance("AES");
        aes.init(1, keyp);
        ByteBuffer csalt = ByteBuffer.wrap(this._cipherSalt);
        SRTPContext.bbxor(pepper, csalt);
        this.getCypherStreamBytes(aes, pepper, out);
        SRTPContext.bbxor(out, in);
    }

    boolean haveKeys() {
        return this._sessionAuth != null && this._sessionKey != null && this._cipherSalt != null;
    }

    void setCrypto(String crypto_suite, byte[] master_key, byte[] master_salt) throws GeneralSecurityException {
        if (crypto_suite.equals("AES_CM_128_HMAC_SHA1_80")) {
            this._authTail = 10;
        } else if (crypto_suite.equals("AES_CM_128_HMAC_SHA1_32")) {
            this._authTail = 4;
        } else {
            throw new GeneralSecurityException("Unsupported crypto suite " + crypto_suite);
        }
        this._masterKey = master_key;
        SecretKeySpec keyp = new SecretKeySpec(this._masterKey, "AES");
        this._anAES = Cipher.getInstance("AES");
        this._anAES.init(1, keyp);
        this._masterSalt = ByteBuffer.wrap(master_salt);
    }
}

