/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Color;
import javaforce.webui.Component;
import javaforce.webui.Container;
import javaforce.webui.Label;
import javaforce.webui.Panel;

public class SplitPanel
extends Panel {
    private int dir;
    private int pos = 50;
    private Container div;
    private Container t1;
    private Container t2;
    private Container c1;
    private Container c2;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;

    public SplitPanel(int direction) {
        this.dir = direction;
        this.div = new Container();
        this.div.setClass("splitDivider");
        this.div.setBackColor(Color.grey);
        switch (this.dir) {
            case 1: {
                this.t1 = new Panel();
                this.t1.setWidth(this.pos);
                this.t1.setMaxHeight();
                this.t1.addClass("splitPanelCell");
                this.t1.setVerticalAlign(4);
                this.c1 = new Panel();
                this.c1.setWidth(this.pos);
                this.c1.setMaxHeight();
                this.c1.addClass("block");
                this.c1.add(new Label("left"));
                this.t1.add(this.c1);
                this.t2 = new Panel();
                this.t2.setMaxWidth();
                this.t2.setMaxHeight();
                this.t2.addClass("splitPanelCell");
                this.t2.setVerticalAlign(4);
                this.c2 = new Panel();
                this.c2.setMaxWidth();
                this.c2.setMaxHeight();
                this.c2.addClass("block");
                this.c2.add(new Label("right"));
                this.t2.add(this.c2);
                this.div.setWidth(5);
                this.div.setMaxHeight();
                break;
            }
            case 2: {
                this.t1 = new Panel();
                this.t1.setHeight(this.pos);
                this.t1.setMaxWidth();
                this.t1.addClass("splitPanelRow");
                this.t1.setVerticalAlign(4);
                this.c1 = new Panel();
                this.c1.setHeight(this.pos);
                this.c1.setMaxWidth();
                this.c1.addClass("block");
                this.c1.add(new Label("top"));
                this.t1.add(this.c1);
                this.t2 = new Panel();
                this.t2.setMaxWidth();
                this.t2.setMaxHeight();
                this.t2.addClass("splitPanelRow");
                this.t2.setVerticalAlign(4);
                this.c2 = new Panel();
                this.c2.setMaxWidth();
                this.c2.setMaxHeight();
                this.c2.addClass("block");
                this.c2.add(new Label("bottom"));
                this.t2.add(this.c2);
                this.div.setMaxWidth();
                this.div.setHeight(5);
            }
        }
        this.add(this.t1);
        this.add(this.div);
        this.add(this.t2);
        this.addClass("splitPanelTop");
        this.setMaxWidth();
        this.setMaxHeight();
    }

    @Override
    public void init() {
        super.init();
        switch (this.dir) {
            case 1: {
                this.div.addEvent("onmousedown", "onmousedownSplitPanel(event, this,\"" + this.c1.id + "\",\"" + this.div.id + "\",\"" + this.c2.id + "\",\"" + this.id + "\", \"v\");");
                this.addEvent("onresize", "onresizeSplitPanelWidth(event, this,\"" + this.c1.id + "\",\"" + this.div.id + "\",\"" + this.c2.id + "\")");
                break;
            }
            case 2: {
                this.div.addEvent("onmousedown", "onmousedownSplitPanel(event, this,\"" + this.c1.id + "\",\"" + this.div.id + "\",\"" + this.c2.id + "\",\"" + this.id + "\", \"h\");");
                this.addEvent("onresize", "onresizeSplitPanelHeight(event, this,\"" + this.c1.id + "\",\"" + this.div.id + "\",\"" + this.c2.id + "\")");
            }
        }
    }

    public int getDirection() {
        return this.dir;
    }

    public void setDividerPosition(int pos) {
        this.pos = pos;
        switch (this.dir) {
            case 1: {
                this.t1.setWidth(pos);
                this.c1.setWidth(pos);
                this.getLeftComponent().setWidth(pos);
                break;
            }
            case 2: {
                this.t1.setHeight(pos);
                this.c1.setHeight(pos);
                this.getTopComponent().setHeight(pos);
            }
        }
    }

    public int getDividerPosition() {
        return this.pos;
    }

    public Component getLeftComponent() {
        return this.c1.get(0);
    }

    public Component getTopComponent() {
        return this.c1.get(0);
    }

    public Component getRightComponent() {
        return this.c2.get(0);
    }

    public Component getBottomComponent() {
        return this.c2.get(0);
    }

    public void setLeftComponent(Component c) {
        this.c1.set(0, c);
        this.sendOnResize();
    }

    public void setTopComponent(Component c) {
        this.c1.set(0, c);
        this.sendOnResize();
    }

    public void setRightComponent(Component c) {
        this.c2.set(0, c);
        this.sendOnResize();
    }

    public void setBottomComponent(Component c) {
        this.c2.set(0, c);
        this.sendOnResize();
    }

    @Override
    public void onEvent(String event, String[] args) {
        switch (event) {
            case "dividerpos": {
                for (String arg : args) {
                    if (!arg.startsWith("pos=")) continue;
                    this.pos = Integer.valueOf(arg.substring(4));
                    this.onChanged(null);
                }
                break;
            }
        }
    }
}

