/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.TextComponent;

public class TextArea
extends TextComponent {
    public TextArea(String text) {
        this.text = text;
        this.addEvent("onchange", "onTextChange(event, this);");
        this.addEvent("onkeyup", "onTextChange(event, this);");
        this.setClass("textfield");
    }

    @Override
    public String html() {
        return "<textarea" + this.getAttrs() + ">" + this.text + "</textarea>";
    }

    @Override
    public void updateText(String txt) {
        this.sendEvent("settext", new String[]{"text=" + this.text});
    }

    @Override
    public void onChanged(String[] args) {
        int idx = args[0].indexOf("=");
        this.text = this.destringify(args[0].substring(idx + 1));
        super.onChanged(args);
    }

    public void setRows(int rows) {
        this.addAttr("rows", Integer.toString(rows));
    }

    public void setCols(int cols) {
        this.addAttr("cols", Integer.toString(cols));
    }

    public void setMaxLength(int len) {
        this.addAttr("maxlength", Integer.toString(len));
    }

    public void setMinLength(int len) {
        this.addAttr("minlength", Integer.toString(len));
    }
}

