/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.MQTT;

public class MQTTForward {
    private String host;
    private int port = 1883;
    private KeyMgmt keys;
    private String user;
    private String pass;
    private int max_queue_size = 1000;
    private int keep_alive = 30;
    private long last_packet = -1L;
    private ArrayList<Entry> queue = new ArrayList();
    private Object queue_lock = new Object();
    private MQTT client;
    private Object client_lock = new Object();
    private Server server;
    private boolean active;

    public void start(String host, int port) {
        this.start(host, port, null, null, null);
    }

    public void start(String host, int port, KeyMgmt keys) {
        this.start(host, port, keys, null, null);
    }

    public void start(String host, String user, String pass) {
        this.start(host, 1883, null, user, pass);
    }

    public void start(String host, KeyMgmt keys, String user, String pass) {
        this.start(host, 1883, keys, user, pass);
    }

    public void start(String host, int port, String user, String pass) {
        this.start(host, port, null, user, pass);
    }

    public void start(String host, int port, KeyMgmt keys, String user, String pass) {
        this.host = host;
        this.port = port;
        this.keys = keys;
        this.user = user;
        this.pass = pass;
        this.active = true;
        this.server = new Server();
        this.server.start();
    }

    public void stop() {
        this.active = false;
    }

    public void setMaxQueueSize(int size) {
        if (size < 100) {
            size = 100;
        }
        this.max_queue_size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String topic, String msg) {
        Object object = this.queue_lock;
        synchronized (object) {
            if (this.queue.size() > this.max_queue_size) {
                JFLog.log("Error:MQTTForward Queue > " + this.max_queue_size);
                return;
            }
            this.queue.add(new Entry(topic, msg));
            this.queue_lock.notify();
        }
    }

    public void setKeepAlive(int value) {
        this.keep_alive = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.client_lock;
        synchronized (object) {
            if (this.client != null) {
                this.client.disconnect();
                this.client = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry remove() {
        if (this.active) {
            Object object = this.queue_lock;
            synchronized (object) {
                if (this.queue.size() == 0) {
                    try {
                        this.queue_lock.wait(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
                Entry entry = this.queue.remove(0);
                return entry;
            }
        }
        return null;
    }

    private class Server
    extends Thread {
        public int count;

        private Server() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (MQTTForward.this.active) {
                Entry entry = MQTTForward.this.remove();
                if (entry == null) {
                    JF.sleep(500);
                    if (MQTTForward.this.keep_alive <= 0) continue;
                    ++this.count;
                    if (this.count < MQTTForward.this.keep_alive) continue;
                    this.count = 0;
                }
                this.count = 0;
                try {
                    Object object = MQTTForward.this.client_lock;
                    synchronized (object) {
                        if (MQTTForward.this.client != null && MQTTForward.this.keep_alive > 0) {
                            long timeout = System.currentTimeMillis() - (long)(MQTTForward.this.keep_alive * 1000 * 2);
                            if (MQTTForward.this.client.getLastPacketTimestamp() < timeout) {
                                MQTTForward.this.reconnect();
                            }
                        }
                        if (MQTTForward.this.client != null && !MQTTForward.this.client.isConnected()) {
                            MQTTForward.this.reconnect();
                        }
                        while (MQTTForward.this.client == null) {
                            MQTTForward.this.client = new MQTT();
                            if (MQTTForward.this.keys == null) {
                                if (!MQTTForward.this.client.connect(MQTTForward.this.host, MQTTForward.this.port)) {
                                    MQTTForward.this.client = null;
                                }
                            } else if (!MQTTForward.this.client.connect(MQTTForward.this.host, MQTTForward.this.port, MQTTForward.this.keys)) {
                                MQTTForward.this.client = null;
                            }
                            if (MQTTForward.this.client != null) {
                                if (MQTTForward.this.user != null && MQTTForward.this.pass != null) {
                                    MQTTForward.this.client.connect(MQTTForward.this.user, MQTTForward.this.pass);
                                } else {
                                    MQTTForward.this.client.connect();
                                }
                            }
                            if (MQTTForward.this.client == null) continue;
                            if (MQTTForward.this.client.isConnected()) break;
                            MQTTForward.this.client = null;
                            JF.sleep(1000);
                        }
                        if (entry != null) {
                            MQTTForward.this.client.publish(entry.topic, entry.msg);
                        } else {
                            MQTTForward.this.client.ping();
                        }
                    }
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }
    }

    private static class Entry {
        public String topic;
        public String msg;

        public Entry(String topic, String msg) {
            this.topic = topic;
            this.msg = msg;
        }
    }
}

