/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;

public class Telnet {
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    public static final char SE = '\u00f0';
    public static final char NOP = '\u00f1';
    public static final char DM = '\u00f2';
    public static final char BRK = '\u00f3';
    public static final char IP = '\u00f4';
    public static final char AO = '\u00f5';
    public static final char AYT = '\u00f6';
    public static final char EC = '\u00f7';
    public static final char EL = '\u00f8';
    public static final char GA = '\u00f9';
    public static final char SB = '\u00fa';
    public static final char WILL = '\u00fb';
    public static final char WONT = '\u00fc';
    public static final char DO = '\u00fd';
    public static final char DONT = '\u00fe';
    public static final char IAC = '\u00ff';
    public static final char TO_BINARY = '\u0000';
    public static final char TO_ECHO = '\u0001';
    public static final char TO_SGO = '\u0003';
    public static final char TO_TM = '\u0006';
    public static final char TO_TT = '\u0018';
    public static final char TO_EOR = '\u0019';
    public static final char TO_NWS = '\u001f';
    public static final char TO_RFC = '!';
    public static final char TT_REPLY = '\u0000';
    public static final char TT_REQUEST = '\u0001';
    public static final char[] pre_tt = new char[]{'\u00ff', '\u00fa', '\u0018', '\u0000'};
    public static final char[] post_tt = new char[]{'\u00ff', '\u00f0'};

    public boolean connect(String host, int port) {
        try {
            this.socket = new Socket(host, port);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean connectSSL(String host, int port, KeyMgmt keys) {
        try {
            this.socket = JF.connectSSL(host, port, keys);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean connectSSL(Socket rawSocket, KeyMgmt keys) {
        try {
            this.socket = JF.connectSSL(rawSocket, keys);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }
}

