/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import javaforce.gl.Plane3;
import javaforce.gl.Vector3;

public class Frustum {
    private Vector3 ntl = new Vector3();
    private Vector3 ntr = new Vector3();
    private Vector3 nbl = new Vector3();
    private Vector3 nbr = new Vector3();
    private Vector3 ftl = new Vector3();
    private Vector3 ftr = new Vector3();
    private Vector3 fbl = new Vector3();
    private Vector3 fbr = new Vector3();
    private float nearD;
    private float farD;
    private float nw;
    private float nh;
    private float fw;
    private float fh;
    private Plane3[] pl;
    private Vector3 nc = new Vector3();
    private Vector3 fc = new Vector3();
    private Vector3 X = new Vector3();
    private Vector3 Y = new Vector3();
    private Vector3 Z = new Vector3();
    private Vector3 XX = new Vector3();
    private Vector3 YY = new Vector3();
    private Vector3 ZZ = new Vector3();
    private Vector3 _p;
    private Vector3 _l;
    private Vector3 _u;
    private static final float ANG2RAD = (float)Math.PI / 180;
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private static final int NEARP = 4;
    private static final int FARP = 5;
    public static final int OUTSIDE = 0;
    public static final int INTERSECT = 1;
    public static final int INSIDE = 2;

    public Frustum() {
        this.pl = new Plane3[6];
        for (int a = 0; a < 6; ++a) {
            this.pl[a] = new Plane3();
        }
    }

    public void setPerspecive(float angle, float ratio, float near, float far) {
        this.nearD = near;
        this.farD = far;
        float tan = (float)Math.tan((double)(angle * ((float)Math.PI / 180)) * 0.5);
        this.nh = this.nearD * tan;
        this.nw = this.nh * ratio;
        this.fh = this.farD * tan;
        this.fw = this.fh * ratio;
    }

    public void setPosition(Vector3 p, Vector3 l, Vector3 u) {
        this._p = p;
        this._l = l;
        this._u = u;
        this.Z.sub(p, l);
        this.Z.normalize();
        this.X.cross(u, this.Z);
        this.X.normalize();
        this.Y.cross(this.Z, this.X);
        this.ZZ.set(this.Z);
        this.ZZ.scale(this.nearD);
        this.nc.sub(p, this.ZZ);
        this.ZZ.set(this.Z);
        this.ZZ.scale(this.farD);
        this.fc.sub(p, this.ZZ);
        this.YY.set(this.Y);
        this.YY.scale(this.nh);
        this.XX.set(this.X);
        this.XX.scale(this.nw);
        this.ntl.add(this.nc, this.YY);
        this.ntl.sub(this.XX);
        this.ntr.add(this.nc, this.YY);
        this.ntr.add(this.XX);
        this.nbl.sub(this.nc, this.YY);
        this.nbl.sub(this.XX);
        this.nbr.sub(this.nc, this.YY);
        this.nbr.add(this.XX);
        this.YY.set(this.Y);
        this.YY.scale(this.fh);
        this.XX.set(this.X);
        this.XX.scale(this.fw);
        this.ftl.add(this.fc, this.YY);
        this.ftl.sub(this.XX);
        this.ftr.add(this.fc, this.YY);
        this.ftr.add(this.XX);
        this.fbl.sub(this.fc, this.YY);
        this.fbl.sub(this.XX);
        this.fbr.sub(this.fc, this.YY);
        this.fbr.add(this.XX);
        this.pl[0].set3Points(this.ntr, this.ntl, this.ftl);
        this.pl[1].set3Points(this.nbl, this.nbr, this.fbr);
        this.pl[2].set3Points(this.ntl, this.nbl, this.fbl);
        this.pl[3].set3Points(this.nbr, this.ntr, this.fbr);
        this.pl[4].set3Points(this.ntl, this.ntr, this.nbr);
        this.pl[5].set3Points(this.ftr, this.ftl, this.fbl);
    }

    public int pointInside(Vector3 p) {
        int result = 2;
        for (int i = 0; i < 6; ++i) {
            float d = this.pl[i].distance(p);
            if (d < 0.0f) {
                return 0;
            }
            if (d != 0.0f) continue;
            result = 1;
        }
        return result;
    }

    public int sphereInside(Vector3 p, float size) {
        int result = 2;
        for (int i = 0; i < 6; ++i) {
            float distance = this.pl[i].distance(p);
            if (distance < -size) {
                return 0;
            }
            if (!(distance < size)) continue;
            result = 1;
        }
        return result;
    }

    public int boxInside(Vector3[] pts) {
        int result = 2;
        for (int i = 0; i < 6; ++i) {
            int out = 0;
            int in = 0;
            for (int k = 0; k < 8 && (in == 0 || out == 0); ++k) {
                if (this.pl[i].distance(pts[k]) < 0.0f) {
                    ++out;
                    continue;
                }
                ++in;
            }
            if (in == 0) {
                return 0;
            }
            if (out <= 0) continue;
            result = 1;
        }
        return result;
    }

    public void print() {
        System.out.println(String.format("GLFrustum:%7.3f,%7.3f,%7.3f,%7.3f", Float.valueOf(this.nw), Float.valueOf(this.nh), Float.valueOf(this.fw), Float.valueOf(this.fh)));
        System.out.println(String.format("GLFrustum:p:%7.3f,%7.3f,%7.3f", Float.valueOf(this._p.v[0]), Float.valueOf(this._p.v[1]), Float.valueOf(this._p.v[2])));
        System.out.println(String.format("GLFrustum:l:%7.3f,%7.3f,%7.3f", Float.valueOf(this._l.v[0]), Float.valueOf(this._l.v[1]), Float.valueOf(this._l.v[2])));
        System.out.println(String.format("GLFrustum:u:%7.3f,%7.3f,%7.3f", Float.valueOf(this._u.v[0]), Float.valueOf(this._u.v[1]), Float.valueOf(this._u.v[2])));
        for (int a = 0; a < 6; ++a) {
            this.pl[a].print();
        }
    }
}

