/*
 * Decompiled with CFR 0.152.
 */
package javaforce.jbus;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jbus.Dispatch;

public class JBusClient
extends Thread {
    public String pack;
    private Object obj;
    private Class<?> cls;
    private Dispatch dispatch;
    private Socket s;
    private InputStream is;
    private OutputStream os;
    private volatile boolean ready;
    private boolean debug = false;
    private int port = 777;

    public JBusClient(String pack, Object obj) {
        if (pack == null || obj == null) {
            return;
        }
        this.pack = pack;
        this.obj = obj;
        this.cls = obj.getClass();
    }

    public void setDispatch(Dispatch dispatch) {
        this.dispatch = dispatch;
    }

    public void setDebug(boolean state) {
        this.debug = state;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void run() {
        block11: {
            try {
                String cmd;
                JFLog.log("JBusClient:connecting to 127.0.0.1:" + this.port);
                this.s = new Socket(InetAddress.getByName("127.0.0.1"), this.port);
                this.is = this.s.getInputStream();
                this.os = this.s.getOutputStream();
                if (this.pack != null) {
                    this.os.write(("cmd.package=" + this.pack + "\n").getBytes());
                    this.os.flush();
                    if (this.debug) {
                        JFLog.log("JBus Client registered as : " + this.pack);
                    }
                }
                this.ready = true;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                while (this.s.isConnected() && (cmd = br.readLine()) != null) {
                    try {
                        this.doCmd(cmd);
                    }
                    catch (InvocationTargetException ite) {
                        Throwable cause = ite.getCause();
                        if (cause == null) {
                            JFLog.log(ite);
                            continue;
                        }
                        JFLog.log(cause);
                    }
                    catch (Exception e1) {
                        JFLog.log(e1);
                    }
                }
            }
            catch (SocketException e2) {
                if (this.debug) {
                    JFLog.log("JBus Client closed : " + this.pack);
                }
            }
            catch (Exception e3) {
                if (!this.debug) break block11;
                JFLog.log(e3);
            }
        }
    }

    private void doCmd(String cmd) throws Exception {
        int idx;
        if (cmd.startsWith("cmd.")) {
            return;
        }
        if (this.cls == null) {
            if (this.dispatch != null) {
                this.dispatch.onMessage(cmd);
            }
            return;
        }
        int b1 = cmd.indexOf("(");
        int b2 = cmd.length() - 1;
        String argsString = cmd.substring(b1 + 1, b2);
        String packFunc = cmd.substring(0, b1);
        String call_pack = packFunc.substring(0, idx = packFunc.lastIndexOf(46));
        if (!call_pack.equals(this.pack)) {
            throw new Exception("package mismatch");
        }
        String call_func = packFunc.substring(idx + 1);
        if (this.debug) {
            JFLog.log("call:" + call_pack + "." + call_func + "(" + argsString + ")");
        }
        Object[] args = this.parseArgs(argsString);
        int argsLength = args.length;
        Class[] types2 = new Class[argsLength];
        for (int a = 0; a < argsLength; ++a) {
            types2[a] = args[a] instanceof Integer ? Integer.TYPE : args[a].getClass();
        }
        if (this.debug) {
            JFLog.log("jbusclient:lookup method");
        }
        Method method = this.cls.getMethod(call_func, types2);
        if (this.debug) {
            JFLog.log("jbusclient:invoke method");
        }
        method.invoke(this.obj, args);
    }

    private Object[] parseArgs(String args) throws Exception {
        ArrayList<Object> ret = new ArrayList<Object>();
        int len = args.length();
        for (int pos = 0; pos < len; ++pos) {
            if (args.charAt(pos) == '\"') {
                int q1 = pos;
                int q2 = args.indexOf(34, q1 + 1);
                String str = args.substring(q1 + 1, q2);
                ret.add(str);
                pos = q2 + 1;
            } else {
                int nxt = args.indexOf(44, pos);
                if (nxt == -1) {
                    nxt = len;
                }
                Integer i = Integer.valueOf(args.substring(pos, nxt));
                ret.add(i);
                pos = nxt;
            }
            if (pos >= len) break;
            if (args.charAt(pos) == ',') continue;
            throw new Exception("bad args");
        }
        return ret.toArray();
    }

    public boolean call(String pack, String func, String args) {
        return this.call(pack + "." + func + "(" + args + ")\n");
    }

    public boolean call(String pfa) {
        int cnt = 0;
        while (!this.ready) {
            if (++cnt == 30) {
                return false;
            }
            JF.sleep(100);
        }
        try {
            this.os.write(pfa.getBytes());
            this.os.flush();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean broadcast(String pack, String func, String args) {
        return this.call("cmd.broadcast=" + pack + "." + func + "(" + args + ")\n");
    }

    public boolean ready() {
        return this.ready;
    }

    public void close() {
        try {
            this.s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.s = null;
    }

    public static String quote(String str) {
        return "\"" + str + "\"";
    }

    public static String encodeString(String in) {
        try {
            return URLEncoder.encode(in, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decodeString(String in) {
        try {
            return URLDecoder.decode(in, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encodeByteArray(byte[] ba) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        for (int a = 0; a < ba.length; ++a) {
            sb.append(String.format("%02x", ba[a] & 0xFF));
        }
        sb.append("\"");
        return sb.toString();
    }

    public static byte[] decodeByteArray(String str) {
        int len;
        if (str.length() == 0) {
            return new byte[0];
        }
        if (str.charAt(0) == '\"') {
            str = str.substring(1, str.length() - 1);
        }
        if ((len = str.length() / 2) * 2 != str.length()) {
            JFLog.log("JBusClient.decodeByteArray:Error:str.length()=" + str.length());
            return new byte[0];
        }
        byte[] ba = new byte[len];
        for (int a = 0; a < len; ++a) {
            int pos = a * 2;
            ba[a] = (byte)Integer.parseInt(str.substring(pos, pos + 2), 16);
        }
        return ba;
    }
}

